unit RpVisualParams;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons;

type
  TRpVisualParamsForm = class(TForm)
    list: TListView;
    btAdd: TButton;
    btDel: TButton;
    Label17: TLabel;
    btSave: TBitBtn;
    procedure btSaveClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure LoadFromIni;
    procedure SaveToIni;
  end;

  function rpVisualParams_Read(prm_name, prm_descr, prm_value_def: string): string;
  function rpVisualParams_getDescr(prm_name: string): string;
  procedure rpVisualParams_Write(prm_name, prm_descr, prm_value: string);

var
  RpVisualParamsForm: TRpVisualParamsForm;  

implementation
uses
  RpVisualGlobal,
  RpVisualParamProp,
  inifiles;

{$R *.dfm}

{ TRpVisualParamsForm }

procedure TRpVisualParamsForm.LoadFromIni;
var
  l: TStringList;
  i: integer;
  s: string;
begin
  l := TStringList.Create;
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    ReadSection('RpVisualParams', l);

    for i:=0 to l.Count-1 do
      with list.Items.Add do begin
        Caption := l[i];
        s := ReadString('RpVisualParams', l[i], '');
        SubItems.Add(copy(s,1,pos('~',s)-1));
        SubItems.Add(copy(s,pos('~',s)+1, length(s)));
      end;

  finally
    Free;
  end;
  l.Free;
end;

procedure TRpVisualParamsForm.SaveToIni;
var
  i: integer;
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    for i:=0 to list.Items.Count-1 do
      WriteString('RpVisualParams', list.Items[i].Caption,
            list.Items[i].SubItems[0]+'~'+list.Items[i].SubItems[1]);

    ShowMessage('   !');
  finally
    Free;
  end;

end;

procedure TRpVisualParamsForm.btSaveClick(Sender: TObject);
begin
  SaveToIni;
end;

procedure TRpVisualParamsForm.btAddClick(Sender: TObject);
var
  edit_mode: boolean;
begin
  edit_mode := sender = list;
  if (edit_mode) and (list.Selected=nil) then exit;

  with TrpVisualParamPropForm.Create(self) do try
    if edit_mode then begin
      edName.Text := list.Selected.Caption;
      edDescr.Text := list.Selected.SubItems[0];
      edValue.Text := list.Selected.SubItems[1];
      edName.Enabled := false;
    end;

    if ShowModal=mrOk then begin
      if not edit_mode then begin
        list.Selected := list.Items.Add;
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
      end;

      with list.Selected do begin
        list.Selected.Caption := edName.Text;
        list.Selected.SubItems[0] := edDescr.Text;
        list.Selected.SubItems[1] := edValue.Text;
      end;

      rpVisualParams_Write(edName.Text, edDescr.Text, edValue.Text);
    end;
  finally
    free;
  end;
end;

procedure TRpVisualParamsForm.btDelClick(Sender: TObject);
begin
  if (list.Selected=nil) then exit;

  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    DeleteKey('RpVisualParams', list.Selected.Caption);
  finally
    free;
  end;

  list.Selected.Delete;
end;



function rpVisualParams_Read(prm_name, prm_descr, prm_value_def: string): string;
var
  s: string;
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    s := ReadString('RpVisualParams', prm_name, '');
    if s='' then begin
      WriteString('RpVisualParams', prm_name, prm_descr + '~' + prm_value_def);
      result := prm_value_def;
    end else begin
      prm_descr := copy(s,1,pos('~',s)-1);
      result := copy(s,pos('~',s)+1, length(s));
    end;  
  finally
    Free;
  end;
end;

function rpVisualParams_getDescr(prm_name: string): string;
var
  s: string;
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    s := ReadString('RpVisualParams', prm_name, '');
    if s='' then begin
      result := '';
    end else begin
      result := copy(s,1,pos('~',s)-1);
    end;
  finally
    Free;
  end;
end;

procedure rpVisualParams_Write(prm_name, prm_descr, prm_value: string);
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteString('RpVisualParams', prm_name, prm_descr + '~' + prm_value);
  finally
    Free;
  end;
end;


end.
