unit SQBA_Params;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, ScadaBase, VisLabel,
  Menus, VisControl;

type
  TSQBA_ParamsForm = class(TForm)
    list: TListView;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    btSetOn: TBitBtn;
    btSetOff: TBitBtn;
    lbDlyStop1: TLabel;
    vlQntStart: TVisLabel;
    Label1: TLabel;
    vlQntStop: TVisLabel;                                     
    Bevel1: TBevel;
    Timer2: TTimer;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    miSetOn: TMenuItem;
    miSetOff: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure btSetOnClick(Sender: TObject);
    procedure VisGetTagIndex(TagName: String; var TagIndex: Integer);
    procedure VisGetTagValue(TagIndex: Integer; var Value: Integer);
    procedure VisSetTagValue(TagIndex, Value: Integer);
    procedure Timer2Timer(Sender: TObject);
    procedure vlQntStartClick(Sender: TObject);
    procedure listColumnClick(Sender: TObject; Column: TListColumn);
    { Private declarations }
  public
    TagPath: string;
    TagRoot: string;
    filename: string;
  end;

var
  SQBA_ParamsForm: TSQBA_ParamsForm;

implementation
uses
  InputDialog,
  RpVisualUtils,
  RpVisualGlobal, 
  meslogging,
  connecting,
  TagStorage,
  numbers;

{$R *.dfm}

procedure TSQBA_ParamsForm.VisGetTagIndex(TagName: String;
  var TagIndex: Integer);
begin
  TagIndex := GetTagIndex(TagName);
end;

procedure TSQBA_ParamsForm.VisGetTagValue(TagIndex: Integer;
  var Value: Integer);
begin
  Value := GetTagValue(TagIndex);
end;

procedure TSQBA_ParamsForm.VisSetTagValue(TagIndex, Value: Integer);
begin
  SetTagValue(TagIndex, Value);
end;


procedure TSQBA_ParamsForm.FormActivate(Sender: TObject);
var
  i,k: integer;
  s,s1,s2,mask,m1,m2,m3: string;
  li: TListItem;
  F: TextFile;
begin
  vlQntStart.TagPath := TagPath;
  vlQntStart.TagRoot := TagRoot;

  vlQntStop.TagPath := TagPath;
  vlQntStop.TagRoot := TagRoot;

  CustomScanScadaObjects(self, InitDeviceProc);


  list.Items.BeginUpdate;

  m1 := TagPath + '.SQBA_' + TagRoot + '_';
  m2 := '_ValOn';
  m3 := '_ValOff';
  mask := m1 + '*' + m2;

  //    
  i:=0;
  repeat
    s := GetTagName(i);

    if CheckFilter(s, mask) then begin
      s1 := s;

      delete(s, 1, length(m1));
      delete(s, length(s)-length(m2)+1, length(m2));
      s2 := m1 + s + m3;

      k := GetTagIndex(s2);
      if k>-1 then
        with list.Items.Add do begin
          caption := s;
          SubItems.Add('');               //0
          SubItems.Add('');               //1
          SubItems.Add('');               //2
          SubItems.Add(s1);               //3
          SubItems.Add(s2);               //4
          SubItems.Add(inttostr(i));      //5
          SubItems.Add(inttostr(k));      //6
        end;
    end;

    inc(i);
  until s='';

  //   
  AssignFile(F, filename);
  try
    reset(F);
    while not eof(F) do begin
      readln(F, s);
      k := pos(';',s);
      if k=0 then continue;
      s1 := copy(s,1,k-1);
      s2 := copy(s,k+1,length(s)-k);
      li := list.FindCaption(0, s1, false, false, false);
      if li<>nil then li.SubItems[0] := s2;
    end;
  except
  end;

  try
    CloseFile(F);
  except
  end;


  list.Items.EndUpdate;
end;

procedure TSQBA_ParamsForm.BitBtn2Click(Sender: TObject);
var
  s: string;
  i: integer;
  F: TextFile;
begin
  // 
  if list.Selected=nil then exit;
  s := list.Selected.SubItems[0];
  if ShowInputDialog(' ', '  ', s) then
    list.Selected.SubItems[0] := s;


  AssignFile(F, filename);
  try
    rewrite(F);
    for i:=0 to list.Items.Count-1 do begin
      s := list.Items[i].Caption + ';' + list.Items[i].SubItems[0];
      writeln(F, s); 
    end;
  except
  end;

  try
    CloseFile(F);
  except
  end;


end;

procedure TSQBA_ParamsForm.btSetOnClick(Sender: TObject);

    procedure _do(a1,a2,a3: integer);
    var
      s: string;
      v,i: integer;
    begin
      s := list.Selected.SubItems[a1];
      if ShowInputDialog(' ', ' ', s) then begin
        val(s, v, i);
        if (v < 0) then exit;
        if (v > a3) then exit;
        SetTagValue( strtoint(list.Selected.SubItems[a2]), v);
        SaveMessage(14, list.Selected.Caption + ' '  + list.Selected.SubItems[0] ,
              '  = ' + inttostr(v));
      end;
    end;

begin
  //  
  if list.Selected=nil then exit;
  if (sender = btSetOn) or (sender = miSetOn) then _do(1, 5, vlQntStart.gettagval(0));
  if (sender = btSetOff) or (sender = miSetOff) then _do(2, 6, vlQntStop.gettagval(0));
end;

procedure TSQBA_ParamsForm.Timer2Timer(Sender: TObject);
var
  i: integer;
  s: string;
begin
  if not rvgLogIn then exit;
  CustomScanScadaObjects(self, UpdateDeviceProc);

  for i:=0 to list.Items.Count-1 do begin
    s := inttostr(GetTagValue(strtoint(list.Items[i].SubItems[5])));
    if not SameText(s, list.Items[i].SubItems[1]) then
      list.Items[i].SubItems[1] := s;

    s := inttostr(GetTagValue(strtoint(list.Items[i].SubItems[6])));
    if not SameText(s, list.Items[i].SubItems[2]) then
      list.Items[i].SubItems[2] := s;
  end;
end;

procedure TSQBA_ParamsForm.vlQntStartClick(Sender: TObject);
var
  s: string;
  i,j: integer;
begin
  with sender as TVisLabel do begin
    s := inttostr(gettagval(0));
    if ShowInputDialog(' ', ' ', s) then begin
      val(s, i, j);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, self.Caption, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;

end;

function CustomSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
begin
  if ParamSort = 0 then
    Result := CompareText(Item1.Caption,Item2.Caption)
  else

  if ParamSort = 1 then
    Result := CompareText(Item1.SubItems[0],Item2.SubItems[0])
  else

    Result := strtoint(Item1.SubItems[ParamSort-1]) - strtoint(Item2.SubItems[ParamSort-1]);

end;

procedure TSQBA_ParamsForm.listColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  list.CustomSort(@CustomSortProc, Column.Index);
end;

end.
