unit SclaProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, VisDltB,
  VisStatusShape, VisZDVH, VisZDVT, jpeg, SimpleLine, PolyLine, VisButton,
  Buttons, VisLabel, ComCtrls, VisNumericPanel;

type
  TSclaPropForm = class(TForm)
    BitBtn1: TBitBtn;
    Button2: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Timer1: TTimer;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label33: TLabel;
    Label25: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Timer2: TTimer;
    Bevel3: TBevel;
    lbValue: TLabel;
    Label10: TLabel;
    lbPercent: TLabel;
    Label15: TLabel;
    VisLabel11: TVisLabel;
    pnlReq1: TVisNumericPanel;
    VisNumericPanel1: TVisNumericPanel;
    VisNumericPanel2: TVisNumericPanel;
    VisNumericPanel3: TVisNumericPanel;
    VisNumericPanel4: TVisNumericPanel;
    VisNumericPanel5: TVisNumericPanel;
    VisNumericPanel6: TVisNumericPanel;
    VisNumericPanel7: TVisNumericPanel;
    VisNumericPanel8: TVisNumericPanel;
    VisNumericPanel9: TVisNumericPanel;
    VisNumericPanel10: TVisNumericPanel;
    Panel1: TPanel;
    VisLabel8: TVisLabel;
    SimpleLine1: TSimpleLine;
    SimpleLine2: TSimpleLine;
    SimpleLine3: TSimpleLine;
    SimpleLine4: TSimpleLine;
    SimpleLine5: TSimpleLine;
    SimpleLine6: TSimpleLine;
    SimpleLine7: TSimpleLine;
    SimpleLine8: TSimpleLine;
    SimpleLine11: TSimpleLine;
    SimpleLine12: TSimpleLine;
    SimpleLine13: TSimpleLine;
    Label9: TLabel;
    Label11: TLabel;
    procedure VisualDeviceClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure VisLabelBlokClick(Sender: TObject);
  private
  public
    TagPath: string;
    TagRoot: string;
    DeviceName: string;
  end;


  procedure _Scla_Click(AOwner: TComponent; Sender: TObject;
    DeviceName, ValueText, PercentText: string;
    ValueDiv, Precision: integer);

implementation
uses
  RpVisualGlobal,
  users,
  numbers,
  TagStorage,
  RpVisualLegacyPanels,
  RpVisualMain,
  connecting,
  meslogging,
  SetChannel,
  trendwindow;

var
  _DeviceName: string;
  _TagPath: string;
  _TagRoot: string;
  _ValueDiv: integer;
  _Precision: integer;

{$R *.dfm}

procedure TSclaPropForm.VisualDeviceClick(Sender: TObject);
begin
//  _VisualDeviceClick(sender);
end;

procedure _proc(Target: TCustomScadaObject);
begin
  if Target is TCustomScadaObject then
    with Target as TCustomScadaObject do begin
      TagPath := _TagPath;
      TagRoot := _TagRoot;
    end;

  if Target is TVisNumericPanel then
    with Target as TVisNumericPanel do begin
      SaveMessageStr := _DeviceName;
      if Tag=1 then begin
        ValueDiv := _ValueDiv;
        Precision := _Precision;
      end;
    end;
end;

procedure TSclaPropForm.FormActivate(Sender: TObject);
begin
  TabSheet2.TabVisible := CheckAccess(PREVILEG_PRM_SPEC1, false);

  _TagPath := TagPath;
  _TagRoot := TagRoot;
  Caption := DeviceName;
  CustomScanScadaObjects(self, _proc);
  CustomScanScadaObjects(self, InitDeviceProc);

  Timer1Timer(nil);
end;

procedure TSclaPropForm.Timer1Timer(Sender: TObject);
begin
  if not rvgLogIn then exit;
  CustomScanScadaObjects(self, UpdateDeviceProc);
end;



procedure TSclaPropForm.VisLabelBlokClick(Sender: TObject);
var
  i: integer;
begin
  with sender as TVisLabel do begin
    i := iif(gettagval(0)=1, 0, 1);
    SetTagValue(gettagidx(0), i);
    SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + iif(i=0, '', '') );
  end;
end;


procedure TSclaPropForm.Button2Click(Sender: TObject);
begin
  ShowTrendWindow(
      DeviceName + ', %',
      TagPath + '.SCLA_' + TagRoot + '_Percent',
      '',
      'scla_',
      ''
    );

end;


procedure _Scla_Click(AOwner: TComponent; Sender: TObject;
    DeviceName, ValueText, PercentText: string;
    ValueDiv, Precision: integer);
var
  w: TSclaPropForm;
begin
  if not rvgLogIn then exit;

  w := TSclaPropForm.Create(AOwner);
  w.Caption := DeviceName;
  _DeviceName := DeviceName;
  w.DeviceName := DeviceName;
  w.lbValue.Caption := ValueText;
  w.lbPercent.Caption := PercentText;
  _ValueDiv := ValueDiv;
  _Precision := Precision;

  with sender as TCustomScadaObject do try
    w.TagPath := TagPath;
    w.TagRoot := TagRoot;
    w.ShowModal;
  finally
    w.Free;
  end;
end;



end.
