unit DatSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Grids, DBGrids, Db, Buttons;

type
  TDatSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    InpValuePanel: TPanel;
    LevelPanel: TPanel;
    Label2: TLabel;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    Label3: TLabel;
    HighRangePanel: TPanel;
    LowRangePanel: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    DlyOutPanel: TPanel;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure LevelPanelClick(Sender: TObject);
    procedure DlyOutPanelClick(Sender: TObject);
    procedure HighRangePanelClick(Sender: TObject);
    procedure LowRangePanelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FTagRksvInpValue: integer;
    FTagRksvLevel: integer;
    FTagRksvLowRange: integer;
    FTagRksvHighRange: integer;
    FTagRksvDlyOut: integer;

    FRksvInpValue: integer;
    FRksvLevel: integer;
    FRksvLowRange: integer;
    FRksvHighRange: integer;
    FRksvDlyOut: integer;

    FTimerCnt: integer;

    FMesTagName: string;

  public
    { Public declarations }
    TagName: string;
    TagPath: string;
    DatName: string;

    procedure Init;
    procedure Process;
  end;

//var
//  DatSetPanelForm: TDatSetPanelForm;

implementation
uses
  MesConst, TagStorage, MesLogging,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;

{$R *.DFM}

{ TDatSetPanelForm }
procedure TDatSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(100.0);
end;


procedure TDatSetPanelForm.FormActivate(Sender: TObject);
begin
  Update;
  Init;
  TrendsFrame.CreateTrends(
      TagPath + '.RKSV_'+TagName+'_InpValue' + ';' +
      TagPath + '.RKSV_'+TagName+'_Output');
end;


procedure TDatSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TDatSetPanelForm.Init;
var
  s: string;
begin
  (self as TDatSetPanelForm).Caption := '  "' + DatName + '"';

  s := TagPath + '.RKSV_' + TagName + '_InpValue';
  FTagRksvInpValue := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_Level';
  FTagRksvLevel := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_LowRange';
  FTagRksvLowRange := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_HighRange';
  FTagRksvHighRange := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_DlyOut';
  FTagRksvDlyOut := GetTagIndex(s);

  FMesTagName := TagPath + '.RKSV_'+TagName+'_Alarm';

  FRksvInpValue := -1;
  FRksvLevel := -1;
  FRksvLowRange := -1;
  FRksvHighRange := -1;
  FRksvDlyOut := -1;

  Timer.Enabled := true;

  Process;
end;

procedure TDatSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;

  inc(FTimerCnt);
  if FTimerCnt >= 8 then begin
    FTimerCnt := 0;
    TrendsFrame.OnLineUpdateTrends;
  end;
end;


procedure TDatSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;

procedure TDatSetPanelForm.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagRksvInpValue );
  if value <> FRksvInpValue then begin
    InpValuePanel.Caption := IntToStr(value);
    FRksvInpValue := value;
  end;

  value := GetTagValue( FTagRksvLevel );
  if value <> FRksvLevel then begin
    LevelPanel.Caption := IntToStr(value);
    FRksvLevel := value;
  end;

  value := GetTagValue( FTagRksvLowRange );
  if value <> FRksvLowRange then begin
    LowRangePanel.Caption := IntToStr(value);
    FRksvLowRange := value;
  end;

  value := GetTagValue( FTagRksvHighRange );
  if value <> FRksvHighRange then begin
    HighRangePanel.Caption := IntToStr(value);
    FRksvHighRange := value;
  end;

  value := GetTagValue( FTagRksvDlyOut );
  if value <> FRksvDlyOut then begin
    DlyOutPanel.Caption := IntToStr(value);
    FRksvDlyOut := value;
  end;
end;



procedure TDatSetPanelForm.LevelPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetTagValueDlg( FTagRksvLevel, '  , ', v) then
    SaveMessageText(mcParam_text, FMesTagName,
        IntToStr(v - GetTagValue(FTagRksvLowRange)) + ' - ' +
        IntToStr(v + GetTagValue(FTagRksvHighRange)), mcParam_bc, mcParam_fc);
end;

procedure TDatSetPanelForm.DlyOutPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetTagValueDlg( FTagRksvDlyOut, '   , ', v) then
    SaveMessageText(mcParam_text, FMesTagName, ' ='+IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TDatSetPanelForm.HighRangePanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetTagValueDlg( FTagRksvHighRange, '   "", ', v) then
    SaveMessageText(mcParam_text, FMesTagName, ' ""='+
        IntToStr(GetTagValue(FTagRksvLevel) - GetTagValue(FTagRksvLowRange)) + ' - ' +
        IntToStr(GetTagValue(FTagRksvLevel) + v), mcParam_bc, mcParam_fc);
end;

procedure TDatSetPanelForm.LowRangePanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetTagValueDlg( FTagRksvLowRange, '   "", ', v) then
    SaveMessageText(mcParam_text, FMesTagName, ' ""='+
        IntToStr(GetTagValue(FTagRksvLevel) - v) + ' - ' +
        IntToStr(GetTagValue(FTagRksvLevel) + GetTagValue(FTagRksvHighRange)), mcParam_bc, mcParam_fc);
end;

end.
