unit DevSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Buttons;

type
  TDevSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    TimeStartPanel: TPanel;
    TimeStopPanel: TPanel;
    Label2: TLabel;
    SaveButton: TButton;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure TimeStartPanelClick(Sender: TObject);
    procedure TimeStopPanelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
  private
    { Private declarations }
    FTagMachTimeStart: integer;
    FTagMachTimeStop: integer;
    FMachTimeStart: integer;
    FMachTimeStop: integer;

    FTimerCnt: integer;
    FMesTagName: string;
  public
    { Public declarations }
    TagName: string;
    TagPath: string;
    DeviceName: string;

    procedure Init;
    procedure Process;
  end;

//var
//  DevSetPanelForm: TDevSetPanelForm;

implementation
uses
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  MesConst, TagStorage, MesLogging;

{$R *.DFM}

{ TDevSetPanelForm }

procedure TDevSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(10.0);
end;


procedure TDevSetPanelForm.FormActivate(Sender: TObject);
begin
  (self as TDevSetPanelForm).Update;
  Init;
  TrendsFrame.CreateTrends(
      TagPath + '.MACH_'+TagName+'_Sost' + ';' +
      TagPath + '.MACH_'+TagName+'_Plata');
end;


procedure TDevSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TDevSetPanelForm.Init;
var
  s: string;
begin
  (self as TDevSetPanelForm).Caption := '  "' + DeviceName + '"';

  s := TagPath + '.MACH_' + TagName + '_TimeStart';
  FTagMachTimeStart := GetTagIndex(s);
  s := TagPath + '.MACH_' + TagName + '_TimeStop';
  FTagMachTimeStop := GetTagIndex(s);

  FMesTagName := TagPath + '.MACH_'+TagName+'_Alarm';

  FMachTimeStart := -1;
  FMachTimeStop := -1;

  Timer.Enabled := true;

  Process;
end;


procedure TDevSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;

  inc(FTimerCnt);
  if FTimerCnt >= 8 then begin
    FTimerCnt := 0;
    TrendsFrame.OnLineUpdateTrends;
  end;
end;


procedure TDevSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;


procedure TDevSetPanelForm.Process;
var
  value: integer;
begin
  value := GetTagValue( FTagMachTimeStart );
  if value <> FMachTimeStart then begin
    TimeStartPanel.Caption := IntToStr(value);
    FMachTimeStart := value;
  end;

  value := GetTagValue( FTagMachTimeStop );
  if value <> FMachTimeStop then begin
    TimeStopPanel.Caption := IntToStr(value);
    FMachTimeStop := value;
  end;
end;



procedure TDevSetPanelForm.TimeStartPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetTagValueDlg( FTagMachTimeStart, '  , ', v) then
    SaveMessageText(mcParam_text, FMesTagName, IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TDevSetPanelForm.TimeStopPanelClick(Sender: TObject);
var
  v: integer;
begin
  SetTagValueDlg( FTagMachTimeStop, '  , ', v);
end;


procedure TDevSetPanelForm.SaveButtonClick(Sender: TObject);
begin
//  if MessageDlg('  ?', mtConfirmation, [mbYes, mbNo],
//      0) = mrYes then begin
//    SetTagValue(FTagMachTimeStart);
//  end;
end;

end.
