unit MchaSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Buttons, VisMcha;

type
  TMchaSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    TimeStartPanel: TPanel;
    TimeStopPanel: TPanel;
    Label2: TLabel;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    HelpButton: TBitBtn;
    TimerTrends: TTimer;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure TimeStartPanelClick(Sender: TObject);
    procedure TimeStopPanelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TimerTrendsTimer(Sender: TObject);
  private
    FTagMchaTimeStart: integer;
    FTagMchaTimeStop: integer;

    FMessageTagName: string;
  public
    M: TVisMcha;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  MesConst, TagStorage, MesLogging;

{$R *.DFM}

{ TMchaSetPanelForm }

procedure TMchaSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(10.0);
end;


procedure TMchaSetPanelForm.FormActivate(Sender: TObject);
var
  _tagname: string;
begin
  Update;
  Init;
  _tagname := M.expandTagname;
  TrendsFrame.CreateTrends(
      M.TagPath + '.MCHA_'+ _tagName+'_Sost' + ';' +
      M.TagPath + '.MCHA_'+ _tagname+'_Plata');
end;


procedure TMchaSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TimerTrends.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TMchaSetPanelForm.Init;
var
  s: string;
  _tagname: string;
begin
//  (self as TMchaSetPanelForm).Caption := '  "' + DeviceName + '"';
  Caption := '  "' + M.DeviceName + '"';
  FMessageTagName := M.DeviceName;

  _tagname := M.expandTagname;

  s := M.TagPath + '.MCHA_' + _tagName + '_TimeStart';
  FTagMchaTimeStart := GetTagIndex(s);
  s := M.TagPath + '.MCHA_' + _tagName + '_TimeStop';
  FTagMchaTimeStop := GetTagIndex(s);

  Timer.Enabled := true;
  TimerTrends.Enabled := true;
  Process;
end;


procedure TMchaSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;
end;

procedure TMchaSetPanelForm.TimerTrendsTimer(Sender: TObject);
begin
  TrendsFrame.OnLineUpdateTrends;
end;


procedure TMchaSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;


procedure TMchaSetPanelForm.Process;
var
  value: integer;
begin
  value := GetTagValue( FTagMchaTimeStart );
  if not(inttostr(value) = TimeStartPanel.Caption) then
    TimeStartPanel.Caption := IntToStr(value);

  value := GetTagValue( FTagMchaTimeStop );
  if not(inttostr(value) = TimeStopPanel.Caption) then
    TimeStopPanel.Caption := IntToStr(value);
end;



procedure TMchaSetPanelForm.TimeStartPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetAndSaveTagValueDlg( FTagMchaTimeStart, '  , ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, '=' + IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TMchaSetPanelForm.TimeStopPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetAndSaveTagValueDlg( FTagMchaTimeStop, '  , ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, '=' + IntToStr(v), mcParam_bc, mcParam_fc);
end;


end.
