unit MchbSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Buttons, VisMchb;

type
  TMchbSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    TimeStartPanel: TPanel;
    TimeStopPanel: TPanel;
    Label2: TLabel;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    HelpButton: TBitBtn;
    TimerTrends: TTimer;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure TimeStartPanelClick(Sender: TObject);
    procedure TimeStopPanelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure TimerTrendsTimer(Sender: TObject);
  private
    FTagMchbTimeStart: integer;
    FTagMchbTimeStop: integer;

    FMessageTagName: string;
  public
    M: TVisMchb;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  MesConst, TagStorage, MesLogging;

{$R *.DFM}

{ TMchbSetPanelForm }

procedure TMchbSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(10.0);
end;


procedure TMchbSetPanelForm.FormActivate(Sender: TObject);
begin
  Update;
  Init;
  TrendsFrame.CreateTrends(
      M.TagPath + '.MCHB_'+M.TagName+'_Sost' + ';' +
      M.TagPath + '.MCHB_'+M.TagName+'_Plata');
end;


procedure TMchbSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TimerTrends.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TMchbSetPanelForm.Init;
var
  s: string;
begin
//  (self as TMchbSetPanelForm).Caption := '  "' + DeviceName + '"';
  Caption := '  "' + M.DeviceName + '"';
  FMessageTagName := M.DeviceName;

  s := M.TagPath + '.Mchb_' + M.TagName + '_TimeStart';
  FTagMchbTimeStart := GetTagIndex(s);
  s := M.TagPath + '.Mchb_' + M.TagName + '_TimeStop';
  FTagMchbTimeStop := GetTagIndex(s);

  Timer.Enabled := true;
  TimerTrends.Enabled := true;
  Process;
end;


procedure TMchbSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;
end;

procedure TMchbSetPanelForm.TimerTrendsTimer(Sender: TObject);
begin
  TrendsFrame.OnLineUpdateTrends;
end;


procedure TMchbSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;


procedure TMchbSetPanelForm.Process;
var
  value: integer;
begin
  value := GetTagValue( FTagMchbTimeStart );
  if not(inttostr(value) = TimeStartPanel.Caption) then
    TimeStartPanel.Caption := IntToStr(value);

  value := GetTagValue( FTagMchbTimeStop );
  if not(inttostr(value) = TimeStopPanel.Caption) then
    TimeStopPanel.Caption := IntToStr(value);
end;



procedure TMchbSetPanelForm.TimeStartPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetAndSaveTagValueDlg( FTagMchbTimeStart, '  , ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, '=' + IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TMchbSetPanelForm.TimeStopPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetAndSaveTagValueDlg( FTagMchbTimeStop, '  , ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, '=' + IntToStr(v), mcParam_bc, mcParam_fc);
end;


procedure TMchbSetPanelForm.HelpButtonClick(Sender: TObject);
begin
//  ShowCommonHelp('SetPanelMchb.htm');
end;


end.
