unit MdtaSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Buttons, VisMcha;

type
  TMdtaSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    InpValuePanel: TPanel;
    DlyDrebezgPanel: TPanel;
    Label2: TLabel;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    Label3: TLabel;
    HighRangePanel: TPanel;
    LowRangePanel: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    DlyOutputPanel: TPanel;
    TimerTrends: TTimer;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure DlyDrebezgPanelClick(Sender: TObject);
    procedure DlyOutputPanelClick(Sender: TObject);
    procedure HighRangePanelClick(Sender: TObject);
    procedure LowRangePanelClick(Sender: TObject);
    procedure TimerTrendsTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FTagMdtaValue: integer;
    FTagMdtaLow: integer;
    FTagMdtaHigh: integer;
    FTagMdtaDlyDrebezg: integer;
    FTagMdtaDlyOutput: integer;

    FMessageTagName: string;
    v: integer;
  public
    M: TVisMcha;
    DatIndex: integer;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst,
  TagStorage,
  MesLogging,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;

{$R *.DFM}

{ TMdtaSetPanelForm }
procedure TMdtaSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(0);
end;

procedure TMdtaSetPanelForm.FormActivate(Sender: TObject);
var
  _tagname: string;
begin
  LoadTrendProperties(M.Datchik[DatIndex].TagPostfix, TrendsFrame.Chart);
  Update;
  Init;

  _tagname := M.expandTagname;

  TrendsFrame.CreateTrends(
      M.TagPath + '.MDTA_'+ _tagName+M.Datchik[DatIndex].TagPostfix+'_Value' + ';' +
      M.TagPath + '.MDTA_'+ _tagName+M.Datchik[DatIndex].TagPostfix+'_Sost' );
end;


procedure TMdtaSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TimerTrends.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TMdtaSetPanelForm.Init;
var
  s,stag: string;
  _tagname: string;
begin
  Caption := '  "' + M.DeviceName + ' ' + M.Datchik[DatIndex].Name + '"';
  FMessageTagName := Caption;

  _tagname := M.expandTagname;

  stag := M.TagPath + '.MDTA_' + _tagName + M.Datchik[DatIndex].TagPostfix;


  s := stag + '_Value';
  FTagMdtaValue := GetTagIndex(s);
  s := stag + '_Low';
  FTagMdtaLow := GetTagIndex(s);
  s := stag + '_High';
  FTagMdtaHigh := GetTagIndex(s);
  s := stag + '_DlyDrebezg';
  FTagMdtaDlyDrebezg := GetTagIndex(s);
  s := stag + '_DlyOutput';
  FTagMdtaDlyOutput := GetTagIndex(s);

  Timer.Enabled := true;
  TimerTrends.Enabled := true;
  Process;
end;

procedure TMdtaSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;
end;

procedure TMdtaSetPanelForm.TimerTrendsTimer(Sender: TObject);
begin
  TrendsFrame.OnLineUpdateTrends;
end;

procedure TMdtaSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;

procedure SetPanelCaption(i: integer; p: TPanel);
var
  s: string;
begin
  s := inttostr(GetTagValue( i ));
  if s='-1' then s:='';
  if not(s = p.Caption) then p.Caption := s;
end;

procedure TMdtaSetPanelForm.Process;
begin
  SetPanelCaption(FTagMdtaValue, InpValuePanel);
  SetPanelCaption(FTagMdtaLow, LowRangePanel);
  SetPanelCaption(FTagMdtaHigh, HighRangePanel);
  SetPanelCaption(FTagMdtaDlyDrebezg, DlyDrebezgPanel);
  SetPanelCaption(FTagMdtaDlyOutput, DlyOutputPanel);
end;



procedure TMdtaSetPanelForm.DlyDrebezgPanelClick(Sender: TObject);
begin
  if SetAndSaveTagValueDlg( FTagMdtaDlyDrebezg, '  , ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, '/='+IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TMdtaSetPanelForm.DlyOutputPanelClick(Sender: TObject);
begin
  if SetAndSaveTagValueDlg( FTagMdtaDlyOutput, '   , ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, '='+IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TMdtaSetPanelForm.HighRangePanelClick(Sender: TObject);
begin
  if SetAndSaveTagValueDlg( FTagMdtaHigh, '   ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, ' ='+IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TMdtaSetPanelForm.LowRangePanelClick(Sender: TObject);
begin
  if SetAndSaveTagValueDlg( FTagMdtaLow, '   ', v) then
    SaveMessageText(mcParam_text, FMessageTagName, ' ='+IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TMdtaSetPanelForm.FormDestroy(Sender: TObject);
begin
  SaveTrendProperties(M.Datchik[DatIndex].TagPostfix,
        TrendsFrame.Chart.LeftAxis.Minimum,
        TrendsFrame.Chart.LeftAxis.Maximum );
end;

end.
