unit Mdta_Proc_prop;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, VisDltB,
  VisStatusShape, VisZDVH, VisZDVT, jpeg, SimpleLine, PolyLine, VisButton,
  Buttons, VisLabel, ComCtrls, AdvGlowButton, VisControl;

type
  TMdta_Proc_propForm = class(TForm)
    BitBtn1: TBitBtn;
    Button2: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Timer1: TTimer;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label33: TLabel;
    Label25: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    VisLabel44: TVisLabel;
    VisLabel22: TVisLabel;
    VisLabel52: TVisLabel;
    VisLabel1: TVisLabel;
    VisLabel2: TVisLabel;
    VisLabel6: TVisLabel;
    VisLabel3: TVisLabel;
    VisLabel4: TVisLabel;
    Timer2: TTimer;
    Bevel3: TBevel;
    Label10: TLabel;
    Label11: TLabel;
    VisLabel5: TVisLabel;
    Label15: TLabel;
    VisLabel11: TVisLabel;
    VisLabel10: TVisLabel;
    btSetFull: TAdvGlowButton;
    AdvGlowButton1: TAdvGlowButton;
    procedure VisGetTagIndex(TagName: String; var TagIndex: Integer);
    procedure VisGetTagValue(TagIndex: Integer; var Value: Integer);
    procedure VisualDeviceClick(Sender: TObject);
    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure VisSetTagValue(TagIndex, Value: Integer);
    procedure VisLabelClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure btSetFullClick(Sender: TObject);
    procedure VisLabel10Click(Sender: TObject);
    function ConvertMDTA_Value (pin, PointV, PointP, PointV1, PointP1 : integer) : integer;
    procedure AdvGlowButton1Click(Sender: TObject);
  private
  public
    TagPath: string;
    TagRoot: string;
    DeviceName: string;
  end;


  procedure _Mdta_Proc_Click(AOwner: TComponent; Sender: TObject);

implementation
uses
  InputDialog,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  users,
  numbers,
  TagStorage,
  connecting,
  meslogging,
  SetChannel,
  trendwindow;

var
  _TagPath: string;
  _TagRoot: string;

{$R *.dfm}

procedure TMdta_Proc_propForm.VisGetTagIndex(TagName: String;
  var TagIndex: Integer);
begin
  TagIndex := GetTagIndex(TagName);
end;

procedure TMdta_Proc_propForm.VisGetTagValue(TagIndex: Integer;
  var Value: Integer);
begin
  Value := GetTagValue(TagIndex);
end;

procedure TMdta_Proc_propForm.VisSetTagValue(TagIndex, Value: Integer);
begin
  SetTagValue(TagIndex, Value);
end;

procedure TMdta_Proc_propForm.VisualDeviceClick(Sender: TObject);
begin
  _VisualDeviceClick(sender);
end;

procedure TMdta_Proc_propForm.TabSheetMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
end;


procedure _proc(Target: TCustomScadaObject);
begin
  if Target.ClassType = TVisLabel then
    with Target as TVisLabel do begin
      TagPath := _TagPath;
      TagRoot := _TagRoot;
    end;
end;

procedure TMdta_Proc_propForm.FormActivate(Sender: TObject);
begin
  TabSheet2.TabVisible := CheckAccess(PREVILEG_PRM_SPEC1, false);
  btSetFull.Visible := TabSheet2.TabVisible;

  _TagPath := TagPath;
  _TagRoot := TagRoot;
  Caption := DeviceName;
  CustomScanScadaObjects(self, _proc);
  CustomScanScadaObjects(self, InitDeviceProc);

  Timer1Timer(nil);
end;

procedure TMdta_Proc_propForm.Timer1Timer(Sender: TObject);
begin
  if not rvgLogIn then exit;
  CustomScanScadaObjects(self, UpdateDeviceProc);
end;



procedure TMdta_Proc_propForm.VisLabelClick(Sender: TObject);
var
  s: string;
  i,j: integer;
begin
  with sender as TVisLabel do begin
    s := inttostr(gettagval(0));
    if ShowInputDialog(' ', ' ', s) then begin
      val(s, i, j);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;

end;


procedure TMdta_Proc_propForm.Button2Click(Sender: TObject);
begin
  ShowTrendWindow(
      DeviceName + ', %',
      TagPath + '.MDTA_' + TagRoot + '_Value',
      '',
      'mdta_',
      ''
    );

end;


procedure _Mdta_Proc_Click(AOwner: TComponent; Sender: TObject);
var
  w: TMdta_Proc_propForm;
begin
  if not rvgLogIn then exit;

  w := TMdta_Proc_propForm.Create(AOwner);
  with sender as TVisLabel do try
    w.TagPath := TagPath;
    w.TagRoot := TagRoot;
    w.DeviceName := get_clear_hint(Hint);
    w.ShowModal;
  finally
    w.Free;
  end;
end;


procedure TMdta_Proc_propForm.btSetFullClick(Sender: TObject);
begin
//  VisLabel6 ==>> VisLabel1
//  VisLabel4 ==>> VisLabel2


  if MessageBox(self.Handle, ' ,    ?', '',
          MB_YESNO + MB_ICONWARNING) <> idYes then exit;

  SetTagValue( VisLabel1.Tags[0].idx, 100 );
  SetTagValue( VisLabel2.Tags[0].idx, GetTagValue( VisLabel4.Tags[0].idx ) );

end;



function TMdta_Proc_propForm.ConvertMDTA_Value (pin, PointV, PointP, PointV1, PointP1 : integer) : integer;
var r, r1, r2, r3 : real;
begin

  //     
  if ( (PointV > 0) and (PointP > 0) and (PointV <> PointP) and (PointV1 = 0) and (PointP1 = 0)) then
    begin
      r := pin * (PointV / PointP);
      pin := round(r);

      if ( (r - pin) > 0.5) then if (pin < $FFFF) then pin := pin + 1;
    end
  else
    //     
    if ((PointV > 0) or (PointP > 0) or (PointV1 > 0) or (PointP1 > 0))  then
      begin
        r1 := PointP1 - PointP;
        r2 := pin - PointP;
        r3 := PointV1 - PointV;

        if (r1 <> 0) then
          begin
            r := r2 / r1;
            r := r * r3 + PointV;

            if (r < 0) then
              begin
                pin := 0;
              end
            else
              begin
               pin := round(r);
               if ( (r - pin) > 0.5 ) then if (pin < $FFFF) then  pin := pin + 1;
              end
          end
        else pin := 0;
      end;

  result := pin;
end;

{

function TMdta_Proc_propForm.ConvertMDTA_ValueRevers (pin, PointV, PointP, PointV1, PointP1 : integer) : integer;
var r, r1, r2, r3 : real;
begin

  //     
  if ( (PointV > 0) and (PointP > 0) and (PointV <> PointP) and (PointV1 = 0) and (PointP1 = 0)) then
    begin
      r := pin / (PointV / PointP) ;
      pin := round(r);
      //if ( (r - pin) > 0.5) then if (pin < $FFFF) then pin := pin + 1;
    end
  else
    //     
    if ((PointV > 0) or (PointP > 0) or (PointV1 > 0) or (PointP1 > 0))  then
      begin
        r1 := PointP1 - PointP;
        r2 := pin - PointP;
        r3 := PointV1 - PointV;

        if (r1 <> 0) then
          begin
            r := (r2 / r1) * r3 + PointV;

            if (r < 0) then
              begin
                pin := 0;
              end
            else
              begin
               pin := round(r);
               if ( (r - pin) > 0.5 ) then if (pin < $FFFF) then  pin := pin + 1;
              end
          end
        else pin := 0;
      end;

  result := pin;
end;





}



procedure TMdta_Proc_propForm.VisLabel10Click(Sender: TObject);
var s: string;
  i,j: integer;
begin

  //ConvertMDTA_Value (pin, PointV, PointP, PointV1, PointP1 : integer) : integer;

  with sender as TVisLabel do begin
//    s := inttostr(gettagval(1));
    s := '-1';
    if ShowInputDialog(' ', '  %  (-1 )', s) then begin
      val(s, i, j);

 //     ...

//      PointP1 - PointP
//      PointV1 - PointV

      //gettagval(0)


      SetTagValue(gettagidx(0), $FFFF);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));

    end;
  end;




end;

procedure TMdta_Proc_propForm.AdvGlowButton1Click(Sender: TObject);
begin

  if MessageBox(self.Handle, ' ,    ?', '',
          MB_YESNO + MB_ICONWARNING) <> idYes then exit;

  SetTagValue( VisLabel44.Tags[0].idx, 0 );
  SetTagValue( VisLabel22.Tags[0].idx, GetTagValue( VisLabel4.Tags[0].idx ) );

end;

end.
