unit Mdta_Scla_prop;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, VisDltB,
  VisStatusShape, VisZDVH, VisZDVT, jpeg, SimpleLine, PolyLine, VisButton,
  Buttons, VisLabel, ComCtrls, AdvGlowButton, VisControl;

type
  TMdta_Scla_propForm = class(TForm)
    BitBtn1: TBitBtn;
    Button2: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Timer1: TTimer;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label33: TLabel;
    Label25: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    VisLabel44: TVisLabel;
    VisLabel22: TVisLabel;
    VisLabel52: TVisLabel;
    VisLabel1: TVisLabel;
    VisLabel2: TVisLabel;
    VisLabel6: TVisLabel;
    VisLabel3: TVisLabel;
    VisLabel4: TVisLabel;
    Timer2: TTimer;
    Bevel3: TBevel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    VisLabel5: TVisLabel;
    VisLabel7: TVisLabel;
    Label15: TLabel;
    VisLabel11: TVisLabel;
    VisLabel10: TVisLabel;
    btSetFull: TAdvGlowButton;
    procedure VisGetTagIndex(TagName: String; var TagIndex: Integer);
    procedure VisGetTagValue(TagIndex: Integer; var Value: Integer);
    procedure VisualDeviceClick(Sender: TObject);
    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure VisSetTagValue(TagIndex, Value: Integer);
    procedure VisLabelClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure VisLabel11Click(Sender: TObject);
    procedure VisLabelTonnsClick(Sender: TObject);
    procedure btSetFullClick(Sender: TObject);
  private
  public
    TagPath: string;
    TagRoot: string;
    DeviceName: string;
  end;


  procedure _Mdta_Scla_Click(AOwner: TComponent; Sender: TObject);

implementation
uses
  InputDialog,
  users,
  numbers,
  TagStorage,
  connecting,
  meslogging,
  SetChannel,
  trendwindow,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;

var
  _TagPath: string;
  _TagRoot: string;

{$R *.dfm}

procedure TMdta_Scla_propForm.VisGetTagIndex(TagName: String;
  var TagIndex: Integer);
begin
  TagIndex := GetTagIndex(TagName);
end;

procedure TMdta_Scla_propForm.VisGetTagValue(TagIndex: Integer;
  var Value: Integer);
begin
  Value := GetTagValue(TagIndex);
end;

procedure TMdta_Scla_propForm.VisSetTagValue(TagIndex, Value: Integer);
begin
  SetTagValue(TagIndex, Value);
end;

procedure TMdta_Scla_propForm.VisualDeviceClick(Sender: TObject);
begin
  _VisualDeviceClick(sender);
end;

procedure TMdta_Scla_propForm.TabSheetMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
end;


procedure _proc(Target: TCustomScadaObject);
begin
  if Target.ClassType = TVisLabel then
    with Target as TVisLabel do begin
      TagPath := _TagPath;
      TagRoot := _TagRoot;
    end;
end;

procedure TMdta_Scla_propForm.FormActivate(Sender: TObject);
begin
  TabSheet2.TabVisible := CheckAccess(PREVILEG_PRM_SPEC1, false);
  btSetFull.Visible := TabSheet2.TabVisible;

  _TagPath := TagPath;
  _TagRoot := TagRoot;
  Caption := DeviceName;
  CustomScanScadaObjects(self, _proc);
  CustomScanScadaObjects(self, InitDeviceProc);

  Timer1Timer(nil);
end;

procedure TMdta_Scla_propForm.Timer1Timer(Sender: TObject);
begin
  if not rvgLogIn then exit;
  CustomScanScadaObjects(self, UpdateDeviceProc);
end;



procedure TMdta_Scla_propForm.VisLabelClick(Sender: TObject);
var
  s: string;
  i,j: integer;
begin
  with sender as TVisLabel do begin
    s := inttostr(gettagval(0));
    if ShowInputDialog(' ', ' ', s) then begin
      val(s, i, j);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;

end;


procedure TMdta_Scla_propForm.Button2Click(Sender: TObject);
begin
  ShowTrendWindow(
      DeviceName + ', %',
      TagPath + '.SCLA_' + TagRoot + '_Percent',
      '',
      'scla_',
      ''
    );

end;


procedure _Mdta_Scla_Click(AOwner: TComponent; Sender: TObject);
var
  w: TMdta_Scla_propForm;
begin
  if not rvgLogIn then exit;

  w := TMdta_Scla_propForm.Create(AOwner);
  with sender as TVisLabel do try
    w.TagPath := TagPath;
    w.TagRoot := TagRoot;
    w.DeviceName := get_clear_hint(Hint);
    w.ShowModal;
  finally
    w.Free;
  end;
end;


procedure TMdta_Scla_propForm.VisLabel11Click(Sender: TObject);
var
  i: integer;
begin
  with sender as TVisLabel do begin
    i := iif(gettagval(0)=1, 0, 1);
    SetTagValue(gettagidx(0), i);
    SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + iif(i=0, '', '') );
  end;
end;

procedure TMdta_Scla_propForm.VisLabelTonnsClick(Sender: TObject);
var
  s: string;
  i,j: integer;
  d: double;
begin
  with sender as TVisLabel do begin
    d := gettagval(0);
    s := FloatStr( d / 100, 5, 2);
    if ShowInputDialog(' ', ' ', s) then begin
      val(s, d, j);
      i := round(d * 100);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;
end;

procedure TMdta_Scla_propForm.btSetFullClick(Sender: TObject);
begin
//  VisLabel6 ==>> VisLabel1
//  VisLabel4 ==>> VisLabel2
  if MessageBox(self.Handle, ' ,    ?', '',
          MB_YESNO + MB_ICONWARNING) <> idYes then exit;

  SetTagValue( VisLabel1.Tags[0].idx, GetTagValue( VisLabel6.Tags[0].idx ) );
  SetTagValue( VisLabel2.Tags[0].idx, GetTagValue( VisLabel4.Tags[0].idx ) );

end;

end.
