unit TUR_prop;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, VisDltB,
  VisStatusShape, VisZDVH, VisZDVT, jpeg, SimpleLine, PolyLine, VisButton,
  Buttons, VisLabel, ComCtrls, AdvGlowButton, VisNumericPanel, VisControl;

type
  TTUR_propForm = class(TForm)
    BitBtn1: TBitBtn;
    Button2: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Timer1: TTimer;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label33: TLabel;
    Label25: TLabel;
    lbMetrics2: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lb3: TLabel;
    lbMetrics3: TLabel;
    lb4: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    VisLabel44: TVisLabel;
    VisLabel22: TVisLabel;
    VisLabel52: TVisLabel;
    VisLabel1: TVisLabel;
    VisLabel2: TVisLabel;
    VisLabel6: TVisLabel;
    VisLabel3: TVisLabel;
    VisLabel4: TVisLabel;
    Bevel3: TBevel;
    lbMetrics1: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    VisLabel5: TVisLabel;
    VisLabel7: TVisLabel;
    lbMetrics5: TLabel;
    VisLabel11: TVisLabel;
    VisLabel10: TVisLabel;
    btSetFull: TAdvGlowButton;
    VisLabel8: TVisLabel;
    Label1: TLabel;
    VisNumericPanel1: TVisNumericPanel;
    Label4: TLabel;
    pnlPath: TPanel;
//    procedure VisualDeviceClick(Sender: TObject);
//    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
//      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure VisLabelClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure VisLabel11Click(Sender: TObject);
    procedure SetValueClick(Sender: TObject);
    procedure btSetFullClick(Sender: TObject);
  private
    Metrics: string;
  public
    TagPath: string;
    TagRoot: string;
    DeviceName: string;
  end;


  procedure _TUR_Click(AOwner: TComponent; Sender: TObject; Metrics: string='');

implementation
uses
  InputDialog,
  users,
  numbers,
  TagStorage,
  connecting,
  meslogging,
  SetChannel,
  trendwindow,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;

var
  _TagPath: string;
  _TagRoot: string;

{$R *.dfm}

//procedure TTUR_propForm.VisualDeviceClick(Sender: TObject);
//begin
//  _VisualDeviceClick(sender);
//end;
//
//procedure TTUR_propForm.TabSheetMouseDown(Sender: TObject;
//  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
//begin
//  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
//end;
//
//
//procedure _proc(Target: TCustomScadaObject);
//begin
//  if Target.ClassType = TVisLabel then
//    with Target as TVisLabel do begin
//      TagPath := _TagPath;
//      TagRoot := _TagRoot;
//    end;
//end;

procedure TTUR_propForm.FormActivate(Sender: TObject);
begin
  TabSheet2.TabVisible := CheckAccess(PREVILEG_PRM_SPEC1, false);
  btSetFull.Visible := TabSheet2.TabVisible;

  Caption := DeviceName;

  lbMetrics1.Caption := lbMetrics1.Caption + Metrics;
  lbMetrics2.Caption := lbMetrics2.Caption + Metrics;
  lbMetrics3.Caption := lbMetrics3.Caption + Metrics;
  lbMetrics5.Caption := lbMetrics5.Caption + Metrics;
  pnlPath.caption := TagPath;


  SetPathRootScadaObjects(Self, TagPath, TagRoot);

  Timer1Timer(nil);
end;

procedure TTUR_propForm.Timer1Timer(Sender: TObject);
begin
  if not rvgLogIn then exit;
  CustomScanScadaObjects(self, UpdateDeviceProc);
end;



procedure TTUR_propForm.VisLabelClick(Sender: TObject);
var
  s: string;
  i,j: integer;
begin
  with sender as TVisLabel do begin
    s := inttostr(gettagval(0));
    if ShowInputDialog(' ', ' ', s) then begin
      val(s, i, j);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;

end;


procedure TTUR_propForm.Button2Click(Sender: TObject);
begin
  ShowTrendWindow(
      DeviceName,
      TagPath + '.Value~/100;' + TagPath + '.Percent',
      Metrics + ';%',
      'tur_',
      ''
    );

end;



procedure TTUR_propForm.VisLabel11Click(Sender: TObject);
var
  i: integer;
begin
  with sender as TVisLabel do begin
    i := iif(gettagval(0)=1, 0, 1);
    SetTagValue(gettagidx(0), i);
    SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + iif(i=0, '', '') );
  end;
end;

procedure TTUR_propForm.SetValueClick(Sender: TObject);
var
  s: string;
  i,j: integer;
  d: double;
begin
  with sender as TVisLabel do begin
    d := gettagval(0);
    s := FloatStr( d / 100, 5, 2);
    if ShowInputDialog(' ', ' ', s) then begin
      val(s, d, j);
      i := round(d * 100);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;
end;

procedure TTUR_propForm.btSetFullClick(Sender: TObject);
begin
  if MessageBox(self.Handle, ' ,    ?', '',
          MB_YESNO + MB_ICONWARNING) <> idYes then exit;

  SetTagValue( VisLabel1.Tags[0].idx, GetTagValue( VisLabel6.Tags[0].idx ) );
  SetTagValue( VisLabel2.Tags[0].idx, GetTagValue( VisLabel4.Tags[0].idx ) );
end;








procedure _TUR_Click(AOwner: TComponent; Sender: TObject; Metrics: string='');
var
  w: TTUR_propForm;
begin
  if not rvgLogIn then exit;

  w := TTUR_propForm.Create(AOwner);
  with sender as TCustomScadaObject do try
    w.TagPath := TagPath;
    w.TagRoot := TagRoot;
    w.DeviceName := get_clear_hint(Hint);

    w.Metrics := Metrics;

    w.ShowModal;
  finally
    w.Free;
  end;
end;


end.
