unit VspaSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Buttons, VisVespA;

type
  TVspaSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    HelpButton: TBitBtn;
    btReset: TBitBtn;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure btResetClick(Sender: TObject);
  private
    FMessageTag: string;
    FTagEnable: integer;
    FReverse: integer;
    FReset: integer;

    FTimerCnt: integer;
  public
    { Public declarations }
    M: TVisVespA;

    procedure Init;
    procedure Process;
  end;

//var
//  VspaSetPanelForm: TVspaSetPanelForm;

implementation
uses 
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  TagStorage, MesLogging;

{$R *.DFM}

{ TVspaSetPanelForm }

procedure TVspaSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(500.0);
end;


procedure TVspaSetPanelForm.FormActivate(Sender: TObject);
begin
  (self as TVspaSetPanelForm).Update;
  Init;
  TrendsFrame.CreateTrends(
      M.TagPath + '.VSPA_'+M.TagName+'_Reg23' + ';' +
      M.TagPath + '.VSPA_'+M.TagName+'_Reg24' + ';' +
      M.TagPath + '.VSPA_'+M.TagName+'_Reg27' + ';' +
      M.TagPath + '.VSPA_'+M.TagName+'_Enable' + ';' +
      M.TagPath + '.VSPA_'+M.TagName+'_ErrorFlag');
end;


procedure TVspaSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TVspaSetPanelForm.Init;
var
  s: string;
begin
  (self as TVspaSetPanelForm).Caption := '  "' + M.DeviceName + '"';

  s := M.TagPath + '.VSPA_' + M.TagName + '_Enable';
  FTagEnable := GetTagIndex(s);

  FMessageTag := M.DeviceName;

  FReverse := -1;
  FReset := -1;

  Timer.Enabled := true;

  Process;
end;


procedure TVspaSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;

  inc(FTimerCnt);
  if FTimerCnt >= 8 then begin
    FTimerCnt := 0;
    TrendsFrame.OnLineUpdateTrends;
  end;
end;


procedure TVspaSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;


procedure TVspaSetPanelForm.Process;
//var
//  value: integer;
begin
//  value := GetTagValue( FTagEnable );
//  if value <> FMachTimeStart then begin
//    TimeStartPanel.Caption := IntToStr(value);
//    FMachTimeStart := value;
//  end;
end;



procedure TVspaSetPanelForm.HelpButtonClick(Sender: TObject);
begin
//  ShowCommonHelp('CtrlPanelVspa.htm');
end;

procedure TVspaSetPanelForm.btResetClick(Sender: TObject);
begin
  SetTagValue( FTagEnable, (GetTagValue(FTagEnable) or 8) );
end;

end.
