unit VspcSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends, Buttons, VisVespC;

type
  TVspcSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    HelpButton: TBitBtn;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
  private
    FMessageTag: string;
    FTagEnable: integer;
    FReverse: integer;
    FReset: integer;

    FTimerCnt: integer;
  public
    { Public declarations }
    M: TVisVespC;

    procedure Init;
    procedure Process;
  end;

//var
//  VspcSetPanelForm: TVspcSetPanelForm;

implementation
uses 
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  TagStorage, MesLogging;

{$R *.DFM}

{ TVspcSetPanelForm }

procedure TVspcSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(500.0);
end;


procedure TVspcSetPanelForm.FormActivate(Sender: TObject);
begin
  (self as TVspcSetPanelForm).Update;
  Init;
  TrendsFrame.CreateTrends(
      M.TagPath + '.VSPC_'+M.TagName+'_Reg20' + ';' +
      M.TagPath + '.VSPC_'+M.TagName+'_Reg21' + ';' +
      M.TagPath + '.VSPC_'+M.TagName+'_Reg22' + ';' +
      M.TagPath + '.VSPC_'+M.TagName+'_Enable' + ';' +
      M.TagPath + '.VSPC_'+M.TagName+'_Alarm' +
      M.TagPath + '.VSPC_'+M.TagName+'_Reg10' + ';'
      );
end;


procedure TVspcSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TVspcSetPanelForm.Init;
var
  s: string;
begin
  (self as TVspcSetPanelForm).Caption := '  "' + M.DeviceName + '"';

  s := M.TagPath + '.VSPC_' + M.TagName + '_Enable';
  FTagEnable := GetTagIndex(s);

  FMessageTag := M.DeviceName;

  FReverse := -1;
  FReset := -1;

  Timer.Enabled := true;

  Process;
end;


procedure TVspcSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;

  inc(FTimerCnt);
  if FTimerCnt >= 8 then begin
    FTimerCnt := 0;
    TrendsFrame.OnLineUpdateTrends;
  end;
end;


procedure TVspcSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;


procedure TVspcSetPanelForm.Process;
begin
end;



procedure TVspcSetPanelForm.HelpButtonClick(Sender: TObject);
begin
//  ShowCommonHelp('SetPanelVspc.htm');
end;

end.
