unit ZdvSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Trends;

type
  TZdvSetPanelForm = class(TForm)
    Timer: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    DelayPanel: TPanel;
    SaveButton: TButton;
    CancelButton: TButton;
    TrendsFrame: TTrendsFrame;
    procedure TimerTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelButtonClick(Sender: TObject);
    procedure DelayPanelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
  private
    { Private declarations }
    FTagDelay: integer;
    FDelay: integer;

    FTimerCnt: integer;
  public
    { Public declarations }
    DelayTagName: string;
    SostTagName: string;
    MessageTagName: string;
    DeviceName: string;

    procedure Init;
    procedure Process;
  end;

var
  ZdvSetPanelForm: TZdvSetPanelForm;

implementation
uses
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain,
  MesConst, TagStorage, MesLogging;

{$R *.DFM}

{ TZdvSetPanelForm }

procedure TZdvSetPanelForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(10.0);
end;


procedure TZdvSetPanelForm.FormActivate(Sender: TObject);
begin
  Update;
  Init;
  TrendsFrame.CreateTrends(SostTagName);
end;


procedure TZdvSetPanelForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
  TrendsFrame.DeleteTrends;
end;


procedure TZdvSetPanelForm.Init;
begin
  ZdvSetPanelForm.Caption := '  "' + DeviceName + '"';
  FTagDelay := GetTagIndex(DelayTagName);
  FDelay := -1;
  Timer.Enabled := true;
  Process;
end;


procedure TZdvSetPanelForm.TimerTimer(Sender: TObject);
begin
  Process;

  inc(FTimerCnt);
  if FTimerCnt >= 8 then begin
    FTimerCnt := 0;
    TrendsFrame.OnLineUpdateTrends;
  end;
end;


procedure TZdvSetPanelForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;


procedure TZdvSetPanelForm.Process;
var
  value: integer;
begin
  value := GetTagValue( FTagDelay );
  if value <> FDelay then begin
    DelayPanel.Caption := IntToStr(value);
    FDelay := value;
  end;

end;



procedure TZdvSetPanelForm.DelayPanelClick(Sender: TObject);
var
  v: integer;
begin
  if SetTagValueDlg( FTagDelay, '  , ', v) then
    SaveMessageText(mcParam_text, MessageTagName, ' ='+IntToStr(v), mcParam_bc, mcParam_fc);
end;

procedure TZdvSetPanelForm.SaveButtonClick(Sender: TObject);
begin
//  if MessageDlg('  ?', mtConfirmation, [mbYes, mbNo],
//      0) = mrYes then begin
//    MemTagValue(FTagDelay);
//  end;
end;

end.
