unit SimpleImageSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ExtCtrls, Buttons, ComCtrls, SimpleImage, RpVisualGlobal;

type
  TSimpleImageSetupForm = class(TForm)
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    Timer: TTimer;
    Panel5: TPanel;
    Label5: TLabel;
    List: TListBox;
    btLineAdd: TSpeedButton;
    btLineDel: TSpeedButton;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label34: TLabel;
    LabelXEdit: TEdit;
    LabelYEdit: TEdit;
    udLabelY: TUpDown;
    udLabelX: TUpDown;
    LabelRXEdit: TEdit;
    LabelRYEdit: TEdit;
    udLabelRY: TUpDown;
    udLabelRX: TUpDown;
    cbFlash: TCheckBox;
    edCaption: TEdit;
    Label1: TLabel;
    btFont: TButton;
    Panel1: TPanel;
    edTagName: TEdit;
    Label2: TLabel;
    btPic: TButton;
    OpenDialog: TOpenDialog;
    FontDialog: TFontDialog;
    cmbAlignment: TComboBox;
    Label3: TLabel;
    procedure btLineAddClick(Sender: TObject);
    procedure btLineDelClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure LabelXEditChange(Sender: TObject);
    procedure LabelYEditChange(Sender: TObject);
    procedure edTagNameChange(Sender: TObject);
    procedure edCaptionChange(Sender: TObject);
    procedure btPicClick(Sender: TObject);
    procedure btFontClick(Sender: TObject);
    procedure cmbAlignmentChange(Sender: TObject);
  private
    NotLoaded: boolean;
    procedure Modify;
  public
    M: TSimpleImage;
    D: TSimpleImageEditor;
  end;

var
  SimpleImageSetupForm: TSimpleImageSetupForm;

implementation
uses ExtDlgs, inifiles;

{$R *.DFM}

procedure TSimpleImageSetupForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  edTagName.Text := M.TagName;

  //  labels
  List.Clear;
  for i:=0 to M.Count-1 do
    List.Items.Add(M.Labels[i].Caption);

  if List.Items.Count>0 then List.ItemIndex := 0;
  ListClick(nil);

  NotLoaded := false;
end;


procedure TSimpleImageSetupForm.ListClick(Sender: TObject);
var
  i: integer;
begin
  for i:=0 to M.Count-1 do
    if not M.Labels[i].Transparent then M.Labels[i].Transparent := true;

  if List.ItemIndex < 0 then begin
    List.Clear;
    edCaption.Text := '';
    udLabelX.Position := 0;
    udLabelY.Position := 0;
    udLabelRX.Position := 0;
    udLabelRY.Position := 0;
    cmbAlignment.ItemIndex := 2;
  end else
    if List.ItemIndex < M.Count then begin
      NotLoaded := true;
      edCaption.Text := M.Labels[List.ItemIndex].Caption;
      udLabelX.Position := M.Labels[List.ItemIndex].Left;
      udLabelY.Position := M.Labels[List.ItemIndex].Top;
      udLabelRX.Position := M.Labels[List.ItemIndex].Width;
      udLabelRY.Position := M.Labels[List.ItemIndex].Height;
      cmbAlignment.ItemIndex := integer(M.Labels[List.ItemIndex].Alignment);
      NotLoaded := false;
    end;
end;


procedure TSimpleImageSetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('SimpleImage', 'Left', 6);
    Top := ReadInteger('SimpleImage', 'Top', 4);
    cbFlash.Checked := ReadBool('SimpleImage', 'Flash', false);
    Free;
  end;
end;

procedure TSimpleImageSetupForm.FormDestroy(Sender: TObject);
begin
  TimerTimer(nil);
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('SimpleImage', 'Left', Left);
    WriteInteger('SimpleImage', 'Top', Top);
    WriteBool('SimpleImage', 'Flash', cbFlash.Checked);
    Free;
  end;
end;


procedure TSimpleImageSetupForm.Modify;
begin
  D.Designer.Modified;
  M.Repaint;
end;


procedure TSimpleImageSetupForm.TimerTimer(Sender: TObject);
var
  n: integer;
  fl: boolean;
begin
  if (M.Count>0) and (List.ItemIndex>=0) then begin
    n := List.ItemIndex;
    fl := (cbFlash.Checked) and (sender<>nil);

    if fl then begin
      if M.Labels[n].Color = clLime then
        M.Labels[n].Color := clGreen
      else
        M.Labels[n].Color := clLime;
      M.Labels[n].Repaint;
    end;

    if (fl) xor (not M.Labels[n].Transparent) then begin
      M.Labels[n].Transparent := not M.Labels[n].Transparent;
      M.Repaint;
    end;

  end;
end;


procedure TSimpleImageSetupForm.btLineAddClick(Sender: TObject);
var
  k: integer;
begin
  k := M.Count;
  inc(M.Count);
  SetLength(M.Labels, M.Count);

  M.Labels[k] := TLabel.Create(M);
  M.Labels[k].Parent := M;
  M.Labels[k].Visible := true;
  M.Labels[k].Transparent := true;
  M.Labels[k].AutoSize := false;
  M.Labels[k].Caption := 'Text';

  List.Items.Add(M.Labels[k].Caption);
  List.ItemIndex := List.Items.Count-1;
  ListClick(nil);
  Modify;
end;

procedure TSimpleImageSetupForm.btLineDelClick(Sender: TObject);
var
  i,k: integer;
begin
  k := List.ItemIndex;
  if (k>=0) and (k<M.Count) then begin
    M.Labels[k].Free;

    for i:=k to M.Count-2 do M.Labels[i] := M.Labels[i+1];
    Dec(M.Count);
    SetLength(M.Labels, M.Count);

    List.Items.Delete(k);
    if k = List.Items.Count then Dec(k);
    List.ItemIndex := k;
    ListClick(nil);
    Modify;
  end;

end;




procedure TSimpleImageSetupForm.LabelXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') or (LabelRXEdit.Text='') then exit;
  if (List.ItemIndex >= 0) and (List.ItemIndex < M.Count) then begin
    M.Labels[List.ItemIndex].Left := StrToInt(LabelXEdit.Text);
    M.Labels[List.ItemIndex].Width := StrToInt(LabelRXEdit.Text);
    Modify;
  end;
end;

procedure TSimpleImageSetupForm.LabelYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelYEdit.Text='') or (LabelRYEdit.Text='') then exit;
  if (List.ItemIndex >= 0) and (List.ItemIndex < M.Count) then begin
    M.Labels[List.ItemIndex].Top := StrToInt(LabelYEdit.Text);
    M.Labels[List.ItemIndex].Height := StrToInt(LabelRYEdit.Text);
    Modify;
  end;
end;


procedure TSimpleImageSetupForm.edTagNameChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.TagName := edTagName.Text;
  Modify;
end;

procedure TSimpleImageSetupForm.edCaptionChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  if (List.ItemIndex >= 0) and (List.ItemIndex < M.Count) then begin
    M.Labels[List.ItemIndex].Caption := edCaption.Text;
    List.Items.Strings[List.ItemIndex] := edCaption.Text;
    Modify;
  end;
end;

procedure TSimpleImageSetupForm.btPicClick(Sender: TObject);
begin
  OpenDialog.InitialDir := VisImagesPath;
  if OpenDialog.Execute then begin
    M.ImagePic := ExtractFileName(OpenDialog.FileName);
    M.ImageObj.Picture.LoadFromFile(OpenDialog.FileName);
  end;
end;

procedure TSimpleImageSetupForm.btFontClick(Sender: TObject);
begin
  if (List.ItemIndex >= 0) and (List.ItemIndex < M.Count) then begin
    FontDialog.Font.Assign(M.Labels[List.ItemIndex].Font);
    if FontDialog.Execute then
      M.Labels[List.ItemIndex].Font.Assign(FontDialog.Font);
  end;
end;

procedure TSimpleImageSetupForm.cmbAlignmentChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  if (List.ItemIndex >= 0) and (List.ItemIndex < M.Count) then begin
    M.Labels[List.ItemIndex].Alignment := TAlignment(cmbAlignment.ItemIndex);
    Modify;
  end;
end;

end.
