unit SimpleLine;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls;


type
  TSimpleLineStyleTypes = (slsLeft, slsRigth, slsTop, slsBottom, slsLeftToRigth, slsRigthToLeft);
  TSimpleLineStyle = set of TSimpleLineStyleTypes;

  TSimpleLineCornerTypes = (slcLeftTop, slcRightTop, slcLeftBottom, slcRightBottom);
  TSimpleLineCorner = set of TSimpleLineCornerTypes;


  TSimpleLine = class(TGraphicControl)
  private
    FLineColor: TColor;
    FLineStyle: TSimpleLineStyle;
    FHorLine: integer;
    FVerLine: integer;
    FPenStyle: TPenStyle;
    FPenWidth: integer;

    FCorner: TSimpleLineCorner;
    FCornerSize: Integer;

    procedure SetLineColor(Value: TColor);
    procedure SetLineStyle(Value: TSimpleLineStyle);
    procedure SetHorLine(Value: integer);
    procedure SetVerLine(Value: integer);
    procedure SetPenStyle(Value: TPenStyle);
    procedure SetPenWidth(Value: integer);
    procedure SetCorner(Value: TSimpleLineCorner);
    procedure SetCornerSize(Value: integer);
    procedure OnMouseDownProc(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;

  published
    property LineColor: TColor read FLineColor write SetLineColor;
    property LineStyle: TSimpleLineStyle read FLineStyle write SetLineStyle;
    property HorLine: integer read FHorLine write SetHorLine;
    property VerLine: integer read FVerLine write SetVerLine;
    property PenStyle: TPenStyle read FPenStyle write SetPenStyle;
    property PenWidth: integer read FPenWidth write SetPenWidth;
    property Corner: TSimpleLineCorner read FCorner write SetCorner;
    property CornerSize: integer read FCornerSize write SetCornerSize;
    property OnMouseDown;
  end;


procedure Register;

implementation
uses
  RpVisualMain;

procedure Register;
begin
  RegisterComponents('Scada', [TSimpleLine]);
end;



{ TSimpleLine }

constructor TSimpleLine.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 65;
  Height := 17;
  Canvas.Brush.Style := bsClear;
  OnMouseDown := OnMouseDownProc;
end;


procedure TSimpleLine.OnMouseDownProc(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetClick;
end;    


procedure TSimpleLine.SetLineColor(Value: TColor);
begin
  FLineColor := Value;
  Invalidate;
end;

procedure TSimpleLine.SetLineStyle(Value: TSimpleLineStyle);
begin
  FLineStyle := Value;
  Invalidate;
end;

procedure TSimpleLine.SetHorLine(Value: integer);
begin
  FHorLine := Value;
  Invalidate;
end;

procedure TSimpleLine.SetVerLine(Value: integer);
begin
  FVerLine := Value;
  Invalidate;
end;

procedure TSimpleLine.SetPenStyle(Value: TPenStyle);
begin
  FPenStyle := value;
  Invalidate;
end;

procedure TSimpleLine.SetPenWidth(Value: integer);
begin
  FPenWidth := value;
  Invalidate;
end;

procedure TSimpleLine.SetCorner(Value: TSimpleLineCorner);
begin
  FCorner := value;
  Invalidate;
end;

procedure TSimpleLine.SetCornerSize(Value: integer);
begin
  FCornerSize := value;
  Invalidate;
end;



procedure TSimpleLine.Paint;
var
  x1,x2,y1,y2,delta_plus,delta_minus: Integer;
  i: Integer;
begin
  if FPenWidth <= 0 then
    FPenWidth := 1;

  Canvas.Pen.Color := FLineColor;
  Canvas.Pen.Style := FPenStyle;
  Canvas.Pen.Width := FPenWidth;

  delta_plus := Canvas.Pen.Width div 2;
  delta_minus := (Canvas.Pen.Width-1) div 2 + 1;
  
  x1 := ClientRect.Left + delta_plus;
  y1 := ClientRect.Top + delta_plus;
  x2 := ClientRect.Right - delta_minus;
  y2 := ClientRect.Bottom - delta_minus;


  if slsLeft in FLineStyle then begin
    if FHorLine < 0 then begin
      Canvas.MoveTo(x1, y1 - FHorLine);
      Canvas.LineTo(x1, ClientRect.Bottom);
    end else
    if FHorLine > 0 then begin
      Canvas.MoveTo(x1, ClientRect.Top);
      Canvas.LineTo(x1, y1 + FHorLine);
    end else begin
      Canvas.MoveTo(x1, ClientRect.Top);
      Canvas.LineTo(x1, ClientRect.Bottom);
    end;
  end;

  if slsRigth in FLineStyle then begin
    if FHorLine < 0 then begin
      Canvas.MoveTo(x2, ClientRect.Top);
      Canvas.LineTo(x2, ClientRect.Top - FHorLine);
    end else
    if FHorLine > 0 then begin
      Canvas.MoveTo(x2, y1 + FHorLine );
      Canvas.LineTo(x2, ClientRect.Bottom);
    end else begin
      Canvas.MoveTo(x2, ClientRect.Top);
      Canvas.LineTo(x2, ClientRect.Bottom);
    end;
  end;

  if slsTop in FLineStyle then begin
    if FVerLine < 0 then begin
      Canvas.MoveTo(x1 - FVerLine, y1);
      Canvas.LineTo(ClientRect.Right, y1);
    end else
    if FVerLine > 0 then begin
      Canvas.MoveTo(ClientRect.Left-1, y1);
      Canvas.LineTo(x1 + FVerLine, y1);
    end else begin
    Canvas.MoveTo(ClientRect.Left, y1);
    Canvas.LineTo(ClientRect.Right, y1);
    end;
  end;

  if slsBottom in FLineStyle then begin
    if FVerLine < 0 then begin
      Canvas.MoveTo(ClientRect.Left-1, y2);
      Canvas.LineTo(x1 - FVerLine, y2);
    end else
    if FVerLine > 0 then begin
      Canvas.MoveTo(x1 + FVerLine, y2);
      Canvas.LineTo(ClientRect.Right, y2);
    end else begin
      Canvas.MoveTo(ClientRect.Left, y2);
      Canvas.LineTo(ClientRect.Right, y2);
    end;
  end;

  if slsLeftToRigth in FLineStyle then begin
    Canvas.MoveTo(x1, y1);
    Canvas.LineTo(ClientRect.Right, ClientRect.Bottom);
  end;

  if slsRigthToLeft in FLineStyle then begin
    Canvas.MoveTo(ClientRect.Right-1, y1);
    Canvas.LineTo(ClientRect.Left-1, ClientRect.Bottom);
  end;

  if FHorLine <> 0 then begin
    Canvas.MoveTo(ClientRect.Left-1, y1 + abs(FHorLine));
    Canvas.LineTo(ClientRect.Right+1, y1 + abs(FHorLine));
  end;

  if FVerLine <> 0 then begin
    Canvas.MoveTo(x1 + abs(FVerLine), ClientRect.Top-1);
    Canvas.LineTo(x1 + abs(FVerLine), ClientRect.Bottom+1);
  end;

  if FCornerSize < 2 then
    FCornerSize := 2;

  if slcLeftTop in FCorner then begin
    Canvas.Pixels[ClientRect.Left, ClientRect.Top] := FLineColor;
    Canvas.Pixels[ClientRect.Left, ClientRect.Top+1] := FLineColor;
    Canvas.Pixels[ClientRect.Left+1, ClientRect.Top] := FLineColor;
    for i:=2 to FCornerSize-1 do begin
      Canvas.MoveTo(ClientRect.Left, ClientRect.Top+i);
      Canvas.LineTo(ClientRect.Left+i+1, ClientRect.Top-1);
    end;
  end;

  if slcRightTop in FCorner then begin
    Canvas.Pixels[ClientRect.Right-1, ClientRect.Top] := FLineColor;
    Canvas.Pixels[ClientRect.Right-2, ClientRect.Top] := FLineColor;
    Canvas.Pixels[ClientRect.Right-1, ClientRect.Top+1] := FLineColor;
    for i:=2 to FCornerSize-1 do begin
      Canvas.MoveTo(ClientRect.Right-i-1, ClientRect.Top);
      Canvas.LineTo(ClientRect.Right, ClientRect.Top+i+1);
    end;
  end;


  if slcLeftBottom in FCorner then begin
    Canvas.Pixels[ClientRect.Left, ClientRect.Bottom-1] := FLineColor;
    Canvas.Pixels[ClientRect.Left, ClientRect.Bottom-2] := FLineColor;
    Canvas.Pixels[ClientRect.Left+1, ClientRect.Bottom-1] := FLineColor;
    for i:=2 to FCornerSize-1 do begin
      Canvas.MoveTo(ClientRect.Left, ClientRect.Bottom-i-1);
      Canvas.LineTo(ClientRect.Left+i+1, ClientRect.Bottom);
    end;
  end;


  if slcRightBottom in FCorner then begin
    Canvas.Pixels[ClientRect.Right-1, ClientRect.Bottom-1] := FLineColor;
    Canvas.Pixels[ClientRect.Right-1, ClientRect.Bottom-2] := FLineColor;
    Canvas.Pixels[ClientRect.Right-2, ClientRect.Bottom-1] := FLineColor;
    for i:=2 to FCornerSize-1 do begin
      Canvas.MoveTo(ClientRect.Right-i-1, ClientRect.Bottom-1);
      Canvas.LineTo(ClientRect.Right, ClientRect.Bottom-i-2);
    end;
  end;

end;



end.
