unit Status;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TStatusForm = class(TForm)
    StatePanel: TPanel;
    StateLabel: TLabel;
    Label2: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  procedure ShowStatusMessage(s: string);
  procedure ShowStatusMessageA(ACaption, AMessage: string; clBckg: TColor=clBtnFace; clCaption: TColor=clBlack; clMessage: TColor=clBlack);
  procedure CloseStatusMessage;

var
  StatusWinForm: TStatusForm;


implementation
uses
  main;

{$R *.DFM}

procedure ShowStatusMessage(s: string);
begin
  if StatusWinForm=nil then begin
    StatusWinForm := TStatusForm.Create(Form1);
    StatusWinForm.Left := Form1.Left + (Form1.Width - StatusWinForm.Width) div 2;
    StatusWinForm.Top := Form1.Top + (Form1.Height - StatusWinForm.Height) div 2;
  end;
  StatusWinForm.StateLabel.Caption := s;
  StatusWinForm.Show;
  StatusWinForm.StateLabel.Update;
end;

procedure ShowStatusMessageA(ACaption, AMessage: string; clBckg, clCaption, clMessage: TColor);
begin
  if StatusWinForm=nil then begin
    StatusWinForm := TStatusForm.Create(Form1);
    StatusWinForm.Left := Form1.Left + (Form1.Width - StatusWinForm.Width) div 2;
    StatusWinForm.Top := Form1.Top + (Form1.Height - StatusWinForm.Height) div 2;
  end;
  StatusWinForm.Label2.Caption := ACaption;
  StatusWinForm.StateLabel.Caption := AMessage;

  StatusWinForm.Label2.Font.Color := clCaption;
  StatusWinForm.StateLabel.Font.Color := clMessage;
  StatusWinForm.StatePanel.color := clBckg;

  StatusWinForm.Show;
  StatusWinForm.StateLabel.Update;
end;


procedure CloseStatusMessage;
begin
  if StatusWinForm<>nil then begin
    StatusWinForm.Free;
    StatusWinForm := nil;
  end;
end;

end.
