unit TermoPdvProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, TermoPdv, ComCtrls, ExtCtrls;

const
  termo_marker = 'termo';

type
  TTermoPdvPropForm = class(TForm)
    btTrend: TButton;
    list: TListView;
    Timer1: TTimer;
    btClose: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure listCustomDrawSubItem(Sender: TCustomListView;
      Item: TListItem; SubItem: Integer; State: TCustomDrawState;
      var DefaultDraw: Boolean);
    procedure btTrendClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure listDblClick(Sender: TObject);
  private
    procedure CreateList;
    procedure loadCheckboxes;
    procedure saveCheckboxes;
  public
    M: TTermoPdv;
  end;

var
  TermoPdvPropForm: TTermoPdvPropForm;

implementation
uses
  main,
  inifiles,
  TrendWindow,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;  

{$R *.dfm}

procedure TTermoPdvPropForm.FormActivate(Sender: TObject);
begin
  Caption := ' - ' + M.DeviceName;
  createList;
end;


procedure TTermoPdvPropForm.CreateList;
var
  i: Integer;
begin
  list.Items.Clear;
  for i:=Length( M.Tags )-1 downto 0 do
    with list.Items.Add do begin
      Caption := M.tags[i].name;
      Data := @M.tags[i];
      SubItems.Add('');
      SubItems.Add('');
    end;

  Height := (Length( M.Tags ) + 3) *18;
  if Height < 150 then Height := 150;
  if Height > Form1.Height then Height := Form1.Height;
  top := (Form1.Height - Height) div 2;

  loadCheckBoxes;

  Timer1Timer(nil);
end;

procedure TTermoPdvPropForm.Timer1Timer(Sender: TObject);
var
  i: Integer;
  p: PTermoPdvTagRec;
  s: string;
begin
  for i:=0 to Length( M.Tags )-1 do
    with list.Items[i] do begin
      p := PTermoPdvTagRec( Data );
      s := IntToStr(p.value);
      if SubItems[1] <> s then
        SubItems[1] := s;
    end;
end;

procedure TTermoPdvPropForm.listCustomDrawSubItem(Sender: TCustomListView;
  Item: TListItem; SubItem: Integer; State: TCustomDrawState;
  var DefaultDraw: Boolean);
begin
  if SubItem=1 then
    Sender.Canvas.Brush.Color := PTermoPdvTagRec( item.Data ).shape.Brush.Color
  else
    Sender.Canvas.Brush.Color := clWhite;
end;

procedure TTermoPdvPropForm.btTrendClick(Sender: TObject);
var
  i,k,j: Integer;
  tags, legs: string;
  p: PTermoPdvTagRec;
begin
  tags := '';
  legs := '';
  for i:=0 to list.Items.Count-1 do
    if list.Items[i].Checked then begin
      p := PTermoPdvTagRec( list.Items[i].Data );
      tags := tags + p.tagname + '~/'+inttostr(m.Divisor)+';';
      legs := legs + p.name + ';';
    end;

  if tags<>'' then
    ShowTrendWindow(m.DeviceName, tags, legs, termo_marker, '')
  else
    ShowMessage('  ');

end;

procedure TTermoPdvPropForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  saveCheckBoxes;
end;


procedure TTermoPdvPropForm.loadCheckboxes;
var
  i: Integer;
  s: string;
begin
  s := '';
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    s := ReadString('TermoPdvProp', 'termo_' + m.Parent.Name, '');
  finally
    Free;
  end;

  for i:=0 to list.Items.Count-1 do
    list.Items[i].Checked := Copy(s, i+1, 1) = '1';

end;

procedure TTermoPdvPropForm.saveCheckboxes;
var
  i: Integer;
  s: string;
begin
  s := '';
  for i:=0 to list.Items.Count-1 do
    if list.Items[i].Checked then
      s := s + '1'
    else
      s := s + '0';

  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteString('TermoPdvProp', 'termo_' + m.Parent.Name, s);
  finally
    Free;
  end;

end;

procedure TTermoPdvPropForm.listDblClick(Sender: TObject);
var
  p: PTermoPdvTagRec;
begin
  if list.Selected = nil then Exit;
  p := PTermoPdvTagRec( list.Selected.Data );
  ShowTrendWindow(m.DeviceName, p.tagname + '~/'+inttostr(m.Divisor), p.name, termo_marker, '')
end;

end.
