unit tvGroupProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, tvGroup;

type
  TtvGroupPropForm = class(TForm)
    Label1: TLabel;
    edName: TEdit;
    Label2: TLabel;
    edUnitName: TEdit;
    btAdd: TSpeedButton;
    btDel: TSpeedButton;
    btUp: TSpeedButton;
    btDown: TSpeedButton;
    memo: TMemo;
    Label3: TLabel;
    btOk: TButton;
    btCancel: TButton;
    Bevel1: TBevel;
    list: TListView;
    btEdit: TSpeedButton;
    pnlColor: TPanel;
    ColorDialog1: TColorDialog;
    Label5: TLabel;
    Bevel2: TBevel;
    edDays: TEdit;
    dtDeltaTime: TDateTimePicker;
    udDays: TUpDown;
    edYmin: TEdit;
    udYmin: TUpDown;
    Label6: TLabel;
    edYmax: TEdit;
    udYmax: TUpDown;
    Label7: TLabel;
    cbColor: TCheckBox;
    cbSetDefault: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure btEditClick(Sender: TObject);
    procedure pnlColorClick(Sender: TObject);
    procedure btUpClick(Sender: TObject);
  private
    { Private declarations }
  public
    M: TtvGroup;
  end;

var
  _UnitName: string = '';
  _Descr: string = '';
  _DeltaDays: integer = 0;
  _DeltaTime: TDateTime = 15/(24*60);
  _UseColor: boolean = false;
  _Color: TColor = clBtnFace;
  _Ymax: integer = 100;
  _Ymin: integer = 0;

implementation
uses
  tvTagList, tvTagProp, numbers;

{$R *.dfm}

procedure TtvGroupPropForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  if M=nil then begin
    edName.Text := '';
    edUnitName.Text := _UnitName;
    memo.Text := _Descr;
    udDays.Position := _DeltaDays;
    dtDeltaTime.DateTime := _DeltaTime;
    cbColor.Checked := _UseColor;
    pnlColor.Color := _Color;
    udYmax.Position := _Ymax;
    udYmin.Position := _Ymin;
    list.items.Clear;
  end else begin
    edName.Text := M.Name;
    edUnitName.Text := M.UnitName;
    memo.Text := M.Descr;
    list.items.Clear;
    for i:=0 to length(M.Tags)-1 do
      with list.Items.Add do begin
        Caption := M.Tags[i].Name;
        SubItems.Add(M.Tags[i].Descr);
        SubItems.Add(M.Tags[i].LegName);
        SubItems.Add(M.Tags[i].Transform);

        SubItems.Add(inttostr(M.Tags[i].Width));

        if M.Tags[i].UseColor then
          SubItems.Add(inttostr(M.Tags[i].Color))
        else
          SubItems.Add('');

        SubItems.Add( iif(M.Tags[i].Stairs, '1', '0') );
        SubItems.Add( iif(M.Tags[i].Pointers, '1', '0') );

      end;

    udDays.Position := trunc(M.DefaultDelta);
    dtDeltaTime.DateTime := frac(M.DefaultDelta);
    cbColor.Checked := M.UseColor;
    if cbColor.Checked then pnlColor.Color := M.Color;
    udYmax.Position := M.DefaultYmax;
    udYmin.Position := M.DefaultYmin;;

  end;
end;

// OK
procedure TtvGroupPropForm.btOkClick(Sender: TObject);
var
  i,j: integer;
begin

  edName.Text := trim(edName.Text);
  if edName.Text='' then exit;

  if M=nil then M := TtvGroup.Create;

  M.Name := edName.Text;
  M.UnitName := edUnitName.Text;
  M.Descr := memo.Text;

  M.Clear;
  SetLength(M.Tags, list.Items.Count);
  for i:=0 to list.Items.Count-1 do begin
    M.Tags[i] := TtvTag.Create;
    M.Tags[i].Name := list.Items[i].Caption;
    M.Tags[i].Descr := list.Items[i].SubItems[0];
    M.Tags[i].LegName := list.Items[i].SubItems[1];
    M.Tags[i].Transform := list.Items[i].SubItems[2];
    val(list.Items[i].SubItems[3], M.Tags[i].Width, j);
    M.Tags[i].UseColor := not(list.Items[i].SubItems[4]='');
    val(list.Items[i].SubItems[4], M.Tags[i].Color, j);
    M.Tags[i].Stairs := list.Items[i].SubItems[5] = '1';
    M.Tags[i].Pointers := list.Items[i].SubItems[6] = '1';
  end;

  M.DefaultDelta := udDays.Position + frac(dtDeltaTime.DateTime);
  M.UseColor := cbColor.Checked;
  M.Color := pnlColor.Color;
  M.DefaultYmax := udYmax.Position;
  M.DefaultYmin := udYmin.Position;

  if cbSetDefault.Checked then begin
    _UnitName := edUnitName.Text;
    _Descr := memo.Text;
    _DeltaDays := udDays.Position;
    _DeltaTime := dtDeltaTime.DateTime;
    _UseColor := cbColor.Checked;
    _Color := pnlColor.Color;
    _Ymax := udYmax.Position;
    _Ymin := udYmin.Position;
  end;

  ModalResult := mrOk;
end;

// ADD TAGS
procedure TtvGroupPropForm.btAddClick(Sender: TObject);
var
  i,j: integer;
  flag: boolean;
  s: string;
begin
  for i:=0 to tvTagListForm.list.Items.Count-1 do begin
    flag := false;
    s := tvTagListForm.list.Items[i].Caption;
    for j:=0 to list.Items.Count-1 do
      if SameText(s, list.Items[j].Caption) then begin
        flag := true;
        break;
      end;
    tvTagListForm.list.Items[i].Checked := flag;
  end;

  if tvTagListForm.ShowModal<>mrOk then exit;

  for j:=0 to list.Items.Count-1 do
    list.Items[j].Checked := false;

  for i:=0 to tvTagListForm.list.Items.Count-1 do
    if tvTagListForm.list.Items[i].Checked then begin
      flag := false;
      s := tvTagListForm.list.Items[i].Caption;
      for j:=0 to list.Items.Count-1 do
        if SameText(s, list.Items[j].Caption) then begin
          list.Items[j].SubItems[0] := tvTagListForm.list.Items[i].SubItems[0];
          list.Items[j].Checked := true;
          flag := true;
          break;
        end;
      if not flag then begin
        with list.Items.Add do begin
          Caption := s;
          SubItems.Add(tvTagListForm.list.Items[i].SubItems[0]);
          SubItems.Add(tvTagListForm.list.Items[i].SubItems[0]);
          SubItems.Add(_TagTransform);
          SubItems.Add(_TagWidth);
          SubItems.Add(_TagColor);
          SubItems.Add(_TagStairs);
          SubItems.Add(_TagPointers);
        end;
      end;
    end;

  for j:=list.Items.Count-1 downto 0 do
    if not list.Items[j].Checked then
      list.Items[j].Delete;


  while list.Items.Count>10 do
    list.Items[list.Items.Count-1].Delete;

end;

procedure TtvGroupPropForm.btDelClick(Sender: TObject);
begin
  if list.ItemFocused = nil then exit;
  list.ItemFocused.Delete;
end;

procedure TtvGroupPropForm.btEditClick(Sender: TObject);
var
  w: TtvTagPropForm;
  i,j: integer;
begin
  if list.ItemFocused = nil then exit;

  w := TtvTagPropForm.Create(self);
  try
    w.edLegName.Text := list.ItemFocused.subitems[1];
    w.edTransform.Text := list.ItemFocused.subitems[2];

    w.udWidth.Position := strtoint(list.ItemFocused.subitems[3]);
    w.cbColor.Checked := not (list.ItemFocused.subitems[4] = '');
    if w.cbColor.Checked then
      w.pnlColor.Color := strtoint(list.ItemFocused.subitems[4]);
    w.cbStairs.Checked := list.ItemFocused.subitems[5] = '1';
    w.cbPointers.Checked := list.ItemFocused.subitems[6] = '1';

    if w.ShowModal=mrOk then begin
      list.ItemFocused.subitems[1] := w.edLegName.Text;
      list.ItemFocused.subitems[2] := w.edTransform.Text;

      val(w.edWidth.Text, i, j);
      list.ItemFocused.subitems[3] := inttostr(i);

      if w.cbColor.Checked then
        list.ItemFocused.subitems[4] := inttostr(w.pnlColor.Color)
      else
        list.ItemFocused.subitems[4] := '';

      list.ItemFocused.subitems[5] := iif(w.cbStairs.Checked, '1', '0');
      list.ItemFocused.subitems[6] := iif(w.cbPointers.Checked, '1', '0');

      if w.cbSetDefault.Checked then begin
        _TagTransform := list.ItemFocused.subitems[2];
        _TagWidth     := list.ItemFocused.subitems[3];
        _TagColor     := list.ItemFocused.subitems[4];
        _TagStairs    := list.ItemFocused.subitems[5];
        _TagPointers  := list.ItemFocused.subitems[6];
      end;

    end;
  finally
    w.Free;
  end;

end;

procedure TtvGroupPropForm.pnlColorClick(Sender: TObject);
begin
  ColorDialog1.Color := pnlColor.Color;
  if ColorDialog1.Execute then
    pnlColor.Color := ColorDialog1.Color;
end;

procedure TtvGroupPropForm.btUpClick(Sender: TObject);
var
  s: string;
  ss: array of string;
  i1,i2,i,n: integer;
begin
  if list.Selected = nil then exit;
  i1 := list.Selected.Index;
  if sender = btDown then begin
    i2 := i1 + 1;
    if i2 = list.Items.Count then exit;
  end else begin
    i2 := i1 - 1;
    if i2 < 0 then exit;
  end;


  with list.Items[i1] do begin
    n := list.Items[i1].SubItems.Count;
    SetLength(ss, n);

    s:=Caption;
    for i:=0 to n-1 do ss[i] := Subitems[i];

    Caption := list.Items[i2].Caption;
    for i:=0 to n-1 do Subitems[i] := list.Items[i2].SubItems[i];
  end;

  with list.Items[i2] do begin
    Caption := s;
    for i:=0 to n-1 do Subitems[i] := ss[i];
  end;

  list.Selected := list.Items[i2];
  list.Selected.Focused := true;
end;

end.
