unit tvTagList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, DB, FIBDataSet, pFIBDataSet, FIBDatabase,
  pFIBDatabase;

type
  TtvTagListForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    pFIBTransaction2: TpFIBTransaction;
    ds: TpFIBDataSet;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    list: TListView;
    TabSheet2: TTabSheet;
    listFilter: TListView;
    edFilter: TEdit;
    btSelect: TButton;
    btClear: TButton;
    procedure Button1Click(Sender: TObject);
    procedure listCustomDrawItem(Sender: TCustomListView; Item: TListItem;
      State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure listDblClick(Sender: TObject);
    procedure btSelectClick(Sender: TObject);
    procedure listFilterClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btClearClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    db: TpFIBDatabase;

    procedure Init;
  end;

var
  tvTagListForm: TtvTagListForm;

implementation
uses numbers;

{$R *.dfm}

{ TtvTagListForm }

procedure TtvTagListForm.Init;
begin
  ds.Database := db;
  ds.Transaction.DefaultDatabase := db;
  list.Items.Clear;
  
  try
    ds.Open;
    while not ds.Eof do
      with list.Items.Add do begin
        Caption := ds.FieldByName('TAGNAME').AsString;
        SubItems.Add(ds.FieldByName('DESCR').AsString);
        SubItems.Add(ds.FieldByName('IDTAG').AsString);
        SubItems.Add(ds.FieldByName('ARCNAME').AsString);
        ds.Next;
      end;
    ds.Close;  
  except
    ds.Transaction.Active := false;
  end;
end;

procedure TtvTagListForm.Button1Click(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TtvTagListForm.listCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if item.Checked then
    Sender.Canvas.Brush.Color := clLime
  else
    Sender.Canvas.Brush.Color := clWindow;
end;

procedure TtvTagListForm.listDblClick(Sender: TObject);
begin
  if list.ItemFocused=nil then exit;
  list.ItemFocused.Checked := not list.ItemFocused.Checked;
end;

procedure TtvTagListForm.btSelectClick(Sender: TObject);
var
  i: integer;
begin
  listFilter.Items.Clear;
  if edFilter.Text='' then exit;
  for i:=0 to list.Items.Count-1 do
    if CheckFilter(list.Items[i].Caption, edFilter.Text) then
      with listFilter.Items.Add do begin
        Checked := list.Items[i].Checked;
        Caption := list.Items[i].Caption;
        SubItems.Add(list.Items[i].SubItems[0]);
        Data := pointer(i);
      end;
end;

procedure TtvTagListForm.listFilterClick(Sender: TObject);
begin
  if listFilter.ItemFocused=nil then exit;
  listFilter.ItemFocused.Checked := not listFilter.ItemFocused.Checked;
  list.Items[integer(listFilter.ItemFocused.Data)].Checked := listFilter.ItemFocused.Checked;
end;

procedure TtvTagListForm.PageControl1Change(Sender: TObject);
begin
  btSelectClick(nil);
end;

procedure TtvTagListForm.FormActivate(Sender: TObject);
begin
  btSelectClick(nil);
end;

procedure TtvTagListForm.btClearClick(Sender: TObject);
var
  i: integer;
begin
  for i:=0 to list.Items.Count-1 do
    list.Items[i].Checked := false;

  for i:=0 to listFilter.Items.Count-1 do
    listFilter.Items[i].Checked := false;
end;

procedure TtvTagListForm.FormDestroy(Sender: TObject);
begin
  tvTagListForm := nil;
end;

end.
