unit TrendWindow;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Trends, ExtCtrls, Menus, chart, series;

type
  TTrendWindowForm = class(TForm)
    TrendsFrame: TTrendsFrame;
    btClose: TBitBtn;
    TimerTrends: TTimer;
    pmnuChart: TPopupMenu;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTrendsTimer(Sender: TObject);
    procedure ChartClickLegend(Sender: TCustomChart; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pmnuChartPopup(Sender: TObject);
    procedure SeriesOnOff(Sender: TObject);
    procedure TrendsFramebtSetDeltaClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    TagNames: string;
    Helpfile: string;
    LegendNames: string;
    Ids: string;
    pmnuChartPopupX, pmnuChartPopupY: integer;
  end;


  procedure ShowTrendWindow(caption, tags, legends, ids, helpfile: string; TitleFoot: string='');


implementation

uses
  InfoDlg,
  Connecting,
  TeEngine,
  RpVisualGlobal,
  RpVisualUtils,
  hyperstr;

{$R *.dfm}

//============================================================================
//  :
//    caption   -  
//    tags      -    ( . )
//    legends   -    
//    ids       -         ini
//    helpfile  -
//    TitleFoot - ,  
//
//       ";".
//
//  tags:
//  <_>;<_[~<>]>;<_~[]>;
//  
//     -  , .: TEST.TAG1~/10;
//     -   , .: TEST.TAG1~CAST(^ AS FLOAT)/100;
//                  ^      
//============================================================================
procedure ShowTrendWindow(caption, tags, legends, ids, helpfile: string; TitleFoot: string='');
var
  wnd: TTrendWindowForm;
  k: integer;
begin
  if not isTagloggingConnected then exit;

  wnd := TTrendWindowForm.Create(nil);
//  try
    k := pos(#13, caption);
    if k>0 then
      delete(caption, k, length(caption)-k+1);
    wnd.Caption := caption;
    wnd.TrendsFrame.Chart.Title.Text.Text := caption;
    wnd.TagNames := tags;
    wnd.Helpfile := helpfile;
    wnd.Ids := ids;
    wnd.LegendNames := legends;


    if TitleFoot='' then
      wnd.TrendsFrame.Chart.Foot.Visible := false
    else begin
      wnd.TrendsFrame.Chart.Foot.Visible := true;
      wnd.TrendsFrame.Chart.Foot.Text.Text := TitleFoot;
    end;

//    if Length(TrendWindowForm.TrendsFrame.Srs) > 0 then
    wnd.Show;
//    wnd.ShowModal
//    else
//      showInfoDlg('    ')
//  finally
//    wnd.Free
//  end;
end;

procedure TTrendWindowForm.FormCreate(Sender: TObject);
begin
  TrendsFrame.Init(40.0);
end;

procedure TTrendWindowForm.FormActivate(Sender: TObject);
var
  i,k: integer;
  s: string;
  sl: TStringList;
begin
  if length(ids)>0 then
    LoadTrendProperties(ids, TrendsFrame.Chart);

//  Update;

  TimerTrends.Enabled := true;
  TrendsFrame.CreateTrends( tagnames );

  if Length(TrendsFrame.Srs ) = 0 then begin
    TrendsFrame.Chart.Color := clBtnFace;
  end;
////    FormStyle := fsNormal;
//    PostMessage(Handle, WM_CLOSE, 0, 0);
//    ShowMessage('    ');
//////    showInfoDlg('    ');
////////    ModalResult := mrCancel;
//  end;

  s := LegendNames;
  ReplaceS(s, ';', #13#10);
  sl := TStringList.Create;
  sl.Text := s;

  for i:=0 to Length(TrendsFrame.Srs ) - 1 do begin
    k := TrendsFrame.Srs[i].idx;
    if (k >= 0) and (k < sl.Count) then begin
      TrendsFrame.Chart.Series[i].Title := sl[k];
      TrendsFrame.Chart.Legend.Visible := true;
    end;
  end;


end;

procedure TTrendWindowForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SaveTrendProperties(ids,
        TrendsFrame.Chart.LeftAxis.Minimum,
        TrendsFrame.Chart.LeftAxis.Maximum );

  TimerTrends.Enabled := false;
  TrendsFrame.DeleteTrends;
  Action := caFree;
end;


procedure TTrendWindowForm.TimerTrendsTimer(Sender: TObject);
begin
  TrendsFrame.OnLineUpdateTrends;
end;



// ON / OFF SERIES
procedure TTrendWindowForm.pmnuChartPopup(Sender: TObject);
var
  i: integer;
  m: TMenuItem;
begin
  pmnuChart.Items.Clear;
  for i:=0 to TrendsFrame.Chart.SeriesList.Count-1 do begin
    m := TMenuItem.Create(self);
    m.Caption := TrendsFrame.Chart.SeriesList.Series[i].Title;
    m.Checked := (TrendsFrame.Chart.SeriesList.Series[i] as TLineSeries).LinePen.Style = psSolid;
    m.OnClick := SeriesOnOff;
    pmnuChart.Items.Add(m);
  end;
end;

procedure TTrendWindowForm.SeriesOnOff(Sender: TObject);
var
  i: integer;
begin
  i := pmnuChart.Items.IndexOf(TMenuItem(sender));
  if (i>=0) and (i<TrendsFrame.Chart.SeriesList.Count) then
    if (sender as TMenuItem).Checked then begin
      (TrendsFrame.Chart.SeriesList.Series[i] as TLineSeries).LinePen.Style := psClear;
    end else begin
      (TrendsFrame.Chart.SeriesList.Series[i] as TLineSeries).LinePen.Style := psSolid;
    end;
  pmnuChart.Popup(pmnuChartPopupX, pmnuChartPopupY);
end;

procedure TTrendWindowForm.ChartClickLegend(Sender: TCustomChart;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  pmnuChartPopupX := mouse.CursorPos.x;
  pmnuChartPopupY := mouse.CursorPos.y;
  pmnuChart.Popup(pmnuChartPopupX, pmnuChartPopupY);
end;

procedure TTrendWindowForm.TrendsFramebtSetDeltaClick(Sender: TObject);
begin
  TrendsFrame.btSetDeltaClick(Sender);

end;

procedure TTrendWindowForm.btCloseClick(Sender: TObject);
begin
  close;
end;

end.
