unit UserConfirmation;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Mask, ExtCtrls, UserProfile;

type
  TUserConfirmationForm = class(TForm)
    Panel2: TPanel;
    Panel1: TPanel;
    BitBtn2: TBitBtn;
    lbCardStatus: TLabel;
    CardTimer: TTimer;
    Label1: TLabel;
    lbUser: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CardTimerTimer(Sender: TObject);
  private
    tagCardCnt: Integer;
    tagCardErrorFlag: Integer;
    cardcnt: Integer;

  public
    place: string;
    username: string;
    password: string;
    cardcode: string;
  end;






implementation
uses
  TagStorage,
  UserControlEx;

{$R *.DFM}






{ TUserConfirmationForm }

procedure TUserConfirmationForm.FormCreate(Sender: TObject);
begin
  lbUser.Caption := userEx.name;
  tagCardCnt        := GetTagIndex(userEx_cardReaderTagname + '.Cnt');
  tagCardErrorFlag  := GetTagIndex(userEx_cardReaderTagname + '.SYSTEM.ErrorFlag');
  cardcnt := gettagvalue(tagCardCnt);
end;

procedure TUserConfirmationForm.CardTimerTimer(Sender: TObject);
var
  status, code: string;
  cl: Integer;
begin
  cl := clRed;
  status := '  ';
  if (tagCardErrorFlag = -1) then
    status := status + ''
  else
  if GetTagValue(tagCardErrorFlag)<>0 then
    status := status + ' '
  else begin
    cl := Color;
    status := status + '';

    if GetTagValue(tagCardCnt) <> cardcnt then begin
      CardTimer.Enabled := false;

      code := readCardCode;

      if code <> '' then begin
        if code = userEx.cardcode then
          ModalResult := mrOk
        else begin
          ShowMessage(' !   ' + userEx.name + '!'#13' .');
          ModalResult := mrCancel;
        end;

      end else
        cl := clYellow;

    end;
  end;

  lbCardStatus.Caption := status;
  lbCardStatus.Color := cl;
end;

end.


