unit UserControlEx;

interface
uses
  SysUtils,
  UserProfile,
  Dialogs;

  procedure initUserEx;
  function isModeUserEx: boolean;
  function isPermitted(action: string): boolean;
  function isPermittedSilent(action: string): boolean;  


  function readCardCode: string;

var
  modeUserEx: Boolean = False;
  modeUserExLog: Boolean = False;
  userEx: TUserProfile = nil;

  userEx_DefaultUser: string;
  userEx_cardReaderTagname: string;

implementation
uses
  Numbers,
  TagStorage,
  RpVisualParams;


procedure initUserEx;
begin
  modeUserEx                := rpVisualParams_Read('UserEx', '  ', '') = '1';
  if( modeUserEx ) then begin
    modeUserExLog             := rpVisualParams_Read('UserEx_Log', ' ', '') = '1';
    userEx_DefaultUser        := rpVisualParams_Read('UserEx_DefaultUser', '    ', '');
    userEx_cardReaderTagname  := rpVisualParams_Read('UserEx_CardReader', '    ', '');
  end;
end;


function isModeUserEx: boolean;
begin
  Result := modeUserEx;
end;

function isPermitted(action: string): boolean;
begin
  if modeUserEx then
    Result := userEx.isPermitted(action)
  else
    Result := True;
end;

function isPermittedSilent(action: string): boolean;
begin
   Result := userEx.isPermitted(action,False);
end;

function readCardCode: string;
var
  s: string;
  code: string;
  i, crc1, crc2: Integer;
begin
  s := '';
  code := '';
  for i:=0 to 4 do begin
    s := s + chr( GetTagValueByName(userEx_cardReaderTagname + '.Code' + IntToStr(i)) );
    code := code + DecHexB(ord(s[i+1]));
  end;
  s := s + chr( GetTagValueByName(userEx_cardReaderTagname + '.Cnt'));
  crc1 := GetCRC8(s);
  crc2 := GetTagValueByName(userEx_cardReaderTagname + '.Crc');

  result := '';
  if GetTagValueByName(userEx_cardReaderTagname + '.SYSTEM.ErrorFlag') = 0 then
    if crc1 = crc2 then
      result := code;
end;





end.
