unit UserLogin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Mask, ExtCtrls;

type
  TUserLoginForm = class(TForm)
    Panel2: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    cmbUser: TComboBox;
    edPsw: TMaskEdit;
    btOk: TBitBtn;
    BitBtn2: TBitBtn;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure cmbUserClick(Sender: TObject);
    procedure stopTimer(Sender: TObject);
  end;


  function doUserLogin: boolean;


implementation
uses
  infodlg,
  RpVisualGlobal,
  users,
  DataMod,
  numbers,
  hyperstr,
  FIBQuery;

{$R *.DFM}

function doAutoLogin: boolean;
begin
  result := false;
  try
    dm.QueryMes.Transaction.StartTransaction;

    dm.QueryMes.SQL.Text := 'SELECT IDUSER, NAME, INFO FROM USERS WHERE UPPER(NAME)=''' + UpperCase(AutoLoginUserName)+'''';
    dm.QueryMes.ExecQuery;
    if not dm.QueryMes.Eof then begin
      CurUserId := dm.QueryMes.Fields[0].AsInteger;
      CurUserName := dm.QueryMes.Fields[1].AsString;
      CurUserInfo := dm.QueryMes.Fields[2].AsString;
      result := true;
    end;

    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;
end;


function doUserLogin: boolean;
var
  wnd: TUserLoginForm;
begin
  result := true;

  if SuperMasterMode then begin
    CurUserId := USER_SUPERVISOR;
    CurUserName := '!!! SuperMaster !!!';
    CurUserInfo := CurUserName;
    exit;
  end;

  if AutoLoginUserName <> '' then
    if doAutoLogin then begin
      AutoLoginUserName := '';
      exit;
    end;

  wnd := TUserLoginForm.Create(nil);
  result := wnd.ShowModal = mrOk;
  wnd.Free;
end;


procedure TUserLoginForm.FormCreate(Sender: TObject);
begin
  try
    dm.QueryMes.Transaction.StartTransaction;

    dm.QueryMes.SQL.Text := 'SELECT IDUSER, NAME FROM USERS';
    dm.QueryMes.ExecQuery;

    while not dm.QueryMes.Eof do begin
      cmbUser.Items.AddObject( dm.QueryMes.Fields[1].AsString,
            pointer(dm.QueryMes.Fields[0].AsInteger));
      dm.QueryMes.Next;
    end;
    dm.QueryMes.Close;

    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;
end;


procedure TUserLoginForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  for i:=0 to cmbUser.Items.Count-1 do
    if integer(cmbUser.Items.Objects[i]) = CurUserId then begin
      cmbUser.ItemIndex := i;
      break;
    end;

  if (cmbUser.ItemIndex=-1) and (cmbUser.Items.Count>0) then
    cmbUser.ItemIndex:=0;

  edPsw.SetFocus;
end;


procedure TUserLoginForm.btOkClick(Sender: TObject);
var
  id: integer;
  s: string;
begin
  Timer1.Enabled := false;
  if cmbUser.ItemIndex < 0 then exit;
  id := integer(cmbUser.Items.Objects[cmbUser.ItemIndex]);

  try
    dm.QueryMes.Transaction.StartTransaction;

    dm.QueryMes.SQL.Text := 'SELECT PSW, NAME, INFO FROM USERS WHERE IDUSER=' + inttostr(id);
    dm.QueryMes.ExecQuery;
    if dm.QueryMes.RecordCount > 0 then begin
      s := dm.QueryMes.Fields[0].AsString;
      DeCipher(s);
      if s = edPsw.Text then begin
        CurUserId := id;
        CurUserName := dm.QueryMes.Fields[1].AsString;
        CurUserInfo := dm.QueryMes.Fields[2].AsString;

        dm.QueryMes.Transaction.Commit;
        ModalResult := mrOk;
        exit;
      end;
    end;

    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;

  showInfoDlg(' !', mtError, [mbOk], 0);
  edPsw.SelectAll;
  edPsw.SetFocus;

end;

procedure TUserLoginForm.cmbUserClick(Sender: TObject);
begin
  edPsw.SetFocus;
end;

procedure TUserLoginForm.stopTimer(Sender: TObject);
begin
  Timer1.Enabled := False;
end;

end.


