unit UserLoginEx;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Mask, ExtCtrls, UserProfile;

type
  TUserLoginExForm = class(TForm)
    Panel2: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    cmbUser: TComboBox;
    edPsw: TMaskEdit;
    btOk: TBitBtn;
    BitBtn2: TBitBtn;
    lbCardStatus: TLabel;
    CardTimer: TTimer;
    btList: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure CardTimerTimer(Sender: TObject);
    procedure btListClick(Sender: TObject);
  private
    cardReaderTagname: string;
    tagCardCnt: Integer;
    tagCardErrorFlag: Integer;
    cardcnt: Integer;
    hasList: boolean;

  public
    place: string;
    username: string;
    password: string;
    cardcode: string;
  end;


  function doUserLoginEx(user: TUserProfile): Boolean;
  function doUserConfirmEx(userType:string): Boolean;




implementation
uses
  Users,
  UserControlEx,
  main,
  UserProfileLoaderDirect,
  Numbers,
  TagStorage,
  RpVisualGlobal,
  RpVisualParams;

{$R *.DFM}


function doUserConfirmEx(userType:string): Boolean;
var
  wnd: TUserLoginExForm;
  res: Integer;
begin
  res := 0; // ????
  Result := false;

  wnd := TUserLoginExForm.Create(nil);

  try
    while wnd.ShowModal = mrOk do begin
      if res = 0 then begin

        Form1.pnlUser.Visible := True;
        Form1.pnlUser.Left := Form1.pnlTime.Left-1;

        Result := True;
        Break;
      end;
    end;
  finally
    wnd.Free;
  end;
end;

function doUserLoginEx(user: TUserProfile): Boolean;
var
  wnd: TUserLoginExForm;
  res, i: Integer;
begin
  Result := false;
  user.place := rpVisualParams_Read('UserEx_Place', '  ', '');
  wnd := TUserLoginExForm.Create(nil);
  wnd.place := user.place;
  try
    while wnd.ShowModal = mrOk do begin
      user.name := wnd.username;
      user.password := wnd.password;
      user.cardcode := wnd.cardcode;

      res := getUserProfileDirect(user);

      if res = 0 then begin
        CurUserId := user.id;
        CurUserName := user.name;

        Form1.pnlUser.Visible := True;
        Form1.pnlUser.Left := Form1.pnlTime.Left-1;
        Form1.lbUser.Caption := user.name;

        Form1.lbUser.Top := 9;
        Form1.lbUser.Font.Size := 14;
        Application.ProcessMessages;
        while Form1.lbUser.Font.Size > 7 do begin
          i := Form1.lbUser.Canvas.TextWidth(user.name);
          if i > Form1.lbUser.Width then begin
            Form1.lbUser.Font.Size := Form1.lbUser.Font.Size - 1;
            Application.ProcessMessages;
            i := Form1.lbUser.Canvas.TextHeight(user.name);
            Form1.lbUser.Top := (Form1.pnlUser.Height - i) div 2;
            Application.ProcessMessages;
            Sleep(10);
          end else
            Break;
        end;


        Result := True;
        Break;
      end;
    end;
  finally
    wnd.Free;
  end;

  if result then
    user.noCardConfirm := user.isPermitted('noCardConfirm', false, true);

end;





procedure TUserLoginExForm.FormCreate(Sender: TObject);
begin

  cmbUser.Text      := userEx_DefaultUser;
  cardReaderTagname := userEx_cardReaderTagname;

  tagCardCnt        := GetTagIndex(cardReaderTagname + '.Cnt');
  tagCardErrorFlag  := GetTagIndex(cardReaderTagname + '.SYSTEM.ErrorFlag');

  hasList := False;
end;



procedure TUserLoginExForm.FormActivate(Sender: TObject);
begin
  cardcnt := GetTagValue(tagCardCnt);
  CardTimer.Enabled := true;

  username:='';
  password:='';
  cardcode:='';

  edPsw.SelectAll;
  edPsw.SetFocus;

end;



procedure TUserLoginExForm.btOkClick(Sender: TObject);
begin
  username := Trim(cmbUser.Text);
  password := edPsw.Text;
  cardcode := '';

  if username = '' then exit;

  ModalResult := mrOk;
end;



procedure TUserLoginExForm.CardTimerTimer(Sender: TObject);
var
  status, code: string;
  cl: Integer;
begin
  lbCardStatus.Visible := cardReaderTagname <> '';
  if not lbCardStatus.Visible then
    Exit;

  cl := clRed;
  status := '  ';
  if (tagCardErrorFlag = -1) then
    status := status + ''
  else
  if GetTagValue(tagCardErrorFlag)<>0 then
    status := status + ' '
  else begin
    cl := clBtnFace;
    status := status + '';

    if GetTagValue(tagCardCnt) <> cardcnt then begin
      code := readCardCode;

      if code <> '' then begin
        username := '';
        password := '';
        cardcode := code;
        cardtimer.Enabled := false;
        ModalResult := mrOk;
      end else
        cl := clYellow;

    end;
  end;

  lbCardStatus.Caption := status;
  lbCardStatus.Color := cl;
end;

procedure TUserLoginExForm.btListClick(Sender: TObject);
var
  s: string;
begin
  if not hasList then begin

    if getUsersListDirect(place, s) then begin
      cmbUser.Items.Text := s;
      hasList := True;
    end;
  end;
  cmbUser.DroppedDown := true;
end;

end.


