unit UserProp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Mask, ComCtrls, Buttons;

type
  TUserPropForm = class(TForm)
    Panel1: TPanel;
    edFIO: TMaskEdit;
    Label1: TLabel;
    Memo: TMemo;
    edPass1: TMaskEdit;
    Label2: TLabel;
    Label3: TLabel;
    edPass2: TMaskEdit;
    Label4: TLabel;
    List: TListView;
    btOk: TBitBtn;
    btCancel: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    id: integer;
    NewFlag: boolean;
  end;

//var
//  UserPropForm: TUserPropForm;

implementation

uses
  infodlg, 
  DataMod, HyperStr;

{$R *.DFM}

procedure TUserPropForm.FormActivate(Sender: TObject);
var
  i: integer;
  t: TListItem;
  s: string;
begin
  if NewFlag then begin
    edFIO.Text := '';
    edPass1.Text := '';
    edPass2.Text := '';
    Memo.Text := '';
  end else try
    dm.QueryMes.Transaction.StartTransaction;

    dm.QueryMes.SQL.Text := 'SELECT NAME, INFO, PSW FROM USERS WHERE IDUSER=' + inttostr(id);
    dm.QueryMes.ExecQuery;
    if dm.QueryMes.RecordCount>0 then begin
      edFIO.Text := dm.QueryMes.Fields[0].AsString;
      s := dm.QueryMes.Fields[2].AsString;
      DeCipher(s);
      edPass1.Text := s;
      edPass2.Text := s;
      Memo.Text := dm.QueryMes.Fields[1].AsString;
    end;
    dm.QueryMes.Close;

    dm.QueryMes.SQL.Text := 'SELECT IDPREV FROM USERPREV WHERE IDUSER=' + inttostr(id);
    dm.QueryMes.ExecQuery;
    while not dm.QueryMes.Eof do begin
      i := dm.QueryMes.Fields[0].AsInteger;
      t := List.FindData(0, pointer(i), true, false);
      if t <> nil then T.Checked := true;
      dm.QueryMes.Next;
    end;
    dm.QueryMes.Close;

    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;
  edFIO.SetFocus;
end;

procedure TUserPropForm.FormCreate(Sender: TObject);
begin
  try
    dm.QueryMes.Transaction.StartTransaction;
    List.Items.Clear;
    dm.QueryMes.SQL.Text := 'SELECT NAME, INFO, IDPREV FROM PREVILEGS';
    dm.QueryMes.ExecQuery;
    while not dm.QueryMes.Eof do with List.Items.Add do begin
      Caption := dm.QueryMes.Fields[0].AsString;
      SubItems.Add(dm.QueryMes.Fields[1].AsString);
      Data := pointer(dm.QueryMes.Fields[2].AsInteger);
      dm.QueryMes.Next;
    end;
    dm.QueryMes.Close;

    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;
end;

procedure TUserPropForm.btOkClick(Sender: TObject);
var
  s: string;
  i: integer;
  t: TListItem;
begin
  if trim(edFio.Text) = '' then begin
    showInfoDlg('  !', mtWarning, [mbOk], 0);
    exit;
  end;

  if edPass1.Text <> edPass2.Text then begin
    showInfoDlg('    !   .', mtWarning, [mbOk], 0);
    exit;
  end;

  try
    dm.WrQueryMes.Transaction.StartTransaction;
    dm.QueryMes.Transaction.StartTransaction;

    // new insert
    if NewFlag then begin
      dm.WrQueryMes.SQL.Text := 'SELECT GEN_ID(GEN_USERS_ID,1) AS ID FROM RDB$DATABASE';
      dm.WrQueryMes.ExecQuery;
      id := dm.WrQueryMes.FieldByName('ID').AsInteger;
      dm.WrQueryMes.Close;

      dm.WrQueryMes.SQL.Text := 'INSERT INTO USERS (IDUSER) VALUES (' + inttostr(id) + ')';
      dm.WrQueryMes.ExecQuery;
      dm.WrQueryMes.Close;
    end;

    // update
    s := edPass1.Text;
    EnCipher(s);
    dm.WrQueryMes.SQL.Text := 'UPDATE USERS SET NAME='#39 + trim(edFIO.Text) + #39', INFO='#39 +
          Memo.Text + #39', PSW='#39 + s + #39' WHERE IDUSER=' + inttostr(id);
    dm.WrQueryMes.ExecQuery;
    dm.WrQueryMes.Close;

    // del previleges
    s := '';
    for i:=0 to List.Items.Count-1 do
      if not List.Items[i].Checked then
        s := s + ' OR IDPREV=' + inttostr(integer(List.Items[i].Data));
    if length(s)>0 then begin
      delete(s, 1, 4);
      s := 'DELETE FROM USERPREV WHERE IDUSER=' + inttostr(id) + ' AND (' + s + ')';
      dm.WrQueryMes.SQL.Text := s;
      dm.WrQueryMes.ExecQuery;
      dm.WrQueryMes.Close;
    end;

    // add new prevs
    dm.QueryMes.SQL.Text := 'SELECT IDPREV FROM USERPREV WHERE IDUSER=' + inttostr(id);
    dm.QueryMes.ExecQuery;
    while not dm.QueryMes.Eof do begin
      i := dm.QueryMes.Fields[0].AsInteger;
      t := List.FindData(0, pointer(i), true, false);
      if t <> nil then T.Checked := false;
      dm.QueryMes.Next;
    end;
    dm.QueryMes.Close;

    for i:=0 to List.Items.Count-1 do
      if List.Items[i].Checked then begin
        dm.WrQueryMes.SQL.Text := 'INSERT INTO USERPREV (IDUSER, IDPREV) VALUES (' +
              inttostr(id) + ',' + inttostr(integer(List.Items[i].Data)) + ')';
        dm.WrQueryMes.ExecQuery;
        dm.WrQueryMes.Close;
      end;


    dm.WrQueryMes.Transaction.Commit;
    dm.QueryMes.Transaction.Commit;
  except
    dm.WrQueryMes.Transaction.Active := false;
    dm.QueryMes.Transaction.Active := false;
  end;

  ModalResult := mrOK;
end;

end.
