unit VisBunk; 

interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, VisMchb;

const
  bunkStateOk     = 1;
  bunkStateZach   = 2;
  bunkStateRepair = 3;
type

  TVisBunk = class(TVisMchb)
  private
    FUseScadaObjectClick: boolean;

    procedure ScadaObjectClick(Sender: TObject);
  protected
    FImagePicOk:      TPicName;
    FImagePicZach:    TPicName;
    FImagePicRepair:  TPicName;
    CurBunkState     :Integer;
    procedure OnDeviceMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure   Process; override;
    procedure setImages(imgOk:String;imgZach:String; imgRepair:String);
    procedure changeState(newState:Integer);    
  published
    property OnScadaObjectClick;
    property UseScadaObjectClick: boolean read FUseScadaObjectClick write FUseScadaObjectClick;
  end;


procedure Register;

implementation
uses
  main,
  TagStorage,
  RpVisualGlobal,
  UserControlEx,
  numbers,
  ExtDlgs,
  VisMchbControlPanel;

procedure Register;
begin
  RegisterComponents('Scada', [TVisBunk]);
end;


{ TVisBunk }

procedure TVisBunk.changeState(newState: Integer);
begin
  if(CurBunkState <> newState) then
  begin
    CurBunkState :=  newState;
    if(newState =bunkStateOk) then     ImagePic:=FImagePicOk;
    if(newState =bunkStateZach) then     ImagePic:=FImagePicZach;
    if(newState =bunkStateRepair) then     ImagePic:=FImagePicRepair;    
    ImageObj.Picture.LoadFromFile(ImagePic);
  end;
end;

constructor TVisBunk.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  TypeName1 := 'MCHB';
  TypeName2 := 'MDTA';

  ImageObj.OnClick := ScadaObjectClick;
  LabelObj.OnClick := ScadaObjectClick;

  UseScadaObjectClick := true;
  CurBunkState :=  bunkStateOk;
end;



procedure TVisBunk.OnDeviceMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ScadaObjectClick(sender);
end;


procedure TVisBunk.Process;
var
  value, valOutput, blokval, i: integer;
  label_visible: boolean;
begin
  inherited;
  IsValueBad := false;
  label_visible := false;

  if OnlyDat then begin
    SetImageSost(0);
    blokval := 0;
  end else begin
    value := GetTagValue(FTagMachSost);
    SetImageSost(value);
    IsValueBad := IsValueBad or (value < 0);
    label_visible := label_visible or (value = 4) or (value = 5);

    value := GetTagValue(FTagMctlControl)  and not($10);
    SetFrameMode(value);
    IsValueBad := IsValueBad or (value < 0);
    label_visible := label_visible or (value > 0);

    value := GetTagValue(FTagMachBlok);
    IsValueBad := IsValueBad or (value < 0);
    blokval := value;
  end;

  for i:=0 to DatCount-1 do begin
    valOutput := GetTagValue(Datchik[i].TagIdxOutput);
    value := GetTagValue(Datchik[i].TagIdxBlok);
    IsValueBad := IsValueBad or (valOutput < 0) or (value < 0);
    blokval := blokval or value;

    SetDatColor(i, valOutput);
  end;

  SetFrameBlok(blokval);
  label_visible := label_visible or (blokval > 0);

  if (IsConnectionBad) or (IsValueBad) then
    Visible := not Visible
  else
    Visible := true;

  LabelObj.Visible := label_visible or IsValueBad or (not rvgLogIn);
end;

procedure TVisBunk.ScadaObjectClick(Sender: TObject);
begin
  if UseScadaObjectClick then begin

    if VisMchbControlPanelForm=nil then
      VisMchbControlPanelForm := TVisMchbControlPanelForm.Create(Form1);

    VisMchbControlPanelForm.M := self;

    if Assigned(OnScadaObjectClick) then
      OnScadaObjectClick(self, self, TForm(VisMchbControlPanelForm) );

  end else begin
    if Assigned(OnClick) then
      OnClick(self);
  end;
end;

procedure TVisBunk.setImages(imgOk, imgZach, imgRepair: String);
begin
  FImagePicOk:=imgOk;
  FImagePicRepair:=imgRepair;
  FImagePicZach:=imgZach;
end;

end.
