unit VisCheckBoxScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisCheckBox, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TVisCheckBoxScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
  private
    { Private declarations }
  public
    VisCheckBox:TVisCheckBox;
  end;

  function ShowScriptEdit(aVisCheckBox:TVisCheckBox):boolean;

var
  VisCheckBoxScriptEditForm: TVisCheckBoxScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aVisCheckBox:TVisCheckBox):boolean;
begin
  VisCheckBoxScriptEditForm:= TVisCheckBoxScriptEditForm.Create(Application);
  with VisCheckBoxScriptEditForm do begin
    VisCheckBox := aVisCheckBox;
    Caption := '  - ' + aVisCheckBox.ClassName + '.' + aVisCheckBox.Name;  
    memo.Text := aVisCheckBox.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aVisCheckBox.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TVisCheckBoxScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisCheckBox.Script.Text;
  VisCheckBox.Script.Text:=memo.Text;
  try
    VisCheckBox.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then VisCheckBox.ExecuteScript;
  finally
    VisCheckBox.Script.Text:=tmp_script;
  end;
end;

end.
