unit VisComboBoxScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisComboBox, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TVisComboBoxScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
  private
    { Private declarations }
  public
    VisComboBox:TVisComboBox;
  end;

  function ShowScriptEdit(aVisComboBox:TVisComboBox):boolean;

var
  VisComboBoxScriptEditForm: TVisComboBoxScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aVisComboBox:TVisComboBox):boolean;
begin
  VisComboBoxScriptEditForm:= TVisComboBoxScriptEditForm.Create(Application);
  with VisComboBoxScriptEditForm do begin
    VisComboBox := aVisComboBox;
    Caption := '  - ' + aVisComboBox.ClassName + '.' + aVisComboBox.Name;  
    memo.Text := aVisComboBox.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aVisComboBox.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TVisComboBoxScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisComboBox.Script.Text;
  VisComboBox.Script.Text:=memo.Text;
  try
    VisComboBox.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then VisComboBox.ExecuteScript;
  finally
    VisComboBox.Script.Text:=tmp_script;
  end;
end;

end.
