unit VisControlScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisControl, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls, Buttons;

type
  TVisControlScriptEditForm = class(TForm)
    SynPasSyn1: TSynPasSyn;
    btOk: TButton;
    btCancel: TButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Splitter1: TSplitter;
    Panel3: TPanel;
    Splitter2: TSplitter;
    mesmemo: TMemo;
    memo: TSynMemo;
    edTagPath: TEdit;
    Label1: TLabel;
    edTagRoot: TEdit;
    Label2: TLabel;
    cbScriptEnabled: TCheckBox;
    cbScriptDefEnabled: TCheckBox;
    cbExecuteOnTagChange: TCheckBox;
    cbBadColorsEnabled: TCheckBox;
    Label3: TLabel;
    btCompile: TBitBtn;
    Panel4: TPanel;
    memoTagnames: TSynMemo;
    procedure FormCreate(Sender: TObject);
//    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure memoChange(Sender: TObject);
    procedure btCompileClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure edKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    HasChanges: boolean;
  public
    VisControl:TVisControl;

    procedure apply;
    procedure init(aVisControl: TVisControl);
  end;

  function ShowScriptEdit(aVisControl: TVisControl):boolean;

var
  VisControlScriptEditForm: TVisControlScriptEditForm;

implementation

uses
  HyperStr,
  ScadaBase;

{$R *.dfm}



function ShowScriptEdit(aVisControl: TVisControl):boolean;
begin
  result := false;
  VisControlScriptEditForm:= TVisControlScriptEditForm.Create(Application);
  try
    with VisControlScriptEditForm do begin
      init(aVisControl);
      if ShowModal = mrOk then begin
        apply;
        result := True;
      end;
    end;
  finally
    VisControlScriptEditForm.Free;
  end;
end;

procedure TVisControlScriptEditForm.init(aVisControl: TVisControl);
begin
  VisControl := aVisControl;
  Caption := ' ' + aVisControl.ClassName + '.' + aVisControl.Name;
  memo.Text := aVisControl.Script.Text;
  edTagPath.Text := aVisControl.TagPath;
  edTagRoot.Text := aVisControl.TagRoot;
  memoTagnames.Text := aVisControl.TagNames.Text;
  cbBadColorsEnabled.Checked := aVisControl.BadColorsEnabled;
  cbExecuteOnTagChange.Checked := aVisControl.ExecuteOnTagChange;
  cbScriptEnabled.Checked := aVisControl.ScriptEnabled;
  cbScriptDefEnabled.Checked := aVisControl.ScriptDefEnabled;
end;

procedure TVisControlScriptEditForm.apply;
begin
  VisControl.Script.Text:=memo.Text;
  VisControl.TagPath := edTagPath.Text;
  VisControl.TagRoot := edTagRoot.Text;
  VisControl.TagNames.Text := memoTagnames.Text;
  VisControl.BadColorsEnabled := cbBadColorsEnabled.Checked;
  VisControl.ExecuteOnTagChange := cbExecuteOnTagChange.Checked;
  VisControl.ScriptEnabled := cbScriptEnabled.Checked;
  VisControl.ScriptDefEnabled := cbScriptDefEnabled.Checked;
end;

procedure TVisControlScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisControl.Script.Text;
  VisControl.Script.Text:=memo.Text;
  try
    VisControl.CompileScript(messages);
    if Pos('Successfully compiled!', messages) > 0  then
      mesmemo.Color := $00BFFFBF
    else
      mesmemo.Color := clWhite;
    mesmemo.Text := messages;
  finally
    VisControl.Script.Text:=tmp_script;
  end;
end;

procedure TVisControlScriptEditForm.FormCreate(Sender: TObject);
begin
  HasChanges := false;
end;

//procedure TVisControlScriptEditForm.FormCloseQuery(Sender: TObject;
//  var CanClose: Boolean);
//var
//  i: integer;
//begin
//  if not HasChanges then exit;
//
//  i := MessageDlg('   ?', mtConfirmation, mbYesNoCancel, 0);
//  case i of
//    mrYes: begin
//        ModalResult := mrOk;
//        CanClose := true;
//      end;
//    mrNo: begin
//        CanClose := true;
//      end;
//    else
//      CanClose := false;
//  end;
//
//end;

procedure TVisControlScriptEditForm.memoChange(Sender: TObject);
begin
  HasChanges := true;
end;

procedure TVisControlScriptEditForm.FormActivate(Sender: TObject);
begin
  edTagRoot.SetFocus;
  edTagRoot.SelectAll;
end;

procedure TVisControlScriptEditForm.edKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = Char(13) then begin
    ModalResult := mrOk;
//    Close;
  end;
end;

end.
