unit VisDataboard;

//          
//uPSR_visscada.pas
//uPSC_visscada.pas


interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase,
  VisLabel,
  uPSComponent, uPSCompiler, uPSRuntime
  ;


type
//  TSetTagValueEvent = procedure(TagIndex: integer; Value: integer) of object;

  TVisDataboard = class(TVisLabel)
  private
//    FOnSetTagValue: TSetTagValueEvent;
    FDataPar: TStringList;
    FDataMes: TStringList;
    FCaption: string;
    FHideHideMessages: boolean;
    FHideParameters: boolean;
    FCanClickEvent: TCanClickEvent;
    FTrendButtonVisible: Boolean;
    FReadonly: Boolean;

    procedure SetDataPar(Value: TStringList);
    procedure SetDataMes(Value: TStringList);
  protected

    procedure ShapeMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);

    procedure PSScriptCompile(Sender: TPSScript);
    procedure PSScriptCompImport(Sender: TObject; x: TPSPascalCompiler);
    procedure PSScriptExecImport(Sender: TObject; se: TPSExec; x: TPSRuntimeClassImporter);
    procedure PSScriptExecute(Sender: TPSScript); 
  public
    procedure LoadSetupData;
    procedure SaveSetupData;
    procedure OnControlClick(Sender: TObject);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Init; override;
    function mescode_to_text(i: integer): string;

    function CompileScript(var Messages: string): boolean; override;
    procedure ExecuteScript; override;
  published
    property Caption: string read FCaption write FCaption;
    property HideMessages: boolean read FHideHideMessages write FHideHideMessages;
    property HideParameters: boolean read FHideParameters write FHideParameters;
    property DataPar: TStringList read FDataPar write SetDataPar;
    property DataMes: TStringList read FDataMes write SetDataMes;
    property OnCanClick: TCanClickEvent read FCanClickEvent write FCanClickEvent;
    property TrendButtonVisible: boolean read FTrendButtonVisible write FTrendButtonVisible;
    property AccessReadonly: boolean read FReadonly write FReadonly;
  end;

  TVisDataboardEditor = class(TComponentEditor)
  public
    procedure Edit; override;
  end;



procedure Register;

implementation
uses
  uPSR_std,
  uPSC_std,
  uPSR_stdctrls,
  uPSC_stdctrls,
  uPSR_extctrls,
  uPSC_extctrls,
  uPSR_forms,
  uPSC_forms,
  uPSC_graphics,
  uPSC_controls,
  uPSC_classes,
  uPSR_graphics,
  uPSR_controls,
  uPSR_classes,
  uPSR_visscada,
  uPSC_visscada,

  RpVisualUtils,
  RpVisualGlobal,
  VisDataboardSetup,
  VisDataboardWnd,
  numbers,
  hyperstr;

var
  PSScript: TPSScript;
  PSScript_refcount: integer;
  PSVisDataboard: TVisDataboard;
  tmp_compile_src, tmp_compile_out: string;


procedure Register;
begin
  RegisterComponents('Scada', [TVisDataboard]);
  RegisterComponentEditor(TVisDataboard, TVisDataboardEditor);
end;

constructor TVisDataboard.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FLabel.OnClick := OnControlClick;
  FShape.OnMouseUp := ShapeMouseUp;
  FDataPar := TStringList.Create;
  FDataMes := TStringList.Create;
  FReadonly := false;

  if PSScript = nil then begin
    PSScript := TPSScript.Create(nil);
    PSScript.OnCompile := PSScriptCompile;
    PSScript.OnCompImport := PSScriptCompImport;
    PSScript.OnExecImport := PSScriptExecImport;
    PSScript.OnExecute := PSScriptExecute;
    inc(PSScript_refcount);
  end;

  FTrendButtonVisible := false;
end;


destructor TVisDataboard.Destroy;
begin
  FDataPar.Free;
  FDataMes.Free;
  inherited;
end;


procedure TVisDataboard.Init;
begin
  inherited Init;
  Caption := replaceAllMarkers(Caption);
end;


procedure TVisDataboard.LoadSetupData;
begin

end;

procedure TVisDataboard.SaveSetupData;
begin

end;

procedure TVisDataboard.OnControlClick(Sender: TObject);
var
  w: TVisDataboardWndForm;
  can:boolean;
begin
  if not rvgLogIn then
    exit;

  if Assigned(OnCanClick) then begin
    can := true;
    OnCanClick(self, can);
    if not can then  exit;
  end;

  if (FHideHideMessages) and (FHideParameters) then
    exit;

  w := TVisDataboardWndForm.Create(self);

  if FHideHideMessages then
    w.TabSheet1.TabVisible := false;

  if FHideParameters then
    w.TabSheet2.TabVisible := false;

  w.M := self;
  w.Init;
  w.ShowModal;
  w.free;
end;


procedure TVisDataboard.SetDataMes(Value: TStringList);
begin
  FDataMes.Assign(Value);
end;

procedure TVisDataboard.SetDataPar(Value: TStringList);
begin
  FDataPar.Assign(Value);
end;

procedure TVisDataboard.ShapeMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  OnControlClick(sender);
end;

{ TVisDataboardEditor }

procedure TVisDataboardEditor.Edit;
begin
  inherited;
  if showDataboardSetup(Component as TVisDataboard) then
     Designer.Modified;
{
  VisDataboardSetupForm := TVisDataboardSetupForm.Create(nil);

  VisDataboardSetupForm.M := Component as TVisDataboard;
  VisDataboardSetupForm.D := Self;
  if VisDataboardSetupForm.ShowModal = mrOk then
    Designer.Modified;

//    VisDataboardSetupForm.M.SaveSetupData
//  else
//    VisDataboardSetupForm.M.LoadSetupData;

  VisDataboardSetupForm.Free;
  }
end;

function TVisDataboard.mescode_to_text(i: integer): string;
begin
  case i of
    0: result:='=';
    1: result:='>=';
    2: result:='<=';
    3: result:='<>';
    4: result:='(x&val)=0';
    5: result:='(x&val)>0';
  else
    result:='';
  end;    
end;


//==============================================================================
procedure TVisDataboard.PSScriptCompile(Sender: TPSScript);
begin
  Sender.AddRegisteredPTRVariable('self', 'TVisDataboard');
end;

procedure TVisDataboard.PSScriptCompImport(Sender: TObject; x: TPSPascalCompiler);
begin
  SIRegister_Std(x);
  SIRegister_Classes(x, true);
  SIRegister_Graphics(x, true);
  SIRegister_Controls(x);
  SIRegister_stdctrls(x);
  SIRegister_extctrls(x);
  SIRegister_Forms(x);
  SIRegister_visscada(x);
end;

procedure TVisDataboard.PSScriptExecImport(Sender: TObject; se: TPSExec;
  x: TPSRuntimeClassImporter);
begin
  RIRegister_Std(x);
  RIRegister_Classes(x, True);
  RIRegister_Graphics(x, True);
  RIRegister_Controls(x);
  RIRegister_stdctrls(x);
  RIRegister_extctrls(x);
  RIRegister_Forms(x);
  RIRegister_visscada(x);
end;

procedure TVisDataboard.PSScriptExecute(Sender: TPSScript);
begin
  Sender.SetPointerToData('self', @PSVisDataboard, sender.FindNamedType('TVisDataboard'));
end;

function TVisDataboard.CompileScript(var Messages: string): boolean;
var
  i: integer;
begin
  if SameText(tmp_compile_src, Script.Text) then begin
    CompiledScript := tmp_compile_out;
    IsCompileScriptOk := true;
  end else begin
    try
      PSVisDataboard := self;
      PSScript.Script.Text := Script.Text;
      IsCompileScriptOk := PSScript.Compile;

      if IsCompileScriptOk then begin
        PSScript.GetCompiled(CompiledScript);
        tmp_compile_src := Script.Text;
        tmp_compile_out := CompiledScript;
      end;

      Messages := '';
      for i:=0 to PSScript.CompilerMessageCount-1 do
        Messages := Messages + PSScript.CompilerMessages[i].MessageToString + #13#10;
    except
      on E: Exception do begin
        Messages := Messages + E.Message + #13#10;
      end;
    end;
  end;

  if IsCompileScriptOk then
    Messages := Messages + 'Successfully compiled!'#13#10;

  result := true;  
end;

procedure TVisDataboard.ExecuteScript;
begin
  if IsCompileScriptOk then begin
    PSVisDataboard := self;
    PSScript.SetCompiled(CompiledScript);
    PSScript.Execute;
  end;
end;


end.
