unit VisDataboardSetup;

interface

uses
  ToolsAPI,
  ExtDlgs, inifiles,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VisDataboard, Mask, ExtCtrls, Buttons, ComCtrls,
  VisControlScriptEdit;

type
  TVisDataboardSetupForm = class(TForm)
    listControl: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    listPar: TListView;
    btAddMes: TSpeedButton;
    btDelMes: TSpeedButton;
    listMes: TListView;
    btUpMes: TSpeedButton;
    btDownMes: TSpeedButton;
    tbVisControl: TTabSheet;
    btOk: TButton;
    btCancel: TButton;
    btAddPar: TSpeedButton;
    btDelParClick: TSpeedButton;
    btUpPar: TSpeedButton;
    btDownPar: TSpeedButton;
    Button1: TButton;
    Button2: TButton;
    procedure FormActivate(Sender: TObject);
    procedure btAddMesClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure btAddParClick(Sender: TObject);
    procedure btUpDownClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
  private
//    procedure VisControlEditorFormClose(Sender: TObject;
//      var Action: TCloseAction);
    procedure edKeyPress(Sender: TObject; var Key: Char);
  public
    M: TVisDataboard;
//    D: TVisDataboardEditor;
    VisControlEditor: TVisControlScriptEditForm;
  end;

  function showDataboardSetup(databoard: TVisDataboard): boolean;

var
  VisDataboardSetupForm: TVisDataboardSetupForm;

implementation
uses
  Numbers,
  VisDataboardMesProp,
  VisDataboardParProp,
  hyperstr;

{$R *.DFM}

function showDataboardSetup(databoard: TVisDataboard): boolean;
begin
  result := false;
  VisDataboardSetupForm := TVisDataboardSetupForm.Create(nil);

  VisDataboardSetupForm.M := databoard;
//  VisDataboardSetupForm.D := Self;

  if VisDataboardSetupForm.ShowModal = mrOk then begin
    result := true;
  end;

  VisDataboardSetupForm.Free;
end;


procedure TVisDataboardSetupForm.FormActivate(Sender: TObject);
var
  s: string;
  i: integer;
begin
  Caption := ' ' + M.ClassName + '.' + M.Name;

  VisControlEditor.init(M);
  VisControlEditor.FormActivate(nil);

  for i:=0 to M.DataMes.Count-1 do
    with listMes.Items.Add do begin
      s := M.DataMes[i];
      Caption := get_substr_beg(';', s);         // text
      SubItems.Add( get_substr_beg(';', s) );    // tagname
      SubItems.Add( '' );                        // oper_text
      SubItems.Add( get_substr_beg(';', s) );    // val
      SubItems.Add( get_substr_beg(';', s) );    // oper
      SubItems[1] := M.mescode_to_text(strtoint(SubItems[3]));
    end;

  for i:=0 to M.DataPar.Count-1 do
    with listPar. Items.Add do begin
      s := M.DataPar[i];
      Caption := get_substr_beg(';', s);         // text
      SubItems.Add( get_substr_beg(';', s) );    // tagname
      SubItems.Add( get_substr_beg(';', s) );    // transform
      SubItems.Add( get_substr_beg(';', s) );    // enumeration
      SubItems.Add( get_substr_beg(';', s) );    // decnum
      SubItems.Add( get_substr_beg(';', s) );    // adminaccess
    end;

end;



procedure TVisDataboardSetupForm.btAddMesClick(Sender: TObject);
var
  w: TVisDataboardMesPropForm;
  newflag: boolean;
  i: integer;
  s: string;
begin
  newflag := sender = btAddMes;
  w := TVisDataboardMesPropForm.Create(self);

  for i:=0 to 20 do begin
    s := M.mescode_to_text(i);
    if s = '' then break;
    w.cmbCond.Items.Add(s);
  end;

  if newflag then begin
    w.edText.Text := '';
    w.edTagname.Text := '';
    w.cmbCond.ItemIndex := 0;
    w.edVal.Text := '0';
  end else begin
    if listMes.Selected = nil then exit;
    w.edText.Text := listMes.Selected.Caption;
    w.edTagname.Text := listMes.Selected.Subitems[0];
    w.cmbCond.ItemIndex := strtoint(listMes.Selected.Subitems[3]);
    w.udVal.Position := strtoint(listMes.Selected.Subitems[2]);
  end;

  if w.ShowModal = mrOk then begin
    if newflag then begin
      listMes.Selected := listMes.Items.Add;
      with listMes.Selected do begin
        SubItems.Add('');
        SubItems.Add('');
        SubItems.Add('');
        SubItems.Add('');
      end;
    end;

    with listMes.Selected do begin
      Caption := w.edText.Text;
      Subitems[0] := w.edTagname.Text;
      Subitems[1] := M.mescode_to_text( w.cmbCond.ItemIndex );
      Subitems[2] := w.edVal.Text;
      Subitems[3] := inttostr( w.cmbCond.ItemIndex );
    end;
  end;

  w.Free;
end;

procedure TVisDataboardSetupForm.btDelClick(Sender: TObject);
var
  i: integer;
  list: TListView;
begin

  if sender = btDelMes then
    list := listMes
  else
    list := listPar;

  if list.Selected=nil then exit;
  i := list.Selected.Index;
  list.Selected.Delete;
  if list.Items.Count>0 then
    if i = list.Items.Count then
      list.Selected := list.Items[list.Items.Count-1]
    else
      list.Selected := list.Items[i];
end;

procedure TVisDataboardSetupForm.btAddParClick(Sender: TObject);
var
  w: TVisDataboardParPropForm;
  newflag: boolean;
  s: string;
  i,j: integer;
begin
  newflag := sender = btAddPar;
  w := TVisDataboardParPropForm.Create(self);


  if newflag then begin
    w.edText.Text := '';
    w.edTagname.Text := '';
    w.memoTrans.text := '';
    w.memoEnum.text := '';
  end else begin
    if listPar.Selected = nil then exit;
    w.edText.Text := listPar.Selected.Caption;
    w.edTagname.Text := listPar.Selected.Subitems[0];
    val(listPar.Selected.Subitems[3], i, j);
    w.udDecnum.Position := i;
    val(listPar.Selected.Subitems[4], i, j);
    w.cbAdminAccess.Checked := i>0;

    s := Trim(listPar.Selected.Subitems[1]);
    if s = 'A' then
      w.cbChannel.Checked := True
    else begin
      ReplaceS(s, ',', #13#10);
      w.memoTrans.text := s;

      s := listPar.Selected.Subitems[2];
      ReplaceS(s, ',', #13#10);
      w.memoEnum.text := s;
    end;


  end;


  if w.ShowModal = mrOk then begin
    if w.cbChannel.Checked then begin
      w.memoTrans.text := 'A';
      w.memoEnum.Text := '';
      w.edDecnum.Text := '0';
    end;
    
    if newflag then begin
      listPar.Selected := listPar.Items.Add;
      with listPar.Selected do begin
        SubItems.Add('');
        SubItems.Add('');
        SubItems.Add('');
        SubItems.Add('');
        SubItems.Add('');
      end;
    end;

    with listPar.Selected do begin
      Caption := w.edText.Text;
      Subitems[0] := w.edTagname.Text;

      s := w.memoTrans.text;
      ReplaceS(s, #13#10, ',');
      listPar.Selected.Subitems[1] := s;

      s := w.memoEnum.text;
      ReplaceS(s, #13#10, ',');
      listPar.Selected.Subitems[2] := s;

      Subitems[3] := w.edDecnum.Text;

      Subitems[4] := iif(w.cbAdminAccess.Checked, '1', '0');;
    end;
  end;

  w.Free;
end;


procedure TVisDataboardSetupForm.OkClick(Sender: TObject);
var
  i: integer;
begin
  M.DataMes.Clear;
  for i:=0 to listMes.Items.Count-1 do
    with listMes.Items[i] do
      M.DataMes.Add(Caption + ';' + SubItems[0] + ';' + SubItems[2] + ';' + SubItems[3]);

  M.DataPar.Clear;
  for i:=0 to listPar.Items.Count-1 do
    with listPar.Items[i] do
      M.DataPar.Add(Caption + ';' + SubItems[0] + ';' + SubItems[1] + ';' + SubItems[2] + ';' + SubItems[3] + ';' + SubItems[4]);

end;


procedure TVisDataboardSetupForm.btUpDownClick(Sender: TObject);
var
  i,ii,k,n: integer;
  list: TListView;
  upflag: boolean;
  t: TListItem;
begin

  if (sender = btUpMes) or (sender = btDownMes) then
    list := listMes
  else
    list := listPar;

  if list.Selected = nil then exit;

  i := list.Selected.Index;
  upflag := (sender = btUpMes) or (sender = btUpPar);
  if upflag then
    ii := i - 1
  else
    ii := i + 1;

  if (ii<0) or (ii=list.Items.Count) then exit;

  n := list.items[i].SubItems.Count;
  t := TListItem.Create(list.items);
  t.Caption := list.items[i].Caption;
  for k:=0 to n-1 do
    t.SubItems.Add( list.items[i].SubItems[k] );

  list.items[i].Caption := list.items[ii].Caption;
  for k:=0 to n-1 do
    list.items[i].SubItems[k] := list.items[ii].SubItems[k];

  list.items[ii].Caption := t.Caption;
  for k:=0 to n-1 do
    list.items[ii].SubItems[k] := t.SubItems[k];

  t.Free;

  list.Selected := list.items[ii];
  list.items[ii].Focused := true;
end;

procedure TVisDataboardSetupForm.FormCreate(Sender: TObject);
begin
  VisControlEditor := TVisControlScriptEditForm.Create(self);
  VisControlEditor.Parent := tbVisControl;
  VisControlEditor.Align := alClient;
  VisControlEditor.BorderStyle := bsNone;
  VisControlEditor.Show;
  VisControlEditor.edTagRoot.OnKeyPress := edKeyPress;
  VisControlEditor.edTagPath.OnKeyPress := edKeyPress;
end;

procedure TVisDataboardSetupForm.edKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = Char(13) then 
    ModalResult := mrOk;
end;


procedure TVisDataboardSetupForm.FormDestroy(Sender: TObject);
begin
  VisControlEditor.Free;
end;

procedure TVisDataboardSetupForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin

// !!!!!!!!!!!!!
//
//  ShowMessage( extractFilePath( getActiveProject.fileName ) );
//
// !!!!!!!!!!!!!


  if ModalResult = mrOk then begin
    VisControlEditor.apply;
    M.SaveSetupData;
  end else
    M.LoadSetupData;

end;




procedure TVisDataboardSetupForm.FormMouseWheel(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
var
  i: integer;
begin
  with listControl do begin
    i:=ActivePageIndex;

    if WheelDelta<0 then begin
      repeat
        inc(i);
        if i < PageCount then
          if Pages[i].TabVisible then begin
            ActivePageIndex := i;
            break;
          end;
      until i>=PageCount;
      Handled := true;
    end;

    if WheelDelta>0 then begin
      repeat
        dec(i);
        if i >= 0 then
          if Pages[i].TabVisible then begin
            ActivePageIndex := i;
            break;
          end;
      until i<0;
      Handled := true;
    end;

  end;
end;

end.
