unit VisDltA;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, VisMachine, VisMcha; //VisVespC;


type
  TVisDltA = class(TVisMcha)//TVisVespC)
  protected
    FTagDltaReg2100: integer;
    FTagDltaReg2101: integer;
    FTagDltaEnable: integer;
    FTagDltaSost: integer;
    FTagDltaErrorFlag: integer;
//    procedure SetDatColor(idx, value: integer);
  public
    constructor Create(AOwner: TComponent); override;
    procedure Init; override;
    procedure Process; override;
  end;


procedure Register;

implementation
uses
  TagStorage,
  numbers,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisDltA]);
end;

{ TVisDltA }

constructor TVisDltA.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTagDltaReg2100 := -1;
  FTagDltaReg2101 := -1;
  FTagDltaEnable := -1;
  FTagDltaSost := -1;
  FTagDltaErrorFlag := -1;
end;

{
//   
procedure TVisDltA.SetDatColor(idx, value: integer);
begin
  if (value <> Datchik[idx].valSost) or (value>0) then begin

    if Datchik[idx].ColorScheme = 0 then begin
      case value of
      0: Datchik[idx].Shape.Brush.Color := clAqua;

      1,4: Datchik[idx].Shape.Brush.Color := clYellow;

      2: Datchik[idx].Shape.Brush.Color := clRed;

      3: if Datchik[idx].Shape.Brush.Color = clRed then
           Datchik[idx].Shape.Brush.Color := clYellow
         else
           Datchik[idx].Shape.Brush.Color := clRed;
      end;
    end;

    if Datchik[idx].ColorScheme = 1 then begin
      if value in [0,2] then
        Datchik[idx].Shape.Brush.Color := clAqua
      else
        Datchik[idx].Shape.Brush.Color := clYellow;
    end;

    Datchik[idx].valSost := value;
  end;

end;

}

// INIT
procedure TVisDltA.Init;
var
  i: integer;
begin
  inherited;
  
  FTagDltaEnable := GetTagIndex(TagPath + '.DLTA_' + TagName + '_Enable');
  FTagDltaReg2100 := GetTagIndex(TagPath + '.DLTA_' + TagName + '_Reg2100');
  FTagDltaReg2101 := GetTagIndex(TagPath + '.DLTA_' + TagName + '_Reg2101');
  FTagDltaSost := GetTagIndex(TagPath + '.DLTA_' + TagName + '_Sost');
  FTagDltaErrorFlag := GetTagIndex(TagPath + '.DLTA_' + TagName + '_ErrorFlag');

  IsConnectionBad := (FTagDltaEnable<0) or (FTagDltaReg2100<0) or (FTagDltaReg2101<0) or
      (FTagDltaSost<0) or (FTagDltaErrorFlag<0);



  for i:=0 to DatCount-1 do with Datchik[i]^ do begin
    TagIdxOutput := GetTagIndex(format('%s.MDTA_%s%s_Sost',
        [TagPath, TagName, TagPostfix]));

    TagIdxBlok := GetTagIndex(format('%s.MDTA_%s%s_Blok',
        [TagPath, TagName, TagPostfix]));

    IsConnectionBad := (IsConnectionBad) or (TagIdxOutput<0) or (TagIdxBlok<0);
  end;

end;

// PROCESS HANDLER
procedure TVisDltA.Process;
var
  value, venab, vreg2100, vreg2101, verr, vsost, valOutput, blokval, i: integer;
begin

  IsValueBad := false;

  venab := GetTagValue(FTagDltaEnable);
  vreg2100 := GetTagValue(FTagDltaReg2100);
  vreg2101 := GetTagValue(FTagDltaReg2101);
  vsost := GetTagValue(FTagDltaSost);
  verr := GetTagValue(FTagDltaErrorFlag);


  IsValueBad := IsValueBad or (venab < 0) or (vreg2100 < 0) or (vreg2101 < 0)
        or (vsost < 0) or (verr < 0);

  SetImageSost(vsost);

  SetFrameMode( (venab and 2) );

  blokval := 0;
  for i:=0 to DatCount-1 do begin
    valOutput := GetTagValue(Datchik[i].TagIdxOutput);
    value := GetTagValue(Datchik[i].TagIdxBlok);
    IsValueBad := IsValueBad or (valOutput < 0) or (value < 0);
    blokval := blokval or value;

    SetDatColor(i, valOutput);
  end;
  SetFrameBlok(blokval);

  if (IsConnectionBad) or (IsValueBad) then
    Visible := not Visible
  else
    Visible := true;

end;






end.
