unit VisDltB;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, VisMachine, VisMcha; 

//const
//  dmVFDM = 0;
//  dmVFDE = 1;
//  dmVFDB = 2;

type
  TVisDeltaVFDModel = (dmVFDM, dmVFDE, dmVFDB);

  TVisDltB = class(TVisMcha)
  protected
    FTagDltbReg2100: integer;
    FTagDltbReg2101: integer;
    FTagDltbErrorFlag: integer;
    FVFDModel: TVisDeltaVFDModel;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Init; override;
    procedure Process; override;
  published
    property VFDModel: TVisDeltaVFDModel read FVFDModel write FVFDModel;
  end;


procedure Register;

implementation
uses
  TagStorage,
  numbers,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisDltB]);
end;

{ TVisDltB }

constructor TVisDltB.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTagDltbReg2100 := -1;
  FTagDltbReg2101 := -1;
  FTagDltbErrorFlag := -1;
end;


// INIT
procedure TVisDltB.Init;
begin
  inherited;

  FTagDltbReg2100 := GetTagIndex(TagPath + '.Reg.R2100');
  FTagDltbReg2101 := GetTagIndex(TagPath + '.Reg.R2101');
  FTagDltbErrorFlag := GetTagIndex(TagPath + '.SYSTEM.ErrorFlag');

  IsConnectionBad := (FTagDltbReg2100<0) or (FTagDltbReg2101<0) or (FTagDltbErrorFlag<0);
end;

// PROCESS HANDLER
procedure TVisDltB.Process;
var
  value, vreg2100, vreg2101, verr: integer;
begin

  IsValueBad := false;

  vreg2100 := GetTagValue(FTagDltbReg2100);
  vreg2101 := GetTagValue(FTagDltbReg2101);
  verr := GetTagValue(FTagDltbErrorFlag);


  IsValueBad := IsValueBad or (vreg2100 < 0) or (vreg2101 < 0) or (verr < 0);


  value := 0;

  if VFDModel = dmVFDM then begin
    if vreg2100 > 0 then value := 4 else
    if (vreg2101 and $1000) > 0 then value := 1;
    if verr > 0 then value := 3;
  end;

  if VFDModel = dmVFDE then begin
    if vreg2100 > 0 then value := 4 else
    if (vreg2101 and $3) = 3 then value := 1;
    if verr > 0 then value := 3;
  end;

  if VFDModel = dmVFDB then begin
    if vreg2100 > 0 then value := 4 else
    if (vreg2101 and $3) = 1 then value := 1;
    if verr > 0 then value := 3;
  end;

  SetImageSost(value);

  if (IsConnectionBad) or (IsValueBad) then
    Visible := not Visible
  else
    Visible := true;

end;






end.
