unit VisDynamicPictSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VisDynamicPict, Mask, ExtCtrls, Buttons, ComCtrls, RpVisualGlobal;

type
  TVisDynamicPictSetupForm = class(TForm)
    Panel1: TPanel;
    DeviceNameEdit: TMaskEdit;
    Label1: TLabel;
    Label3: TLabel;
    TagNameEdit: TMaskEdit;
    TagPathEdit: TMaskEdit;
    Label4: TLabel;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    Panel2: TPanel;
    Label7: TLabel;
    listTag: TListView;
    btAddTag: TSpeedButton;
    btDelTag: TSpeedButton;
    Panel3: TPanel;
    Label2: TLabel;
    btAddPict: TSpeedButton;
    btDelPict: TSpeedButton;
    listPict: TListView;
    Panel4: TPanel;
    memo: TMemo;
    ImageView: TImage;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    cbUpdateOnTagsChanging: TCheckBox;
    Label9: TLabel;
    procedure DeviceNameEditChange(Sender: TObject);
    procedure TagPathEditChange(Sender: TObject);
    procedure TagNameEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure memoChange(Sender: TObject);
    procedure listPictChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure btAddTagClick(Sender: TObject);
    procedure btDelTagClick(Sender: TObject);
    procedure btAddPictClick(Sender: TObject);
    procedure btDelPictClick(Sender: TObject);
    procedure ImageViewClick(Sender: TObject);
    procedure cbUpdateOnTagsChangingClick(Sender: TObject);
  private
    NotLoaded: boolean;
  public
    M: TVisDynamicPict;
    D: TVisDynamicPictEditor;
  end;

var
  VisDynamicPictSetupForm: TVisDynamicPictSetupForm;

implementation
uses ExtDlgs, inifiles, VisDynamicPictDlg;

{$R *.DFM}

procedure TVisDynamicPictSetupForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  DeviceNameEdit.Text := M.DeviceName;
  TagPathEdit.Text := M.TagPath;
  TagNameEdit.Text := M.TagName;
  memo.Text := M.MainExpr;
  cbUpdateOnTagsChanging.Checked := M.UpdateOnTagsChanging;

  for i:=0 to M.TagCount-1 do with listTag.Items.Add do begin
    Caption := inttostr(M.Tags[i].id);
    Subitems.Add(M.Tags[i].Name);
    Data := M.Tags[i];
  end;

  for i:=0 to M.PictCount-1 do with listPict.Items.Add do begin
    Caption := M.Picts[i].FileName;
    Subitems.Add(M.Picts[i].Cndt);
    Data := M.Picts[i];
  end;

  NotLoaded := false;
end;


procedure TVisDynamicPictSetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisDynamicPict', 'Left', 6);
    Top := ReadInteger('VisDynamicPict', 'Top', 4);
    Free;
  end;
end;

procedure TVisDynamicPictSetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisDynamicPict', 'Left', Left);
    WriteInteger('VisDynamicPict', 'Top', Top);
    Free;
  end;
end;



procedure TVisDynamicPictSetupForm.DeviceNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.DeviceName := DeviceNameEdit.Text;
  if D<>nil then D.Designer.Modified;
end;

procedure TVisDynamicPictSetupForm.TagPathEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagPath := TagPathEdit.Text;
  if D<>nil then D.Designer.Modified;
end;

procedure TVisDynamicPictSetupForm.TagNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagName := TagNameEdit.Text;
  if D<>nil then D.Designer.Modified;
end;

procedure TVisDynamicPictSetupForm.memoChange(Sender: TObject);
var
  i: integer;
  s: string;
begin
  s:='';
  for i:=0 to memo.lines.Count-1 do
    s := s + memo.lines[i] + ' ';
  s := trim(s);
  M.MainExpr := s;  
end;


procedure TVisDynamicPictSetupForm.listPictChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
var
  s: string;
begin
  if Change<>ctState then exit;
  if not Item.Selected then exit;

  s := VisImagesPath + item.Caption;
  if FileExists(s) then
    ImageView.Picture.LoadFromFile(s)
  else
    ImageView.Picture.Assign(nil);

end;


//  
procedure TVisDynamicPictSetupForm.btAddTagClick(Sender: TObject);
var
  W: TVisDynamicPictDlgForm;
  NewFlag: boolean;
  P: PVisDynPictTagRec;
  i: integer;
begin
  NewFlag := Sender = btAddTag;
  if (not NewFlag) then begin
    if (listTag.Selected=nil) then exit;
    P := listTag.Selected.Data;
  end;

  W := TVisDynamicPictDlgForm.Create(self);
  try
  if NewFlag then
    W.Caption := ''
  else
    W.Caption := '';
  W.Caption := W.Caption + ' ';
  W.Edit1.Width := 30;
  W.Label1.Caption := 'Id';
  W.Label2.Caption := ' ';

  if NewFlag then begin
    W.Edit1.Text := '0';
    W.Edit2.Text := '^';
  end else begin
    W.Edit1.Text := inttostr(P.id);
    W.Edit2.Text := P.Name;
  end;

  if W.ShowModal = mrOk then begin
    if NewFlag then begin
      SetLength(M.Tags, M.TagCount+1);
      new(P);
      M.Tags[M.TagCount] := P;
      inc(M.TagCount);
      listTag.Selected := listTag.items.Add;
      listTag.Selected.SubItems.Add('');
      listTag.Selected.Selected := true;
    end;

    val(W.Edit1.Text, P.id, i);
    P.Name := W.Edit2.Text;

    listTag.Selected.Caption := inttostr(P.id);
    listTag.Selected.SubItems[0] := W.Edit2.Text;
    listTag.Selected.Data := P;
  end;

  finally
  W.Free;
  end;
end;

//  
procedure TVisDynamicPictSetupForm.btDelTagClick(Sender: TObject);
var
  P: PVisDynPictTagRec;
  i,j: integer;
begin
  if (listTag.Selected=nil) then exit;
  P := listTag.Selected.Data;

  for i:=0 to M.TagCount-1 do
    if M.Tags[i] = P then begin
      Dispose(P);
      for j:=i to M.TagCount-2 do M.Tags[j] := M.Tags[j+1];
      dec(M.TagCount);
      j := listTag.Selected.Index;
      listTag.Items.Delete(j);
      if j = listTag.Items.Count then dec(j);
      if j>=0 then listTag.Selected := listTag.Items[j];
      break;
    end;
end;

//  /  
procedure TVisDynamicPictSetupForm.btAddPictClick(Sender: TObject);
var
  W: TVisDynamicPictDlgForm;
  NewFlag: boolean;
  P: PVisDynamicPictRec;
begin
  NewFlag := Sender = btAddPict;
  if (not NewFlag) then begin
    if (listPict.Selected=nil) then exit;
    P := listPict.Selected.Data;
  end;

  W := TVisDynamicPictDlgForm.Create(self);
  try
  if NewFlag then
    W.Caption := ''
  else
    W.Caption := '';
  W.Caption := W.Caption + ' ';
  W.Edit1.Width := W.Edit2.Width;
  W.Label1.Caption := ' ';
  W.Label2.Caption := '';

  if NewFlag then begin
    W.Edit1.Text := '';
    W.Edit2.Text := '';
  end else begin
    W.Edit1.Text := P.FileName;
    W.Edit2.Text := P.Cndt;
  end;

  if W.ShowModal = mrOk then begin
    if NewFlag then begin
      SetLength(M.Picts, M.PictCount+1);
      new(P);
      M.Picts[M.PictCount] := P;
      inc(M.PictCount);
      listPict.Selected := listPict.items.Add;
      listPict.Selected.SubItems.Add('');
      listPict.Selected.Selected := true;
    end;

    P.FileName := W.Edit1.Text;
    P.Cndt := W.Edit2.Text;

    listPict.Selected.Caption := P.FileName;
    listPict.Selected.SubItems[0] := P.Cndt;
    listPict.Selected.Data := P;

    listPictChange(listPict, listPict.Selected, ctState);

    if M.PictCount>0 then begin
      if FileExists(VisImagesPath+M.Picts[0].FileName) then
        M.ImageObj.Picture.LoadFromFile(VisImagesPath+M.Picts[0].FileName);
    end else begin
      M.ImageObj.Picture.Assign(nil);
    end;
    if D<>nil then D.Designer.Modified;

  end;

  finally
  W.Free;
  end;
end;

//  
procedure TVisDynamicPictSetupForm.btDelPictClick(Sender: TObject);
var
  P: PVisDynamicPictRec;
  i,j: integer;
begin
  if (listPict.Selected=nil) then exit;
  P := listPict.Selected.Data;

  for i:=0 to M.PictCount-1 do
    if M.Picts[i] = P then begin
      Dispose(P);
      for j:=i to M.PictCount-2 do M.Picts[j] := M.Picts[j+1];
      dec(M.PictCount);
      j := listPict.Selected.Index;
      listPict.Items.Delete(j);
      if j = listPict.Items.Count then dec(j);
      if j>=0 then listPict.Selected := listPict.Items[j];
      break;
    end;
end;

//   
procedure TVisDynamicPictSetupForm.ImageViewClick(Sender: TObject);
var
  s: string;
  Dlg: TOpenPictureDialog;
  P: PVisDynamicPictRec;
begin
  if listPict.Selected=nil then exit;
  P := listPict.Selected.Data;

  Dlg := TOpenPictureDialog.Create(nil);
  try
  Dlg.InitialDir := VisImagesPath + P.FileName;
  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    P.FileName := ExtractFileName( Dlg.FileName );
    listPict.Selected.Caption := P.FileName;

    s := VisImagesPath + P.FileName;
    if FileExists(s) then
      ImageView.Picture.LoadFromFile(s)
    else
      ImageView.Picture.Assign(nil);

    if M.PictCount>0 then begin
      if FileExists(VisImagesPath+M.Picts[0].FileName) then
        M.ImageObj.Picture.LoadFromFile(VisImagesPath+M.Picts[0].FileName);
    end else begin
      M.ImageObj.Picture.Assign(nil);
    end;
    if D<>nil then D.Designer.Modified;

  end;
  finally
  Dlg.Free;
  end;
end;

procedure TVisDynamicPictSetupForm.cbUpdateOnTagsChangingClick(
  Sender: TObject);
begin
  if NotLoaded then exit;
  M.UpdateOnTagsChanging := cbUpdateOnTagsChanging.Checked;
  if D<>nil then D.Designer.Modified;
end;

end.
