unit VisDynamicText;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase;


type

  TVisDynamicText = class(TCustomScadaObject)
  private
    FTagName: TTagName;
    FTagNames: TStringList;
    FTagIndex: integer;
    FTagIndexes: array of integer;

    FLabel: TLabel;
    FOnProcess: TNotifyEvent;

    procedure SetTagNames(Value: TStringList);
  public
    TagValue: integer;
    TagValues: array of integer;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Init; override;
    procedure Process; override;
    function GetValue(i: integer): integer;
    procedure SetCaption(s: string);

  published
    property TagName: TTagName read FTagName write FTagName;
    property TagNames: TStringList read FTagNames write SetTagNames;
    property OnProcess: TNotifyEvent read FOnProcess write FOnProcess;
    property Font;
  end;


procedure Register;

implementation
uses
  TagStorage,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisDynamicText]);
end;

constructor TVisDynamicText.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 100;
  Height := 100;

  FTagNames := TStringList.Create;

  //  
  Font.Color := clWhite;
  Font.Size := 10;
  Font.Style := [fsBold];
  Font.Name := 'Tahoma';

  FLabel := TLabel.Create(Self);
  FLabel.Parent := self;
  FLabel.Visible := true;
  FLabel.Transparent := true;
  FLabel.Left := BlokMarginX;
  FLabel.Top := BlokMarginY;
  FLabel.Caption := 'DynText';

  FLabel.OnClick := OnDeviceClick;

  FTagIndex := -1;
  FTagIndexes := nil;
  TagValue := -1;
  TagValues := nil;
end;



// INIT
procedure TVisDynamicText.Init;
var
  i: integer;
begin
  inherited;

  IsConnectionBad := false;

  if not(FTagName='') then begin
    FTagIndex := GetTagIndex(TagPath + '.' + FTagName);
    TagValue := 0;
    IsConnectionBad := (IsConnectionBad) or (FTagIndex < 0);
  end;

  SetLength(FTagIndexes, FTagNames.Count);
  SetLength(TagValues, FTagNames.Count);
  for i:=0 to FTagNames.Count-1 do begin
    FTagIndexes[i] := GetTagIndex(TagPath + '.' + FTagNames.Strings[i]);
    TagValues[i] := 0;
    IsConnectionBad := (IsConnectionBad) or (FTagIndexes[i] < 0);
  end;
end;

// PROCESS HANDLER
procedure TVisDynamicText.Process;
var
  i: integer;
  f: boolean;
begin
  IsValueBad := false;

  if not(FTagName='') then begin
    TagValue := GetTagValue(FTagIndex);
    IsValueBad := IsValueBad or (TagValue < 0);
  end;

  for i:=0 to length(FTagIndexes)-1 do begin
    TagValues[i] := GetTagValue(FTagIndexes[i]);
    IsValueBad := IsValueBad or (TagValues[i] < 0);
  end;


  if Assigned(FOnProcess) then
    FOnProcess(self)
  else
    FLabel.Caption := IntToStr(TagValue);

  f := not((IsConnectionBad) or (IsValueBad));
  if Visible <> f then Visible := f;

end;



destructor TVisDynamicText.Destroy;
begin
  TagNames.Free;
  inherited;
end;

procedure TVisDynamicText.SetTagNames(Value: TStringList);
begin
  FTagNames.Assign(Value);
end;


function TVisDynamicText.GetValue(i: integer): integer;
begin
  if (i>=0) and (i<length(TagValues)) then
    result := TagValues[i]
  else
    result := 0;
end;

procedure TVisDynamicText.SetCaption(s: string);
begin
  if not( FLabel.Caption = s ) then FLabel.Caption := s;
end;




end.
