// DEPRECATED !!!   .  !

unit VisGroupName;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase;


type

  TVisGroupName = class(TCustomScadaObject)
  private
    FTagNames: TStringList;
    FTagIndexes: array of integer;
    FGroupName: TDeviceName;

    FLabel: TLabel;
    FLabelText: TDeviceName;

    FFrameBlok: TShape;

    procedure SetLabelText(Value: TDeviceName);
    procedure SetTagNames(Value: TStringList);

  protected
    procedure SetFrameBlok(Value: integer);

  public
    FrameBlok: integer;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Init; override;
    procedure Process; override;

  published
    property TagNames: TStringList read FTagNames write SetTagNames;
    property GroupName: TDeviceName read FGroupName write FGroupName;
    property LabelText: TDeviceName read FLabelText write SetLabelText;

  end;


procedure Register;

implementation
uses
  TagStorage,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisGroupName]);
end;

{ TVisualDevice }

constructor TVisGroupName.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEraseBackground := true;
  Width := 100;
  Height := 100;

  FTagNames := TStringList.Create;

  //   Blok
  FFrameBlok := TShape.Create(self);
  FFrameBlok.Parent := self;
  FFrameBlok.Visible := true;
  FFrameBlok.Brush.Style := bsClear;
  FFrameBlok.Pen.Color := clYellow;
  FFrameBlok.Align := alClient;

  //  
  FLabel := TLabel.Create(Self);
  FLabel.Parent := self;
  FLabel.Visible := true;
  FLabel.Transparent := true;
  FLabel.Left := BlokMarginX;
  FLabel.Top := BlokMarginY;
  FLabel.Font.Color := clWhite;
  FLabel.Font.Size := 10;
  FLabel.Font.Style := [fsBold];
  FLabel.Font.Name := 'Tahoma';
  SetLabelText('');

  FLabel.OnClick := OnDeviceClick;

  FrameBlok := -1;
  FTagIndexes := nil;
end;


procedure TVisGroupName.SetLabelText(Value: TDeviceName);
begin
  FLabelText := value;
  FLabel.Caption := value;
  Width := FLabel.Width + 2*BlokMarginX;
  Height := FLabel.Height + 2*BlokMarginY;
end;


procedure TVisGroupName.SetFrameBlok(Value: integer);
begin
  if Value <> FrameBlok then begin
    if (value) > 0 then
      FFrameBlok.Pen.Color := clYellow
    else
      FFrameBlok.Pen.Color := Color;
    FrameBlok := Value;
  end;
end;



// INIT
procedure TVisGroupName.Init;
var
  i: integer;
begin
  inherited;

  IsConnectionBad := false;
  SetLength(FTagIndexes, FTagNames.Count);
  for i:=0 to FTagNames.Count-1 do begin
    FTagIndexes[i] := GetTagIndex(TagPath + '.' + FTagNames.Strings[i] );
    IsConnectionBad := (IsConnectionBad) or (FTagIndexes[i] < 0);
  end;
end;

// PROCESS HANDLER
procedure TVisGroupName.Process;
var
  value, summa: integer;
  i: integer;
begin
  inherited;

  summa := 0;
  IsValueBad := false;
  for i:=0 to length(FTagIndexes)-1 do begin
    value := GetTagValue(FTagIndexes[i]);
    summa := summa + value;
    IsValueBad := IsValueBad or (value < 0);
  end;
  SetFrameBlok(summa);
end;



destructor TVisGroupName.Destroy;
begin
  TagNames.Free;
  inherited;
end;

procedure TVisGroupName.SetTagNames(Value: TStringList);
begin
  FTagNames.Assign(Value);
end;


end.
