unit VisInverterA;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, VisMachine, VisMcha;

type

  TVisInverterA = class(TVisMcha)
  private
    blinkflag: boolean;
    FUseScadaObjectClick: boolean;
    procedure ScadaObjectClick(Sender: TObject);
  protected
    FTagFreqReq: integer;
    FTagFreqOut: integer;
    FTagError: integer;
    FTagSYSTEMErrorFlag: integer;
    procedure OnDeviceMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Init; override;
    procedure Process; override;
  published
    property OnScadaObjectClick;
    property UseScadaObjectClick: boolean read FUseScadaObjectClick write FUseScadaObjectClick;
  end;


procedure Register;

implementation
uses
  main,
  VisInverterAControlPanel,
  TagStorage,
  numbers,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisInverterA]);
end;

{ TVisInverterA }

constructor TVisInverterA.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTagFreqReq := -1;
  FTagFreqOut := -1;
  FTagError := -1;
  FTagSYSTEMErrorFlag := -1;

  ImageObj.OnClick := ScadaObjectClick;
  LabelObj.OnClick := ScadaObjectClick;

  UseScadaObjectClick := true;

end;


procedure TVisInverterA.OnDeviceMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ScadaObjectClick(sender);
end;



// INIT
procedure TVisInverterA.Init;
begin
  inherited;

  FTagFreqReq := GetTagIndex(TagPath + '.FreqReq');
  FTagFreqOut := GetTagIndex(TagPath + '.FreqOut');   // VESP1.FreqOut
  FTagError :=   GetTagIndex(TagPath + '.Error');
  FTagSYSTEMErrorFlag := GetTagIndex(TagPath + '.SYSTEM.ErrorFlag');

  IsConnectionBad := (FTagFreqReq<0) or (FTagFreqOut<0) or (FTagError<0) or (FTagSYSTEMErrorFlag<0);
end;

// PROCESS HANDLER
procedure TVisInverterA.Process;
var
  value, freqout, freqreq, error, errflag: integer;
begin

  IsValueBad := false;

  freqreq := GetTagValue(FTagFreqReq);
  freqout := GetTagValue(FTagFreqOut);
  error := GetTagValue(FTagError);
  errflag := GetTagValue(FTagSYSTEMErrorFlag);


  IsValueBad := IsValueBad or (freqreq < 0) or (freqout < 0) or (error < 0) or (errflag < 0);



  if (errflag > 0) then
    value := 3
  else

  if (error > 0) then
    value := 4
  else

  if (freqout > 0) and (freqout <> freqreq) then begin
    value := 1;
    if blinkflag then
      left := left + 1
    else
      left := left - 1;

    blinkflag := not blinkflag;
  end else

  if (freqout > 0) and (freqout = freqreq) then
    value := 1
  else
    value := 0;

  SetImageSost(value);


  
  if (IsConnectionBad) or (IsValueBad) then
    Visible := not Visible
  else
    Visible := true;

end;



procedure TVisInverterA.ScadaObjectClick(Sender: TObject);
begin

  if UseScadaObjectClick then begin

    if VisInverterAControlPanelForm=nil then
      VisInverterAControlPanelForm := TVisInverterAControlPanelForm.Create(Form1);

    VisInverterAControlPanelForm.M := self;

    if Assigned(OnScadaObjectClick) then
      OnScadaObjectClick(self, self, TForm(VisInverterAControlPanelForm) );

  end else begin
    if Assigned(OnClick) then
      OnClick(self);
  end;

end;




end.
