unit VisInverterAControlPanel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisInverterA, ExtCtrls, ScadaBase, VisMachine, VisMcha, VisCheckBox,
  StdCtrls, VisButton, VisLabel, Buttons, VisDataboard, VisNumericPanel,
  VisControl;


type
  TVisInverterAControlPanelForm = class(TForm)
    ScadaUpdateTimer: TTimer;
    pnlControl: TPanel;
    btReverse: TVisButton;
    Bevel1: TBevel;
    pnlDeviceName: TPanel;
    pnlSost: TPanel;
    pnlBlok: TPanel;
    Bevel2: TBevel;
    VisLabel1: TVisLabel;
    Bevel5: TBevel;
    pnlParams: TPanel;
    Label1: TLabel;
    btStart: TBitBtn;
    btStop: TBitBtn;
    btExtErr: TBitBtn;
    btReset: TBitBtn;
    VisLabel6: TVisLabel;
    VisLabel2: TVisLabel;
    VisLabel3: TVisLabel;
    VisLabel4: TVisLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    VisNumericPanel1: TVisNumericPanel;
    VisNumericPanel2: TVisNumericPanel;
    VisNumericPanel3: TVisNumericPanel;
    VisNumericPanel4: TVisNumericPanel;
    Label4: TLabel;
    VisNumericPanel5: TVisNumericPanel;
    memo: TMemo;
    procedure ScadaUpdateTimerTimer(Sender: TObject);

    procedure FormActivate(Sender: TObject);
    procedure VisButtonDownChange(Sender: TObject);
    procedure VisButtonClick(Sender: TObject);
    procedure pnlDeviceNameClick(Sender: TObject);
    procedure VisButton4CanClick(Sender: TObject; var Can: Boolean);
    procedure btReverseCanClick(Sender: TObject; var Can: Boolean);
    procedure VisButton2CanClick(Sender: TObject; var Can: Boolean);
    procedure VisButton5CanClick(Sender: TObject; var Can: Boolean);
    procedure VisButton3CanClick(Sender: TObject; var Can: Boolean);
    procedure btStartClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure btExtErrClick(Sender: TObject);
    procedure btResetClick(Sender: TObject);
    procedure VisLabel1Click(Sender: TObject);
  private
    idxErrorflag: Integer;
    idxError: Integer;
    idxErrCode: Integer;
    procedure updateStatusMemo;
  public
    M: TVisInverterA;
    tagname: string;
  end;

var
  VisInverterAControlPanelForm: TVisInverterAControlPanelForm;

implementation
uses
  infodlg,
  InputDialog,
  users,
  MesConst,
  TrendWindow,
  meslogging,
  SetChannel,
  TagStorage,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;

{$R *.dfm}

// 
procedure TVisInverterAControlPanelForm.ScadaUpdateTimerTimer(Sender: TObject);
begin
  CustomScanScadaObjects(self, UpdateDeviceProc);
  updateStatusMemo;
end;

procedure TVisInverterAControlPanelForm.updateStatusMemo;
var
  s: string;
  i: Integer;
begin
  s := '';
  if GetTagValue( idxErrorflag ) > 0 then
    s := s + ' '#13#10#13#10;

  if GetTagValue( idxError ) > 0 then begin
    i := GetTagValue(idxErrCode);
    case i of
      01: s:=s + ' (CPF)'#13#10#13#10;
      02: s:=s + '  (EPR)'#13#10#13#10;
      03: s:=s + ' (0V)'#13#10#13#10;
      04: s:=s + '  (LV)'#13#10#13#10;
      05: s:=s + ' (O)'#13#10#13#10;
      10: s:=s + '     (OC-D)'#13#10#13#10;
      11: s:=s + '     (OC-A)'#13#10#13#10;
      12: s:=s + '     (OC-C)'#13#10#13#10;
      13: s:=s + '   (OV-C)'#13#10#13#10;
      14: s:=s + '   (O-C)'#13#10#13#10; 
      15: s:=s + '  (OV3F)'#13#10#13#10;
      16: s:=s + '  (CTER)'#13#10#13#10; 
      17: s:=s + '     (OCS)'#13#10#13#10; 
      20: s:=s + '     ()'#13#10#13#10;
      21: s:=s + '  (OL1)'#13#10#13#10; 
      22: s:=s + '  (OL2)'#13#10#13#10;
      23: s:=s + '   (OL3)'#13#10#13#10; 
      24: s:=s + '    (LV-C)'#13#10#13#10;
      29: s:=s + '    (Err8)'#13#10#13#10;
      30: s:=s + '    (STPO)'#13#10#13#10;
      31: s:=s + '  (STP 1)'#13#10#13#10;
      32: s:=s + '     (STP2)'#13#10#13#10;
      33: s:=s + '     (E.S.)'#13#10#13#10;
      34: s:=s + '  (b.b.)'#13#10#13#10;
      35: s:=s + '  (AT ER)'#13#10#13#10;
      36: s:=s + '   (PDER)'#13#10#13#10;
      37: s:=s + '  (EFO)'#13#10#13#10;
      38: s:=s + '   (ECER)'#13#10#13#10;
      39: s:=s + '   (Err4)'#13#10#13#10;
      40: s:=s + '   (LOC)'#13#10#13#10;
      41: s:=s + '   (Err1)'#13#10#13#10;
      42: s:=s + '   (Err2)'#13#10#13#10;
      43: s:=s + '   (Err5)'#13#10#13#10;
      44: s:=s + '  (Err6)'#13#10#13#10;
      45: s:=s + '   (Err7)'#13#10#13#10;
    end;
  end;


  if memo.Text <> s then
    memo.Text := s;


end;


// 
procedure TVisInverterAControlPanelForm.FormActivate(Sender: TObject);
begin
  if M=nil then exit;

  SetPathRootScadaObjects(self, M.TagPath, M.TagRoot );
  pnlDeviceName.Caption := M.DeviceName;

  pnlSost.Visible := true;
  pnlControl.Visible := not M.HideControl;
  pnlBlok.Visible := true;


  idxErrorflag := GetTagIndex(M.TagPath + '.SYSTEM.ErrorFlag');
  idxError := GetTagIndex(M.TagPath + '.Error');
  idxErrCode := GetTagIndex(M.TagPath + '.ErrCode');


  //     
  tagname := M.TagPath + '.' + M.TypeName1 + '_' + repl(M.TagName, M.TagIdRoot, M.TagRoot) + '_';



end;

//     
procedure TVisInverterAControlPanelForm.VisButtonDownChange(Sender: TObject);
begin
  with Sender as TVisButton do
    if objButton.Down then
      objButton.Font.Style := [fsBold]
    else
      objButton.Font.Style := [];
end;

// 
procedure TVisInverterAControlPanelForm.VisButtonClick(Sender: TObject);
begin
  with sender as TVisButton do
    SaveMessageText(mcMode_text, M.DeviceName, Hint, mcMode_bc, mcMode_fc);
end;

procedure TVisInverterAControlPanelForm.pnlDeviceNameClick(Sender: TObject);
begin
  if m.OnlyDat then exit;

  ShowTrendWindow(
    M.DeviceName,
    tagname + 'Sost;' + tagname + 'Plata',
    ';',
    'mchb_',
    '',
    ': '#13+
    '  0 - '#13+
    '  1 - '#13+
    '  2 - '#13+
    '  3 - '#13+
    '  4 - '#13+
    '  5 - '#13+
    '  7 - ,  =1'#13+
    '  8 -  '
  );
end;

procedure TVisInverterAControlPanelForm.VisButton4CanClick(Sender: TObject;
  var Can: Boolean);
begin
end;

procedure TVisInverterAControlPanelForm.btReverseCanClick(Sender: TObject;
  var Can: Boolean);
begin
end;

procedure TVisInverterAControlPanelForm.VisButton2CanClick(Sender: TObject;
  var Can: Boolean);
begin
end;

procedure TVisInverterAControlPanelForm.VisButton5CanClick(Sender: TObject;
  var Can: Boolean);
begin
  Can := CheckAccess(PREVILEG_BLOK, true);
end;

procedure TVisInverterAControlPanelForm.VisButton3CanClick(Sender: TObject;
  var Can: Boolean);
begin
  Can := CheckAccess(PREVILEG_MCHMODE, true);
end;

procedure TVisInverterAControlPanelForm.btStartClick(Sender: TObject);
begin
  SetTagValueByName( M.TagPath + '.SetRun', 1);
  SaveMessageText('  ', M.DeviceName, '', clLime, clBlack);
end;

procedure TVisInverterAControlPanelForm.btStopClick(Sender: TObject);
begin
  SetTagValueByName( M.TagPath + '.SetRun', 0);
  SaveMessageText('  ', M.DeviceName, '', clLime, clBlack);
end;

procedure TVisInverterAControlPanelForm.btExtErrClick(Sender: TObject);
begin
  if showInfoDlg('  " "?', mtConfirmation, mbOKCancel, 0) <> mrOk then Exit;
  SetTagValueByName( M.TagPath + '.SetExtErr', 1);
  SaveMessageText('  ', M.DeviceName, ' ', clLime, clBlack);
end;

procedure TVisInverterAControlPanelForm.btResetClick(Sender: TObject);
begin
  SetTagValueByName( M.TagPath + '.SetReset', 1);
  SaveMessageText('  ', M.DeviceName, ' ', clLime, clBlack);
end;

procedure TVisInverterAControlPanelForm.VisLabel1Click(Sender: TObject);
var
  s: string;
  r: real;
  v,i: Integer;
begin
  v := GetTagValueByName(M.TagPath + '.FreqReq');
  str(v/100:1:2, s);
  if not ShowInputDialog(' ', ', ', s) then
    exit;

  Val(s, r, i);
  v := round(r * 100);
  str(v/100:1:2, s);


  SetTagValueByName( M.TagPath + '.SetFreq', v);
  SaveMessageText('  ', M.DeviceName, 'F=' + s, clLime, clBlack);
end;

end.
