unit VisMachineSetup;

interface

uses
  Math,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VisMachine, Mask, ExtCtrls, Buttons, ComCtrls, RpVisualGlobal,
  Menus;

type
  TVisMachineSetupForm = class(TForm)
    pnl1: TPanel;
    DeviceNameEdit: TMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    LabelEdit: TMaskEdit;
    Label3: TLabel;
    TagNameEdit: TMaskEdit;
    TagPathEdit: TMaskEdit;
    Label4: TLabel;
    pnl4: TPanel;
    PicNameEdit: TMaskEdit;
    Label6: TLabel;
    ImageXEdit: TEdit;
    ImageYEdit: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    udImageY: TUpDown;
    udImageX: TUpDown;
    Label9: TLabel;
    ImageSXEdit: TEdit;
    ImageSYEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    udImageSY: TUpDown;
    udImageSX: TUpDown;
    pnl2: TPanel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    MachXEdit: TEdit;
    MachYEdit: TEdit;
    udMachY: TUpDown;
    udMachX: TUpDown;
    MachSXEdit: TEdit;
    MachSYEdit: TEdit;
    udMachSY: TUpDown;
    udMachSX: TUpDown;
    Label12: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    pnl3: TPanel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label27: TLabel;
    LabelXEdit: TEdit;
    LabelYEdit: TEdit;
    udLabelY: TUpDown;
    udLabelX: TUpDown;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    ImagePanel: TPanel;
    ImageView: TImage;
    Timer: TTimer;
    cbImageAnim: TCheckBox;
    btImageReset: TSpeedButton;
    pnl5: TPanel;
    Label5: TLabel;
    DatTagPostfixEdit: TMaskEdit;
    DatNameEdit: TMaskEdit;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    DatXEdit: TEdit;
    DatYEdit: TEdit;
    udDatY: TUpDown;
    udDatX: TUpDown;
    DatSXEdit: TEdit;
    DatSYEdit: TEdit;
    udDatSY: TUpDown;
    udDatSX: TUpDown;
    DatList: TListBox;
    btDatDel: TSpeedButton;
    cmbDatForm: TComboBox;
    Label33: TLabel;
    Label34: TLabel;
    cmbDatColor: TComboBox;
    cbOnlyDat: TCheckBox;
    Label35: TLabel;
    edTagIdRoot: TMaskEdit;
    Label36: TLabel;
    edTagRoot: TMaskEdit;
    edNumber: TMaskEdit;
    Label37: TLabel;
    btnItemUp: TButton;
    btnItemDwn: TButton;
    btExtra: TBitBtn;
    popupExtra: TPopupMenu;
    fixLegacyTagrootAndTagname: TMenuItem;
    btLabelLeft: TSpeedButton;
    btLabelRight: TSpeedButton;
    btLabelUp: TSpeedButton;
    btLabelDown: TSpeedButton;
    btAdjustSize: TSpeedButton;
    btAddSensorRks: TSpeedButton;
    btAddSensorPdp: TSpeedButton;
    btAddSensorTok: TSpeedButton;
    btAddSensorLnt: TSpeedButton;
    btAddSensorCep: TSpeedButton;
    btAddSensorEmpty: TSpeedButton;
    btAddSensorP: TSpeedButton;
    btAddSensorT: TSpeedButton;
    btAddSensorRun: TSpeedButton;
    btAddSensorAlm: TSpeedButton;
    btAddSensorDu: TSpeedButton;
    btAddSensorDsu: TSpeedButton;
    btAddSensorDvu: TSpeedButton;
    btAddSensorDnu: TSpeedButton;
    btCopySensor: TSpeedButton;
    mnRepaint: TMenuItem;
    procedure DeviceNameEditChange(Sender: TObject);
    procedure LabelEditChange(Sender: TObject);
    procedure TagPathEditChange(Sender: TObject);
    procedure TagNameEditChange(Sender: TObject);
    procedure MachYEditChange(Sender: TObject);
    procedure MachSXEditChange(Sender: TObject);
    procedure MachSYEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LabelXEditChange(Sender: TObject);
    procedure LabelYEditChange(Sender: TObject);
    procedure ImageXEditChange(Sender: TObject);
    procedure ImageYEditChange(Sender: TObject);
    procedure ImageSXEditChange(Sender: TObject);
    procedure ImageSYEditChange(Sender: TObject);
    procedure btOpenPicClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure btImageResetClick(Sender: TObject);
    procedure MachXEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DatListClick(Sender: TObject);
    procedure DatNameEditChange(Sender: TObject);
    procedure DatTagPostfixEditChange(Sender: TObject);
    procedure cmbDatColorChange(Sender: TObject);
    procedure cmbDatFormChange(Sender: TObject);
    procedure DatXEditChange(Sender: TObject);
    procedure DatYEditChange(Sender: TObject);
    procedure DatSXEditChange(Sender: TObject);
    procedure DatSYEditChange(Sender: TObject);
    procedure btDatAddClick(Sender: TObject);
    procedure btDatDelClick(Sender: TObject);
    procedure cbOnlyDatClick(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
    procedure edNumberChange(Sender: TObject);
    procedure btnItemUpClick(Sender: TObject);
    procedure btnItemDwnClick(Sender: TObject);
    procedure btnUpdateBackgroundAllClick(Sender: TObject);
    procedure fixLegacyTagrootAndTagnameClick(Sender: TObject);
    procedure btLabelUpClick(Sender: TObject);
    procedure btLabelDownClick(Sender: TObject);
    procedure btLabelLeftClick(Sender: TObject);
    procedure btLabelRightClick(Sender: TObject);
    procedure btAdjustSizeClick(Sender: TObject);
    procedure btAddSensorRksClick(Sender: TObject);
    procedure btAddSensorPdpClick(Sender: TObject);
    procedure btAddSensorTokClick(Sender: TObject);
    procedure btAddSensorCepClick(Sender: TObject);
    procedure btAddSensorPClick(Sender: TObject);
    procedure btAddSensorTClick(Sender: TObject);
    procedure btAddSensorRunClick(Sender: TObject);
    procedure btAddSensorAlmClick(Sender: TObject);
    procedure btAddSensorDuClick(Sender: TObject);
    procedure btAddSensorDsuClick(Sender: TObject);
    procedure btAddSensorDvuClick(Sender: TObject);
    procedure btAddSensorDnuClick(Sender: TObject);
    procedure btAddSensorLntClick(Sender: TObject);
    procedure DatNameEditDblClick(Sender: TObject);
    procedure btAddSensorEmptyClick(Sender: TObject);
    procedure btCopySensorClick(Sender: TObject);
    procedure mnRepaintClick(Sender: TObject);
    procedure PicNameEditChange(Sender: TObject);
  private
    NotLoaded: boolean;
    ImageAnimNum: integer;
    procedure Modify;
    procedure SetImageSize;
    procedure AddSensor(AName, ATagPostfix: string; AShapeType: TShapeType;
      AColorScheme, AWidth, AHeight: integer);
//    procedure RepaintFull(AControl: TWinControl);
  public
    M: TVisMachine;
    D: TVisMachineEditor;
  end;

var
  VisMachineSetupForm: TVisMachineSetupForm;

implementation
uses
  RpVisualUtils,
  VisMchb,
  ScadaBase,
  HyperStr,
  ExtDlgs,
  inifiles;

{$R *.DFM}




procedure TVisMachineSetupForm.FormActivate(Sender: TObject);
var
  s: string;
  i: integer;
begin
  Caption := ' ' + M.ClassName;

  edTagRoot.Text := M.TagRoot;
  edTagIdRoot.Text := M.TagIdRoot;

  
  DeviceNameEdit.Text := M.DeviceName;
  TagPathEdit.Text := M.TagPath;
  TagNameEdit.Text := M.TagName;
  LabelEdit.Text := M.LabelObj.Caption;
  edNumber.Text := RestoreNumberText(edTagRoot.Text, LabelEdit.Text);
  edNumber.OnChange := edNumberChange;

  udMachX.Position := M.Left;
  udMachY.Position := M.Top;
  udMachSX.Position := M.Width;
  udMachSY.Position := M.Height;

  udLabelX.Position := M.LabelObj.Left;
  udLabelY.Position := M.LabelObj.Top;

  PicNameEdit.Text := M.ImagePic;
  PicNameEdit.Hint := PicNameEdit.Text;
  udImageX.Position := M.ImageObj.Left;
  udImageY.Position := M.ImageObj.Top;
  udImageSX.Position := M.ImageObj.Width;
  udImageSY.Position := M.ImageObj.Height;

  cbOnlyDat.Checked := M.OnlyDat;

  s := VisImagesPath + M.ImagePic;
  try
    if FileExists(s) then ImageView.Picture.LoadFromFile(s);
    SetImageSize;
    ImagePanel.Color := clBtnFace;
  except
    ImagePanel.Color := clRed;
  end;

  //  
  for i:=0 to M.DatCount-1 do begin
    DatList.Items.Add(M.Datchik[i].Name);
  end;
  if M.DatCount>0 then DatList.ItemIndex := 0;
  DatListClick(nil);

  NotLoaded := false;

  edNumber.SetFocus;
  edNumber.SelectAll;
end;


procedure TVisMachineSetupForm.DatListClick(Sender: TObject);
var
  p: PVisMachineDat;
begin
  if DatList.ItemIndex < 0 then begin
    DatList.Clear;
    DatNameEdit.Text := '';
    DatTagPostfixEdit.Text := '';
    cmbDatForm.ItemIndex := 0;
    cmbDatColor.ItemIndex := 0;
    udDatX.Position := 0;
    udDatY.Position := 0;
    udDatSX.Position := 5;
    udDatSY.Position := 5;
  end else if DatList.ItemIndex < M.DatCount then begin
    p := M.Datchik[DatList.ItemIndex];
    DatNameEdit.Text := p.Name;
    DatTagPostfixEdit.Text := p.TagPostfix;
    cmbDatForm.ItemIndex := ord(p.Shape.Shape);
    cmbDatColor.ItemIndex := p.ColorScheme;

    udDatX.Position := p.Shape.Left;
    DatXEdit.Text := IntToStr(p.Shape.Left);

    udDatY.Position := p.Shape.Top;
    DatYEdit.Text := IntToStr(p.Shape.Top);

    udDatSX.Position := p.Shape.Width;
    DatSXEdit.Text := IntToStr(p.Shape.Width);

    udDatSY.Position := p.Shape.Height;
    DatSYEdit.Text := IntToStr(p.Shape.Height);
  end;
end;


procedure TVisMachineSetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisMachine', 'Left', 6);
    Top := ReadInteger('VisMachine', 'Top', 4);
    cbImageAnim.Checked := ReadBool('VisMachine', 'ImageAnim', false);
    Free;
  end;
end;

procedure TVisMachineSetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisMachine', 'Left', Left);
    WriteInteger('VisMachine', 'Top', Top);
    WriteBool('VisMachine', 'ImageAnim', cbImageAnim.Checked);
    Free;
  end;
end;


procedure TVisMachineSetupForm.Modify;
begin
  M.RepaintRect;
end;

procedure TVisMachineSetupForm.DeviceNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.DeviceName := DeviceNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.LabelEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.LabelObj.Caption := LabelEdit.Text;
  M.FrameUpdate;
  Modify;
end;

procedure TVisMachineSetupForm.TagPathEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagPath := TagPathEdit.Text;
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.TagNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagName := TagNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.MachXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachXEdit.Text='') then exit;
  M.Left := CleanStrToIntDef(MachXEdit.Text, 0);
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.MachYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachYEdit.Text='') then exit;
  M.Top := CleanStrToIntDef(MachYEdit.Text, 0);
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.MachSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachSXEdit.Text='') then exit;
  M.Width := CleanStrToIntDef(MachSXEdit.Text, 10);
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.MachSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachSYEdit.Text='') then exit;
  M.Height := CleanStrToIntDef(MachSYEdit.Text, 10);
  D.Designer.Modified;
end;


procedure TVisMachineSetupForm.LabelXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Left := CleanStrToIntDef(LabelXEdit.Text, 0);
  M.FrameUpdate;
  Modify;
end;

procedure TVisMachineSetupForm.LabelYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Top := CleanStrToIntDef(LabelYEdit.Text, 0);
  M.FrameUpdate;
  Modify;
end;

procedure TVisMachineSetupForm.ImageXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageXEdit.Text='') then exit;
  M.ImageObj.Left := CleanStrToIntDef(ImageXEdit.Text, 0);
  Modify;
end;

procedure TVisMachineSetupForm.ImageYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageYEdit.Text='') then exit;
  M.ImageObj.Top := CleanStrToIntDef(ImageYEdit.Text, 0);
  Modify;
end;

procedure TVisMachineSetupForm.ImageSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSXEdit.Text='') then exit;
  M.ImageObj.Width := CleanStrToIntDef(ImageSXEdit.Text, 0);
  Modify;
end;

procedure TVisMachineSetupForm.ImageSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSYEdit.Text='') then exit;
  M.ImageObj.Height := CleanStrToIntDef(ImageSYEdit.Text, 0);
  Modify;
end;

procedure TVisMachineSetupForm.btOpenPicClick(Sender: TObject);
var
  Dlg: TOpenPictureDialog;
begin
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.Filter := '(*_1.*)|*_1.*|(*.*)|*.*';
  Dlg.InitialDir := ExtractFilePath(VisImagesPath + M.ImagePic);

  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    if Pos( UpperCase(VisImagesPath), UpperCase(Dlg.FileName) ) > 0 then begin
      PicNameEdit.Text := copy(Dlg.FileName, Length(VisImagesPath)+1, Length(Dlg.FileName) );
    end else
      PicNameEdit.Text := ExtractFileName( Dlg.FileName );
    PicNameEdit.Hint := PicNameEdit.Text;

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(Dlg.FileName);
    M.ImageObj.Picture.LoadFromFile(Dlg.FileName);
    ImagePanel.Color := clBtnFace;

    udImageSX.Position := M.ImageObj.Picture.Width;
    udImageSY.Position := M.ImageObj.Picture.Height;
    SetImageSize;

    Modify;
  end;
  Dlg.Free;
end;

procedure TVisMachineSetupForm.SetImageSize;
var
  x,y,sx,sy,ix,iy: integer;
begin
  ix := ImagePanel.Width-1;
  iy := ImagePanel.Height-1;
  sx := M.ImageObj.Picture.Width;
  sy := M.ImageObj.Picture.Height;

  if sx>ix then begin
    sy := sy*ix div sx;
    sx := ix;
  end;

  if sy>iy then begin
    sx := sx*iy div sy;
    sy := iy;
  end;

  x := (ix-sx) div 2;
  y := (iy-sy) div 2;

  ImageView.Left := x;
  ImageView.Top := y;
  ImageView.Width := sx;
  ImageView.Height := sy;

end;

procedure TVisMachineSetupForm.TimerTimer(Sender: TObject);
var
  s: string;
  k: integer;
begin
  for k:=0 to M.DatCount-1 do
    if k = DatList.ItemIndex then begin
      if M.Datchik[k].Shape.Brush.Color <> clLime then
        M.Datchik[k].Shape.Brush.Color := clLime
      else
        M.Datchik[k].Shape.Brush.Color := clAqua;
    end else begin
      if M.Datchik[k].Shape.Brush.Color <> clAqua then
        M.Datchik[k].Shape.Brush.Color := clAqua;
    end;

  if cbImageAnim.Checked then begin
    s := trim(M.ImagePic);
    if length(s) > 0 then begin
      inc(ImageAnimNum);
      if (ImageAnimNum > 4) or (ImageAnimNum < 1) then ImageAnimNum := 1;
      try
        k := pos('_',s);
        if k=0 then raise Exception.Create('');
        delete(s, k, 2);
        insert(format('_%d',[ImageAnimNum]), s, k);
        s := VisImagesPath + s;

        ImageView.Picture.LoadFromFile(s);
        ImagePanel.Color := clBtnFace;
      except
        ImagePanel.Color := clRed;
      end;
    end;
  end;
end;

procedure TVisMachineSetupForm.btImageResetClick(Sender: TObject);
begin
  udImageSX.Position := M.ImageObj.Picture.Width;
  udImageSY.Position := M.ImageObj.Picture.Height;
end;




procedure TVisMachineSetupForm.DatNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Name := DatNameEdit.Text;
    DatList.Items.Strings[DatList.ItemIndex] := DatNameEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.DatTagPostfixEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].TagPostfix := DatTagPostfixEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.cmbDatFormChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Shape :=
        TShapeType(cmbDatForm.ItemIndex);
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.cmbDatColorChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].ColorScheme := cmbDatColor.ItemIndex;
    D.Designer.Modified;
  end;
end;


procedure TVisMachineSetupForm.DatXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatXEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Left := CleanStrToIntDef(DatXEdit.Text, 0);
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.DatYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatYEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Top := CleanStrToIntDef(DatYEdit.Text, 0);
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.DatSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatSXEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Width := CleanStrToIntDef(DatSXEdit.Text, 0);
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.DatSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatSYEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Height := CleanStrToIntDef(DatSYEdit.Text, 0);
    D.Designer.Modified;
  end;
end;

procedure TVisMachineSetupForm.btDatAddClick(Sender: TObject);
begin
  AddSensor('', '---', stRectangle, 0, 8, 6);
end;

procedure TVisMachineSetupForm.AddSensor(AName, ATagPostfix: string; AShapeType: TShapeType; AColorScheme: integer; AWidth, AHeight: integer);
var
  k: integer;
begin
  k := M.DatCount;
  M.DatCount := M.DatCount + 1;
  SetLength(M.Datchik, M.DatCount);

  new(M.Datchik[k]);
  M.Datchik[k].Shape := TShape.Create(M);
  M.Datchik[k].Shape.Parent := M;
  M.Datchik[k].Shape.Visible := true;
  M.Datchik[k].Shape.Brush.Color := clAqua;
  M.Datchik[k].Shape.Left := (M.Width - AWidth) div 2;
  M.Datchik[k].Shape.Top := (M.Height - AHeight) div 2;
  M.Datchik[k].Shape.Width := AWidth;
  M.Datchik[k].Shape.Height := AHeight;
  M.Datchik[k].Shape.Shape := AShapeType;
  M.Datchik[k].ColorScheme := AColorScheme;
  M.Datchik[k].TagPostfix := ATagPostfix;
  M.Datchik[k].Name := AName;

  DatList.Items.Add(AName);
  DatList.ItemIndex := DatList.Items.Count-1;
  DatListClick(nil);
  D.Designer.Modified;
end;

procedure TVisMachineSetupForm.btDatDelClick(Sender: TObject);
var
  i,k: integer;
begin
  k := DatList.ItemIndex;
  if (k>=0) and (k<M.DatCount) then begin
    M.Datchik[k].Shape.Free;
    dispose(M.Datchik[k]);

    for i:=k to M.DatCount-2 do M.Datchik[i] := M.Datchik[i+1];
    M.DatCount := M.DatCount-1;
    SetLength(M.Datchik, M.DatCount);

    DatList.Items.Delete(k);
    if k = DatList.Items.Count then Dec(k);
    DatList.ItemIndex := k;
    DatListClick(nil);
    D.Designer.Modified;
  end;
  M.RepaintRect;
end;

procedure TVisMachineSetupForm.cbOnlyDatClick(Sender: TObject);
begin
  if NotLoaded then exit;
  M.OnlyDat := cbOnlyDat.Checked;
  D.Designer.Modified;
end;


procedure TVisMachineSetupForm.OkButtonClick(Sender: TObject);
begin
  M.TagRoot := edTagRoot.Text;
  M.TagIdRoot := edTagIdRoot.Text;
  D.Designer.Modified;
  Modify;
  ModalResult := mrOk;
end;

procedure TVisMachineSetupForm.edNumberChange(Sender: TObject);

  function _repl(src, s: string; no_leading_zeros: boolean = false): string;
  var
    k: integer;
  begin
    if no_leading_zeros then begin
      while pos('0', s)=1 do
        delete(s, 1, 1);
    end;

    k := pos(' ', src);
    if k>0 then
      src := s + copy(src, k, length(src)-k+1)
    else
      src := s;
    result := src;
  end;

var
  s: string;
begin
  s := Trim(edNumber.Text);
  ReplaceS(s, '.', '_');
  edTagRoot.Text := s;

  DeviceNameEdit.Text := _repl(DeviceNameEdit.Text, edNumber.Text, true);
  LabelEdit.Text := _repl(LabelEdit.Text, edNumber.Text, true);
end;

procedure TVisMachineSetupForm.btnItemUpClick(Sender: TObject);
var
  tmpDat: PVisMachineDat;
  i1, i2: Integer;
begin
  i1 := DatList.ItemIndex;
  i2 := DatList.ItemIndex - 1;

  if i2 < 0 then
    exit;

  DatList.Items.Exchange(i1, i2);
  tmpDat := M.Datchik[i1];
  M.Datchik[i1] := M.Datchik[i2];
  M.Datchik[i2] := tmpDat;
end;

procedure TVisMachineSetupForm.btnItemDwnClick(Sender: TObject);
var
  tmpDat: PVisMachineDat;
  i1, i2: Integer;
begin
  i1 := DatList.ItemIndex;
  i2 := DatList.ItemIndex + 1;

  if i2 >= DatList.Count then
    exit;

  DatList.Items.Exchange(i1, i2);
  tmpDat := M.Datchik[i1];
  M.Datchik[i1] := M.Datchik[i2];
  M.Datchik[i2] := tmpDat;
end;


procedure TVisMachineSetupForm.btnUpdateBackgroundAllClick(Sender: TObject);
begin
  popupExtra.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
end;


procedure TVisMachineSetupForm.fixLegacyTagrootAndTagnameClick(
  Sender: TObject);
var
  i, n: Integer;
  mchb: TVisMchb;
begin
  n := 0;
  for i := 0 to M.Parent.ComponentCount-1 do
    if M.Parent.Components[i] is TVisMchb then
    begin
      mchb := TVisMchb(M.Parent.Components[i]);
      if (mchb.TagRoot = '') and (mchb.TagName <> '') then
      begin
        mchb.TagRoot := mchb.TagName;
        mchb.TagName := '^';
        inc(n);
      end;
    end;

  ShowMessage(': ' + IntToStr(n));
end;


procedure TVisMachineSetupForm.mnRepaintClick(Sender: TObject);
var
  i: Integer;
  mchb: TCustomScadaObject;
begin
  M.Parent.Invalidate;
  Application.ProcessMessages;
  for i := 0 to M.Parent.ComponentCount-1 do
    if M.Parent.Components[i] is TCustomScadaObject then
    begin
      mchb := TCustomScadaObject(M.Parent.Components[i]);
      mchb.Invalidate;
    end;
  D.Designer.Modified;
  Modify;
//  M.Parent.Repaint;
end;



procedure TVisMachineSetupForm.btLabelUpClick(Sender: TObject);
begin
  udLabelY.Position := 3;
end;

procedure TVisMachineSetupForm.btLabelDownClick(Sender: TObject);
begin
  udLabelY.Position := M.Height - M.LabelObj.Height - 3;
end;

procedure TVisMachineSetupForm.btLabelLeftClick(Sender: TObject);
begin
  udLabelX.Position := 6;
end;

procedure TVisMachineSetupForm.btLabelRightClick(Sender: TObject);
begin
  udLabelX.Position := M.Width - M.LabelObj.Width - 6;
end;

procedure TVisMachineSetupForm.btAdjustSizeClick(Sender: TObject);
begin
  udMachSX.Position := Max(M.ImageObj.Left + M.ImageObj.Width, M.LabelObj.Left + M.LabelObj.Width + 6);
  udMachSY.Position := Max(M.ImageObj.Top + M.ImageObj.Height, M.LabelObj.Top + M.LabelObj.Height + 3);
end;

procedure TVisMachineSetupForm.btAddSensorRksClick(Sender: TObject);
begin
  AddSensor('', '_RKS', stCircle, 0, 7, 7);
end;

procedure TVisMachineSetupForm.btAddSensorPdpClick(Sender: TObject);
begin
  AddSensor('', '_Pdp', stRectangle, 0, 8, 6);
end;

procedure TVisMachineSetupForm.btAddSensorTokClick(Sender: TObject);
begin
  AddSensor('~div10', '_Tok', stRectangle, 0, 5, 5);
end;

procedure TVisMachineSetupForm.btAddSensorCepClick(Sender: TObject);
begin
  AddSensor(' ', '_Cep', stRectangle, 0, 6, 9);
end;

procedure TVisMachineSetupForm.btAddSensorPClick(Sender: TObject);
begin
  AddSensor('~div10', '_P', stCircle, 1, 8, 8);
end;

procedure TVisMachineSetupForm.btAddSensorTClick(Sender: TObject);
begin
  AddSensor('~div10', '_T', stCircle, 1, 8, 8);
end;

procedure TVisMachineSetupForm.btAddSensorRunClick(Sender: TObject);
begin
  AddSensor('', '_Run', stRectangle, 1, 8, 8);
end;

procedure TVisMachineSetupForm.btAddSensorAlmClick(Sender: TObject);
begin
  AddSensor('', '_Alm', stRectangle, 0, 8, 8);
end;

procedure TVisMachineSetupForm.btAddSensorDuClick(Sender: TObject);
begin
  AddSensor('', '_DU', stRectangle, 1, 8, 6);
end;

procedure TVisMachineSetupForm.btAddSensorDsuClick(Sender: TObject);
begin
  AddSensor('', '_DSU', stRectangle, 1, 8, 6);
end;

procedure TVisMachineSetupForm.btAddSensorDvuClick(Sender: TObject);
begin
  AddSensor('', '_DVU', stRectangle, 1, 8, 6);
end;

procedure TVisMachineSetupForm.btAddSensorDnuClick(Sender: TObject);
begin
  AddSensor('', '_DNU', stRectangle, 1, 8, 6);
end;

procedure TVisMachineSetupForm.btAddSensorLntClick(Sender: TObject);
begin
  AddSensor(' ', '_Lnt', stRectangle, 0, 11, 6);
end;

procedure TVisMachineSetupForm.DatNameEditDblClick(Sender: TObject);
begin
  ShowMessage(DatNameEdit.Hint);
end;

procedure TVisMachineSetupForm.btAddSensorEmptyClick(Sender: TObject);
begin
  AddSensor('', '', stRectangle, 0, 8, 6);
end;

procedure TVisMachineSetupForm.btCopySensorClick(Sender: TObject);
var
  p: PVisMachineDat;
begin
  if (DatList.ItemIndex < 0) or (DatList.ItemIndex >= M.DatCount) then
    Exit;

  p := M.Datchik[DatList.ItemIndex];
  AddSensor(p.Name, p.TagPostfix, p.Shape.Shape, p.ColorScheme, p.Shape.Width, p.Shape.Height);
end;


procedure TVisMachineSetupForm.PicNameEditChange(Sender: TObject);
var
  fname: string;
begin
  fname := VisImagesPath + PicNameEdit.Text;

  if FileExists(fname) then begin
    PicNameEdit.Hint := PicNameEdit.Text;

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(fname);
    M.ImageObj.Picture.LoadFromFile(fname);
    ImagePanel.Color := clBtnFace;

    udImageSX.Position := M.ImageObj.Picture.Width;
    udImageSY.Position := M.ImageObj.Picture.Height;
    SetImageSize;

    Modify;
  end;  
end;

end.



