unit VisMchb;

interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, VisMcha;


type

  TVisMchb = class(TVisMcha)
  private
    FUseScadaObjectClick: boolean;

  protected
    procedure OnDeviceMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure ScadaObjectClick(Sender: TObject);
  published
    property OnScadaObjectClick;
    property UseScadaObjectClick: boolean read FUseScadaObjectClick write FUseScadaObjectClick;
  end;



procedure Register;

implementation
uses
  UserControlEx,
  main,
  numbers,
  ExtDlgs,
  VisMchbControlPanel;

procedure Register;
begin
  RegisterComponents('Scada', [TVisMchb]);
end;


{ TVisMchb }

constructor TVisMchb.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  TypeName1 := 'MCHB';
  TypeName2 := 'MDTA';

  ImageObj.OnClick := ScadaObjectClick;
  LabelObj.OnClick := ScadaObjectClick;

  UseScadaObjectClick := true;
end;



procedure TVisMchb.OnDeviceMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ScadaObjectClick(sender);
end;


procedure TVisMchb.ScadaObjectClick(Sender: TObject);
begin
  if UseScadaObjectClick then begin

    if VisMchbControlPanelForm=nil then
      VisMchbControlPanelForm := TVisMchbControlPanelForm.Create(Form1);

    VisMchbControlPanelForm.M := self;

    if Assigned(OnScadaObjectClick) then
      OnScadaObjectClick(self, self, TForm(VisMchbControlPanelForm) );

  end else begin
    if Assigned(OnClick) then
      OnClick(self);
  end;
end;

end.
