unit VisMchbControlConfirm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TVisMchbControlConfirmForm = class(TForm)
    Label1: TLabel;
    Label4: TLabel;
    Shape1: TShape;
    Label5: TLabel;
    btOk: TBitBtn;
    Bevel1: TBevel;
    cbNeedBeep: TCheckBox;
    btCancel: TBitBtn;
    Bevel2: TBevel;
    procedure FormActivate(Sender: TObject);
  public
    mes: string;
  end;


  function DoVisMchbControlConfirm(mes: string; var needBeep: boolean): boolean;

var
  VisMchbControlConfirmForm: TVisMchbControlConfirmForm;
  lastNeedBeep: boolean = true;

implementation
uses
  VisMchbControlPanel,
  RpVisualGlobal,
  RpVisualUtils,
  RpSysUtils,
  _PrjProcs,
  tagstorage;

{$R *.dfm}

function DoVisMchbControlConfirm(mes: string; var needBeep: boolean): boolean;
begin
  if SuperMasterMode then begin
    result := true;
    needBeep := false;
    exit;
  end;

  VisMchbControlConfirmForm := TVisMchbControlConfirmForm.Create(nil);
  try
    VisMchbControlConfirmForm.mes := mes;

    result := VisMchbControlConfirmForm.ShowModal = mrOk;
    if result then begin
      needBeep := VisMchbControlConfirmForm.cbNeedBeep.checked;
      lastNeedBeep := needBeep;
    end;


  finally
    VisMchbControlConfirmForm.Free;
  end;
end;


procedure TVisMchbControlConfirmForm.FormActivate(Sender: TObject);
begin
  Label1.Caption := ' ' + mes + '?';
  cbNeedBeep.Checked := lastNeedBeep;
end;


end.
