unit VisMchbMdtaControlPanel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, VisButton, ScadaBase, VisLabel, ExtCtrls,
  VisNumericPanel, VisMchb, VisMachine, VisControl;

type
  TVisMchbMdtaControlPanelForm = class(TForm)
    pnlDeviceName: TPanel;
    Panel3: TPanel;
    Bevel5: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    lbControl: TVisLabel;
    btBlok: TVisButton;
    pnlValue: TVisNumericPanel;
    procedure btBlokDownChange(Sender: TObject);
    procedure btBlokClick(Sender: TObject);
    procedure pnlDeviceNameClick(Sender: TObject);
    procedure btBlokCanClick(Sender: TObject; var Can: Boolean);
    procedure Init(Datchik: PVisMachineDat);
    procedure lbControlProcess(Sender: TObject);
  private
    { Private declarations }
    ColorScheme: integer;
  public
    M: TVisMchb;
    tagname: string;
    tagpostfix: string;
  end;


implementation
uses
  VisMchbControlPanel,
  RpVisualGlobal,
  RpVisualUtils,
  numbers,
  UserControlEx,
  users,
  MesConst,
  TrendWindow,
  meslogging;

{$R *.dfm}

procedure TVisMchbMdtaControlPanelForm.Init(Datchik: PVisMachineDat);
var
  k: integer;
  s: string;
begin
  ColorScheme := Datchik.ColorScheme;
  
  s := lbControl.Script.Text;
  k := Pos('//mode', s);
  Delete(s,1,k-1);

  lbControl.Script.Text := 'const m=' + IntToStr(Datchik.ColorScheme) + ';' + s;

  tagpostfix := Datchik.TagPostfix;
  tagname := M.TagPath + '.' + M.TypeName2 + '_' + repl(M.TagName, M.TagIdRoot, M.TagRoot) + TagPostfix + '_';

  pnlDeviceName.Caption := removeModifiers(Datchik.Name);
  SetPathRootScadaObjects(self, M.TagPath, M.TagRoot + Datchik.TagPostfix );

  if hasModifier('DIV10', Datchik.Name) then begin
    pnlValue.ValueDiv := 10;
    pnlValue.Precision := 1;
  end else 
  if hasModifier('DIV100', Datchik.Name) then begin
    pnlValue.ValueDiv := 100;
    pnlValue.Precision := 2;
  end else 
  if hasModifier('DIV1000', Datchik.Name) then begin
    pnlValue.ValueDiv := 1000;
    pnlValue.Precision := 3;
  end else 
  if hasModifier('TOK', Datchik.Name) then begin
    pnlValue.ValueDiv := 1000;
    pnlValue.Precision := 1;
  end else begin
    pnlValue.ValueDiv := 1;
    pnlValue.Precision := 0;
  end;

end;

procedure TVisMchbMdtaControlPanelForm.btBlokDownChange(
  Sender: TObject);
begin
  with Sender as TVisButton do
    if objButton.Down then
      objButton.Font.Style := [fsBold]
    else
      objButton.Font.Style := [];
end;

procedure TVisMchbMdtaControlPanelForm.btBlokClick(Sender: TObject);
var
  text: string;
begin
  with sender as TVisButton do begin
    text := Hint;
    if Sender = btBlok then begin
      if( objButton.Down ) then
        text := text + ' '
      else
        text := text + ' ';
    end;
    SaveMessageText(mcMode_text, M.DeviceName + ' ' + pnlDeviceName.Caption, text, mcMode_bc, mcMode_fc);
  end;    
end;

procedure TVisMchbMdtaControlPanelForm.pnlDeviceNameClick(Sender: TObject);
var
  expr: string;
begin
  expr := '';
  if pnlValue.ValueDiv > 1 then begin
    expr := '~CAST(^ AS FLOAT)/' + inttostr(pnlValue.ValueDiv);
  end;

  ShowTrendWindow(
    M.DeviceName + ' ' + pnlDeviceName.Caption,
    tagname + 'Sost;' + tagname + 'Value' + expr,
    ';.',
    'mdta'+tagpostfix,
    '',
    ': '#13+
    '  0 -   '#13+
    '  1 -   '#13+
    '  2 -   , '#13+
    '  3 -   , '#13+
    '  4 -   ,  '
  );
end;

procedure TVisMchbMdtaControlPanelForm.btBlokCanClick(Sender: TObject;
  var Can: Boolean);
begin
  if isModeUserEx then
    Can := isPermitted(M.ClassName + '/' + M.DeviceName + '/' + pnlDeviceName.Caption + '/')
  else
    Can := CheckAccess(PREVILEG_BLOK, true);
end;

procedure TVisMchbMdtaControlPanelForm.lbControlProcess(Sender: TObject);
var
  cl: TColor;
  value: integer;
begin
  cl := lbControl.objShape.Brush.Color;
  value := lbControl.Tags[0].value;

  if value = 0 then
    cl := clBtnFace
  else
  if value = 4 then
    cl := clYellow
  else
    cl := M.calcDatColor(value, ColorScheme, cl);

  lbControl.objShape.Brush.Color := cl;
end;


end.
