unit VisMits;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, VisMachine, VisMcha; //VisVespC;


type
  TVisMits = class(TVisMcha)
  protected
    FTagMitsEnable: integer;
    FTagMitsSost: integer;
    FTagMitsErrorFlag: integer;
//    procedure SetDatColor(idx, value: integer);
  public
    constructor Create(AOwner: TComponent); override;
    procedure Init; override;
    procedure Process; override;
  end;


procedure Register;

implementation
uses
  tagstorage,
  numbers,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisMits]);
end;

{ TVisDltA }

constructor TVisMits.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTagMitsEnable := -1;
  FTagMitsSost := -1;
  FTagMitsErrorFlag := -1;
end;


// INIT
procedure TVisMits.Init;
var
  i: integer;
begin
  inherited;

    FTagMitsEnable := GetTagIndex(TagPath + '.MITS_' + TagName + '_Enable');
    FTagMitsSost := GetTagIndex(TagPath + '.MITS_' + TagName + '_Sost');
    FTagMitsErrorFlag := GetTagIndex(TagPath + '.MITS_' + TagName + '_ErrorFlag');

    IsConnectionBad := (FTagMitsEnable<0) or (FTagMitsSost<0) or (FTagMitsErrorFlag<0);

    for i:=0 to DatCount-1 do with Datchik[i]^ do begin
      TagIdxOutput := GetTagIndex( format('%s.MDTA_%s%s_Sost',
          [TagPath, TagName, TagPostfix]));

      TagIdxBlok := GetTagIndex( format('%s.MDTA_%s%s_Blok',
          [TagPath, TagName, TagPostfix]));

      IsConnectionBad := (IsConnectionBad) or (TagIdxOutput<0) or (TagIdxBlok<0);
    end;


end;

// PROCESS HANDLER
procedure TVisMits.Process;
var
  value, venab, vSost, verr, valOutput, blokval, i: integer;
begin

//  if Assigned(FOnGetTagValue) then begin
    IsValueBad := false;

    venab := GetTagValue( FTagMitsEnable );
    vSost := GetTagValue( FTagMitsSost );
    verr := GetTagValue( FTagMitsErrorFlag );

    IsValueBad := IsValueBad or (venab < 0) or (vSost < 0) or (verr < 0);

    value := 0;
    if vSost = 1 then value := 1;
    if (vSost = 2) or (vSost = 3) then value := 2;
//    if verr > 0 then value := 4;
    if vSost = 4 then value := 4;
    SetImageSost(value);

    SetFrameMode( (venab and 2) );

    blokval := 0;
    for i:=0 to DatCount-1 do begin
      valOutput := GetTagValue( Datchik[i].TagIdxOutput );
      value := GetTagValue( Datchik[i].TagIdxBlok );
      IsValueBad := IsValueBad or (valOutput < 0) or (value < 0);
      blokval := blokval or value;

      SetDatColor(i, valOutput);
    end;
    SetFrameBlok(blokval);
//  end;

//  inherited;
  if (IsConnectionBad) or (IsValueBad) then
    Visible := not Visible
  else
    Visible := true;

end;






end.
