unit VisNumericPanelScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisNumericPanel, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TVisNumericPanelScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
  private
    { Private declarations }
  public
    VisNumericPanel:TVisNumericPanel;
  end;

  function ShowScriptEdit(aVisNumericPanel:TVisNumericPanel):boolean;

var
  VisNumericPanelScriptEditForm: TVisNumericPanelScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aVisNumericPanel:TVisNumericPanel):boolean;
begin
  VisNumericPanelScriptEditForm:= TVisNumericPanelScriptEditForm.Create(Application);
  with VisNumericPanelScriptEditForm do begin
    VisNumericPanel := aVisNumericPanel;
    Caption := '  - ' + aVisNumericPanel.ClassName + '.' + aVisNumericPanel.Name;  
    memo.Text := aVisNumericPanel.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aVisNumericPanel.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TVisNumericPanelScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisNumericPanel.Script.Text;
  VisNumericPanel.Script.Text:=memo.Text;
  try
    VisNumericPanel.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then VisNumericPanel.ExecuteScript;
  finally
    VisNumericPanel.Script.Text:=tmp_script;
  end;
end;

end.
