unit VisRadioButtonScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisRadioButton, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TVisRadioButtonScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
  private
    { Private declarations }
  public
    VisRadioButton:TVisRadioButton;
  end;

  function ShowScriptEdit(aVisRadioButton:TVisRadioButton):boolean;

var
  VisRadioButtonScriptEditForm: TVisRadioButtonScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aVisRadioButton:TVisRadioButton):boolean;
begin
  VisRadioButtonScriptEditForm:= TVisRadioButtonScriptEditForm.Create(Application);
  with VisRadioButtonScriptEditForm do begin
    VisRadioButton := aVisRadioButton;
    Caption := '  - ' + aVisRadioButton.ClassName + '.' + aVisRadioButton.Name;  
    memo.Text := aVisRadioButton.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aVisRadioButton.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TVisRadioButtonScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisRadioButton.Script.Text;
  VisRadioButton.Script.Text:=memo.Text;
  try
    VisRadioButton.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then VisRadioButton.ExecuteScript;
  finally
    VisRadioButton.Script.Text:=tmp_script;
  end;
end;

end.
