unit VisSeqCCheckBS;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, VisSeqc, ExtCtrls;

type
  TVisSeqCCheckBSForm = class(TForm)
    list: TListView;
    btAuto: TBitBtn;
    btStart: TBitBtn;
    btCancel: TBitBtn;
    Timer1: TTimer;
    pnlSole: TPanel;
    Shape1: TShape;
    Label1: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure btCancelClick(Sender: TObject);
    procedure btAutoClick(Sender: TObject);
    procedure listDblClick(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure listCustomDrawItem(Sender: TCustomListView; Item: TListItem;
      State: TCustomDrawState; var DefaultDraw: Boolean);
  private
    procedure setToAuto(item: TListItem);
    { Private declarations }
  public
    M: TVisSeqc;
    function buildList: integer;
  end;

var
  VisSeqCCheckBSForm: TVisSeqCCheckBSForm;

implementation
uses
  infodlg,
  VisSeqcApi,
  MesLogging,
  MesConst,
  TagStorage,
  ScadaBase;

{$R *.dfm}

procedure TVisSeqCCheckBSForm.FormActivate(Sender: TObject);
begin
  buildList;
end;


function TVisSeqCCheckBSForm.buildList: integer;
var
  i,k,v: Integer;
  s: string;
//  sole: Boolean;
begin
  list.Items.Clear;
  for i:=0 to Length(m.RootDevices)-1 do begin

    s := m.TagPath + '.' + m.RootDevices[i].devtype + '_' + m.RootDevices[i].tagname + '_Control';
    k := GetTagIndex(s);
    if k<0 then Continue;
    v := GetTagValue(k) and 3;

//    j := getDeviceUsageInfo(m.RootDevices[i].Addr, '');
//    sole := False; //((j=1) and (m.RootDevices[i].soleOwner)) or (j=2);

//    if (v > 0) or (sole) then
    if v > 0 then
      with list.Items.Add do begin
        Caption := m.RootDevices[i].Name;

        SubItems.Add('');

        SubItems.Add(s);
        Data := Pointer(k);

//        if (sole) then begin
//          SubItems.Add('1');
//          pnlSole.Visible := true;
//        end else
        SubItems.Add('');


      end;


  end;

  Timer1Timer(nil);

  Result := list.Items.Count;
end;


procedure TVisSeqCCheckBSForm.Timer1Timer(Sender: TObject);
var
  i,v,k: Integer;

  procedure _setSubItem(s: string);
  begin
    if list.Items[i].SubItems[0] <> s then
      list.Items[i].SubItems[0] := s;
  end;
  
begin
  i := 0;
  while i<list.Items.Count do
    with list.Items[i] do begin
      k := Integer(Data);
      v := GetTagValue(k) and 3;

      if v=0 then
        _setSubItem('')
      else

      if v = 3 then
        _setSubItem('')
      else
        _setSubItem('');

      Inc(i);
    end;

end;

procedure TVisSeqCCheckBSForm.btCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TVisSeqCCheckBSForm.btAutoClick(Sender: TObject);
var
  i: Integer;
begin
  if showInfoDlg('       ?', mtConfirmation,
        mbOKCancel, 0) <> mrOk then exit;

  for i:=0 to list.Items.Count-1 do
    setToAuto(list.Items[i]);
end;

procedure TVisSeqCCheckBSForm.listDblClick(Sender: TObject);
begin
  if list.Selected = nil then Exit;

  if showInfoDlg(' ' + list.Selected.Caption +'  ?', mtConfirmation,
        mbOKCancel, 0) <> mrOk then exit;

  setToAuto(list.Selected);

end;

procedure TVisSeqCCheckBSForm.setToAuto(item: TListItem);
begin
  SetTagValue( Integer(item.Data), 0 );
  SaveMessageText(mcMode_text, item.Caption, '', mcMode_bc, mcMode_fc);
end;

procedure TVisSeqCCheckBSForm.btStartClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TVisSeqCCheckBSForm.listCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Item.SubItems[2] = '1' then
    Sender.Canvas.Brush.Color := clRed
  else
    Sender.Canvas.Brush.Color := clWhite;

end;

end.
