unit VisSeqcConfigAdd;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DB, FIBDataSet, pFIBDataSet, FIBDatabase,
  pFIBDatabase, GridsEh, DBGridEh, Buttons;

type
  TVisSeqcConfigAddForm = class(TForm)
    edName: TEdit;
    Label1: TLabel;
    Button1: TButton;
    pFIBTransaction6: TpFIBTransaction;
    pFIBTransaction5: TpFIBTransaction;
    dsRootsM: TpFIBDataSet;
    dsrcRootsM: TDataSource;
    pFIBTransaction7: TpFIBTransaction;
    pFIBTransaction8: TpFIBTransaction;
    dsRootsD: TpFIBDataSet;
    dsrcRootsD: TDataSource;
    Bevel1: TBevel;
    gridRootsM: TDBGridEh;
    gridRootsD: TDBGridEh;
    db1: TpFIBDatabase;
    trn2: TpFIBTransaction;
    trn1: TpFIBTransaction;
    dsRootsDNAME: TFIBstringField;
    dsRootsDTIMESTART: TFIBIntegerField;
    dsRootsDTIMESTOP: TFIBIntegerField;
    dsRootsDORDERNUM: TFIBIntegerField;
    gridSubrootsD: TDBGridEh;
    pFIBTransaction1: TpFIBTransaction;
    pFIBTransaction2: TpFIBTransaction;
    dsSubrootsM: TpFIBDataSet;
    dsrcSubrootsM: TDataSource;
    pFIBTransaction3: TpFIBTransaction;
    pFIBTransaction4: TpFIBTransaction;
    dsSubrootsD: TpFIBDataSet;
    dsrcSubrootsD: TDataSource;
    gridSubrootsM: TDBGridEh;
    Panel1: TPanel;
    acDel: TSpeedButton;
    acAdd: TSpeedButton;
    Button2: TButton;
    dsRootsMID: TFIBIntegerField;
    dsRootsMNAME: TFIBstringField;
    dsRootsMDESCR: TFIBstringField;
    dsRootsMCODE: TFIBIntegerField;
    dsSubrootsMID: TFIBIntegerField;
    dsSubrootsMROOT_ID: TFIBIntegerField;
    dsSubrootsMSUBROOT_ID: TFIBIntegerField;
    dsSubrootsMNAME: TFIBstringField;
    dsSubrootsDNAME: TFIBstringField;
    dsSubrootsDTIMESTART: TFIBIntegerField;
    dsSubrootsDTIMESTOP: TFIBIntegerField;
    dsSubrootsDORDERNUM: TFIBIntegerField;
    pFIBTransaction9: TpFIBTransaction;
    pFIBTransaction10: TpFIBTransaction;
    dsROOTDEVICES: TpFIBDataSet;
    dsROOTDEVICESID: TFIBIntegerField;
    dsROOTDEVICESDEVICE_ID: TFIBIntegerField;
    dsROOTDEVICESTIMESTART: TFIBIntegerField;
    dsROOTDEVICESTIMESTOP: TFIBIntegerField;
    dsROOTDEVICESORDERNUM: TFIBIntegerField;
    dsSubrootsDDEVICE_ID: TFIBIntegerField;
    dsSubrootsMROOTBEGIN: TFIBIntegerField;
    dsSubrootsMROOTEND: TFIBIntegerField;
    dsRootsDDEVICE_ID: TFIBIntegerField;
    dsSubrootsDFL_ARMO: TFIBSmallIntField;
    dsSubrootsDFL_TRANSPARENT: TFIBSmallIntField;
    dsSubrootsDFL_CTRLPROD: TFIBSmallIntField;
    dsSubrootsDFL_PROD: TFIBSmallIntField;
    dsSubrootsDDLY_PRODSTOP: TFIBSmallIntField;
    dsSubrootsDFL_CTRLONLY: TFIBSmallIntField;
    dsSubrootsDFL_SOLEOWNER: TFIBSmallIntField;
    dsROOTDEVICESFL_ARMO: TFIBSmallIntField;
    dsROOTDEVICESFL_TRANSPARENT: TFIBSmallIntField;
    dsROOTDEVICESFL_CTRLPROD: TFIBSmallIntField;
    dsROOTDEVICESFL_PROD: TFIBSmallIntField;
    dsROOTDEVICESDLY_PRODSTOP: TFIBSmallIntField;
    dsROOTDEVICESFL_CTRLONLY: TFIBSmallIntField;
    dsROOTDEVICESFL_SOLEOWNER: TFIBSmallIntField;
    dsSubrootsDMODEFLAGS: TStringField;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure acAddClick(Sender: TObject);
    procedure dsrcSubrootsMDataChange(Sender: TObject; Field: TField);
    procedure acDelClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure dsSubrootsDCalcFields(DataSet: TDataSet);
  private
    procedure BuildRootDevices;
    procedure GetContactPoint;
    { Private declarations }
  public
    { Public declarations }
    db: TFIBDatabase;
    edit_mode: boolean;
    root_id: integer;

    last_device_id: integer;
    root_begin: boolean;
    root_end: boolean;

    procedure Init;
  end;

var
  VisSeqcConfigAddForm: TVisSeqcConfigAddForm;

implementation
uses
  infodlg,
  VisSeqcConfig;

{$R *.dfm}

{ TVisSeqcConfigAddForm }

procedure TVisSeqcConfigAddForm.Init;
begin
  //  
  dsRootsM.Database := db;
  dsRootsM.Transaction.DefaultDatabase := db;
  dsRootsM.UpdateTransaction.DefaultDatabase := db;

  dsRootsD.Database := db;
  dsRootsD.Transaction.DefaultDatabase := db;
  dsRootsD.UpdateTransaction.DefaultDatabase := db;

  dsSubRootsM.Database := db;
  dsSubRootsM.Transaction.DefaultDatabase := db;
  dsSubRootsM.UpdateTransaction.DefaultDatabase := db;

  dsSubRootsD.Database := db;
  dsSubRootsD.Transaction.DefaultDatabase := db;
  dsSubRootsD.UpdateTransaction.DefaultDatabase := db;

  dsROOTDEVICES.Database := db;
  dsROOTDEVICES.Transaction.DefaultDatabase := db;
  dsROOTDEVICES.UpdateTransaction.DefaultDatabase := db;

  dsRootsM.Open;
  dsRootsD.Open;

  //   ( )
  if not edit_mode then begin
    VisSeqcConfigForm.dsCurM.Append;
    VisSeqcConfigForm.dsCurMNAME.AsString := ' ';
    VisSeqcConfigForm.dsCurMSUBROOT.AsInteger := 2; //  
    VisSeqcConfigForm.dsCurM.Post;
  end else begin
    VisSeqcConfigForm.dsCurM.Edit;
    VisSeqcConfigForm.dsCurMSUBROOT.AsInteger := 2; //  
    VisSeqcConfigForm.dsCurM.Post;
  end;
  root_id := VisSeqcConfigForm.dsCurMID.AsInteger;
  edName.Text := VisSeqcConfigForm.dsCurMNAME.AsString; 

  dsSubRootsM.ParamByName('ROOT_ID').AsInteger := root_id;
  dsSubRootsM.Open;
  dsSubRootsD.Open;

  GetContactPoint;

  //     dsRootsM
end;


procedure TVisSeqcConfigAddForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if (ModalResult = mrOk) or (edit_mode) then begin
    VisSeqcConfigForm.dsCurM.Edit;
    VisSeqcConfigForm.dsCurMSUBROOT.AsInteger := 0; //   
    VisSeqcConfigForm.dsCurMNAME.AsString := edName.Text; 
    VisSeqcConfigForm.dsCurM.Post;
  end;

  if (ModalResult = mrOk) then begin
    VisSeqcConfigForm.dsCurM.Edit;
    VisSeqcConfigForm.dsCurMNAME.AsString := edName.Text;
    VisSeqcConfigForm.dsCurM.Post;
    BuildRootDevices;
  end;

  if (ModalResult = mrCancel) and (not edit_mode) then begin
    VisSeqcConfigForm.dsCurM.Delete;
  end;

end;

procedure TVisSeqcConfigAddForm.acAddClick(Sender: TObject);
var
  flag: boolean;
begin
  flag := false;
  dsSubrootsM.First;
  if not dsSubrootsM.Eof then begin

    dsRootsD.First;
    dsRootsD.Next;
    while not dsRootsD.Eof do begin
      dsSubrootsM.First;
      while not dsSubrootsM.Eof do begin
        while not dsSubrootsD.Eof do begin

          if dsRootsDDEVICE_ID.AsInteger = dsSubrootsDDEVICE_ID.AsInteger then
            flag := true;

          if flag then break;
          dsSubrootsD.Next;
        end;

        if flag then break;
        dsSubrootsM.Next;
      end;
      if flag then break;
      dsRootsD.Next;
    end;

  end;

  if flag then begin
    showInfoDlg('    "' + dsRootsDNAME.AsString + '", ' +
        '    ,   "' + dsSubrootsMNAME.AsString + '"',
        mtError, [mbOk], 0);
    exit;
  end;      

//  if dsRootsM.Eof then
  if gridRootsM.RowCount=0 then exit;
  dsSubrootsM.Append;
  dsSubrootsMROOT_ID.AsInteger := root_id;
  dsSubrootsMSUBROOT_ID.AsInteger := dsRootsMID.AsInteger;
  dsSubrootsM.Post;

  GetContactPoint;
end;

procedure TVisSeqcConfigAddForm.dsrcSubrootsMDataChange(Sender: TObject;
  Field: TField);
begin
  dsSubrootsD.Close;
  dsSubrootsD.ParamByName('SUBROOT_ID').AsInteger :=
    dsSubrootsMSUBROOT_ID.AsInteger;
  dsSubrootsD.Open;
end;

procedure TVisSeqcConfigAddForm.acDelClick(Sender: TObject);
begin
  if dsSubrootsM.Eof then exit;
  dsSubrootsM.Delete;
  dsSubrootsM.Close;
  dsSubrootsM.Open;
  dsSubrootsM.Last;

  GetContactPoint;
end;

// BUILD ROOT DEVICES
procedure TVisSeqcConfigAddForm.BuildRootDevices;
var
  i: integer;
begin
  dsROOTDEVICES.ParamByName('ROOT_ID').AsInteger := root_id;
  dsROOTDEVICES.Open;
  i:=1;

  dsSubrootsM.First;
  while not dsSubrootsM.eof do begin
    dsSubrootsD.First;
    while not dsSubrootsD.eof do begin

      // 
      if dsROOTDEVICES.Locate('DEVICE_ID', dsSubrootsDDEVICE_ID.AsInteger, []) then begin
        dsROOTDEVICES.Edit;
      end else begin
        dsROOTDEVICES.Append;
      end;
      dsROOTDEVICESDEVICE_ID.AsInteger := dsSubrootsDDEVICE_ID.AsInteger;
      dsROOTDEVICESTIMESTART.AsInteger := dsSubrootsDTIMESTART.AsInteger;
      dsROOTDEVICESTIMESTOP.AsInteger := dsSubrootsDTIMESTOP.AsInteger;
      dsROOTDEVICESFL_ARMO.AsInteger := dsSubrootsDFL_ARMO.AsInteger;
      dsROOTDEVICESFL_TRANSPARENT.AsInteger := dsSubrootsDFL_TRANSPARENT.AsInteger;
      dsROOTDEVICESFL_CTRLPROD.AsInteger := dsSubrootsDFL_CTRLPROD.AsInteger;
      dsROOTDEVICESFL_PROD.AsInteger := dsSubrootsDFL_PROD.AsInteger;
      dsROOTDEVICESFL_CTRLONLY.AsInteger := dsSubrootsDFL_CTRLONLY.AsInteger;
      dsROOTDEVICESFL_SOLEOWNER.AsInteger := dsSubrootsDFL_SOLEOWNER.AsInteger;
      dsROOTDEVICESDLY_PRODSTOP.AsInteger := dsSubrootsDDLY_PRODSTOP.AsInteger;
      dsROOTDEVICES.Post;

      dsROOTDEVICES.Edit;
      dsROOTDEVICESORDERNUM.AsInteger := i+1000;
      dsROOTDEVICES.Post;

      dsSubrootsD.Next;
      inc(i);
    end;
    dsSubrootsM.Next;
  end;
  dsROOTDEVICES.Close;
  dsROOTDEVICES.Transaction.Commit;


  dsROOTDEVICES.Database.Execute('DELETE FROM ROOTDEVICES WHERE (ORDERNUM<1000) and (ROOT_ID='+inttostr(root_id)+')');
  dsROOTDEVICES.Database.Execute('UPDATE ROOTDEVICES SET ORDERNUM=ORDERNUM-1000 WHERE ORDERNUM>=1000');
end;

procedure TVisSeqcConfigAddForm.GetContactPoint;
var
  i: integer;
  s: string;
begin
  i := dsSubrootsMID.AsInteger;

  dsSubrootsM.Last;

  //  
  if dsSubrootsM.Bof then begin
    last_device_id := 0;
    root_begin := true;
    root_end := false;
    s := 'ROOTBEGIN=1';
  end else

  //  
  if dsSubrootsMROOTEND.AsInteger>0 then begin
    last_device_id := 0;
    root_begin := false;
    root_end := true;
    s := 'ROOTEND=1';
  end else

  begin
    dsSubrootsD.Last;
    last_device_id := dsSubrootsDDEVICE_ID.AsInteger;
    root_begin := false;
    root_end := false;
    s := '(ROOTBEGIN=0) AND (LAST_DEVICE_ID='+inttostr(last_device_id)+')';;
  end;

  dsSubrootsM.Locate('ID', i, []);


  dsRootsM.Close;
  dsRootsM.SelectSQL.Strings[dsRootsM.SelectSQL.Count-2] := ' AND ('+s+')';

  if root_end then begin
    gridSubrootsM.Color := $009BFF9B;
    gridSubrootsD.Color := $009BFF9B;
  end else begin
    gridSubrootsM.Color := clWindow;
    gridSubrootsD.Color := clWindow;
    dsRootsM.Open;
  end;

end;

procedure TVisSeqcConfigAddForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
{
  if ModalResult = mrOk then
    if not root_end then
      if MessageDlg('   . ?',
            mtConfirmation, [mbYes, mbNo], 0) = mrNo then
        CanClose := false;
}        
end;

procedure TVisSeqcConfigAddForm.dsSubrootsDCalcFields(DataSet: TDataSet);
var
  s: string;
begin
  s := '';
  if DataSet.FieldByName('FL_CTRLONLY').AsInteger>0 then s := s + '';

  if DataSet.FieldByName('FL_ARMO').AsInteger>0 then s := s + '';

  if DataSet.FieldByName('FL_TRANSPARENT').AsInteger=1 then s := s + ' ';
  if DataSet.FieldByName('FL_TRANSPARENT').AsInteger=2 then s := s + ' ';
  if DataSet.FieldByName('FL_TRANSPARENT').AsInteger=3 then s := s + ' ';

  if DataSet.FieldByName('FL_CTRLPROD').AsInteger>0 then s := s + '';

  if DataSet.FieldByName('FL_PROD').AsInteger>0 then s := s + '';

  if (DataSet.FieldByName('FL_PROD').AsInteger>0) and
        (DataSet.FieldByName('DLY_PRODSTOP').AsInteger>0)
  then
    s := s + DataSet.FieldByName('DLY_PRODSTOP').AsString;

  if DataSet.FieldByName('FL_SOLEOWNER').AsInteger>0 then s := s + '';

  DataSet.FieldByName('MODEFLAGS').AsString := s;
end;

end.
