unit VisSeqcSetup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisSeqc, StdCtrls, Buttons, Mask, ExtCtrls;

type
  TVisSeqcSetupForm = class(TForm)
    Panel1: TPanel;
    Label3: TLabel;
    Label20: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    edTagname_Seqc: TMaskEdit;
    TagPathEdit: TMaskEdit;
    edTagIdRoot: TMaskEdit;
    edTagRoot: TMaskEdit;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    Label1: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    ComboBox1: TComboBox;
    Panel2: TPanel;
    Label7: TLabel;
    Label9: TLabel;
    edDBNameParam: TMaskEdit;
    Panel3: TPanel;
    Label8: TLabel;
    Label10: TLabel;
    edFilterAdd: TMaskEdit;
    Label11: TLabel;
    edFilterDel: TMaskEdit;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    M: TVisSeqc;
    D: TVisSeqcEditor;
  end;

var
  VisSeqcSetupForm: TVisSeqcSetupForm;

implementation
uses
  inifiles;


{$R *.dfm}

procedure TVisSeqcSetupForm.FormActivate(Sender: TObject);
begin
  Caption := ' ' + M.ClassName;
  edTagRoot.Text := M.TagRoot;
  edTagIdRoot.Text := M.TagIdRoot;
  TagPathEdit.Text := M.TagPath;
  edTagname_Seqc.Text := M.Tagname_Seqc;
  edDBNameParam.Text := M.DBNameParam;
  edFilterAdd.Text := M.FilterAdd;
  edFilterDel.Text := M.FilterDel;
end;

procedure TVisSeqcSetupForm.FormCreate(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisMachine', 'Left', 6);
    Top := ReadInteger('VisMachine', 'Top', 4);
    Free;
  end;
end;

procedure TVisSeqcSetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisMachine', 'Left', Left);
    WriteInteger('VisMachine', 'Top', Top);
    Free;
  end;
end;

procedure TVisSeqcSetupForm.OkButtonClick(Sender: TObject);
begin
  M.TagRoot := edTagRoot.Text;
  M.TagIdRoot := edTagIdRoot.Text;
  M.TagPath := TagPathEdit.Text;
  M.Tagname_Seqc := edTagname_Seqc.Text;
  M.DBNameParam := edDBNameParam.Text;
  M.FilterAdd := edFilterAdd.Text;
  M.FilterDel := edFilterDel.Text;
  D.Designer.Modified;
  modalresult := mrOk;
end;

end.
