unit VisSeqdControl;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisButton, VisLabel, VisDataboard, ExtCtrls,
  VisControl;

const
  SEQD_NOSUSP = 1;

type
  TSeqdControlForm = class(TForm)

    btStart: TVisButton;
    btStop: TVisButton;
    lbName: TLabel;
    btSusp: TVisButton;
    dbrd: TVisDataboard;
    lbMesReady: TVisLabel;
    pnl1: TPanel;
    btEmrg: TVisButton;
    btCancel: TVisButton;
    procedure dbrdProcess(Sender: TObject);
    procedure btCanClick(Sender: TObject; var Can: Boolean);
    procedure btStartClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure btCancelClick(Sender: TObject);
    procedure btEmrgClick(Sender: TObject);

    procedure SaveMessageScadaObjectClick(Sender: TObject);
  private
    function hasFlag(fl: Integer): boolean;
  public
    tagpath: String;
    tagroot: String;
    flags: integer;
  end;

  function createVisSeqdControl(pnl: TWinControl; TagPath: string; TagRoot: string; SeqdName: string; flags: Integer = 0): TSeqdControlForm;
  function getSeqdNameByTagroot(tagroot: string): string;

var
  SeqdList: TStringList;

implementation

uses
  MesLogging,
  UserControlEx,
  TagStorage,
  _PrjProcs,
  RpVisualLegacyPanels,
  RpVisualMain,
  RpVisualGlobal,
  RpVisualUtils,
  Buttons;


var
  _TagPath: string;
  _TagRoot: string;

{$R *.dfm}


procedure _initproc(Target: TCustomScadaObject);
begin
  Target.TagPath := _TagPath;
  Target.TagRoot := _TagRoot;
end;


function createVisSeqdControl(pnl: TWinControl; TagPath: string; TagRoot: string; SeqdName: string; flags: Integer = 0): TSeqdControlForm;

  procedure _btnhint(visbtn: TVisButton);
  begin
    visbtn.Hint := SeqdName + ' - ' + visbtn.objButton.Caption;
  end;

var
  w: TSeqdControlForm;
 // s: string;
begin


  // create window
  w := TSeqdControlForm.Create(pnl);
  w.tagpath := TagPath;
  w.tagroot := TagRoot;
  w.Parent := pnl;
  w.Align := alClient;
  w.Visible := true;
  w.BorderStyle := bsNone;
  w.Show;
  if pnl is TPanel then
    w.Color := (pnl as TPanel).Color;
  result := w;

  // init scada controls
  if TagPath = '' then
    TagPath := _PrjCodeName;
  _TagPath := TagPath;
  _TagRoot := TagRoot;
  CustomScanScadaObjects(w, _initproc);
  CustomScanScadaObjects(w, InitDeviceProc);

  w.lbName.Caption := SeqdName;
  w.dbrd.Caption := SeqdName;
  w.dbrd.Hint := SeqdName;
  _btnhint(w.btStart);
  _btnhint(w.btStop);
  _btnhint(w.btSusp);
  _btnhint(w.btEmrg);
  _btnhint(w.btCancel);

  w.btCancel.Visible := False;
  w.btSusp.Visible := False;
  w.flags := flags;

  SeqdList.AddObject(TagRoot, w);
end;


function TSeqdControlForm.hasFlag(fl: Integer): boolean;
begin
  result := ( flags and fl ) > 0;
end;


procedure TSeqdControlForm.dbrdProcess(Sender: TObject);
var
  sost, stopDlyCnt: Integer;

begin
  sost := dbrd.Tags[0].value;
  stopDlyCnt := dbrd.Tags[2].value;
  btStart.objButton.Enabled := sost in [0,2,6];
  btSusp.Visible := (sost = 3) and not(hasFlag(SEQD_NOSUSP));
  btStop.objButton.Enabled := sost in [1,2,3,4,6];
  btEmrg.objButton.Enabled := sost > 0;

  btCancel.Visible := (stopDlyCnt > 0) and (stopDlyCnt < 65535);
end;

procedure TSeqdControlForm.btCanClick(Sender: TObject;
  var Can: Boolean);
begin
  if isModeUserEx then 
    Can := isPermitted(ClassName + '~' + lbName.Caption + '~' + (Sender as TVisButton).CaptionDown);
end;

procedure TSeqdControlForm.btStartClick(Sender: TObject);
begin
  SaveMessageText(' ', lbName.Caption, '', 8421376, 16777215);
end;

procedure TSeqdControlForm.btStopClick(Sender: TObject);
begin
  SaveMessageText(' ', lbName.Caption, '', 4210688, 255);
end;

procedure TSeqdControlForm.btCancelClick(Sender: TObject);
begin
  SaveMessageText(' ', lbName.Caption, '', 4210688, 255);
end;

procedure TSeqdControlForm.btEmrgClick(Sender: TObject);
begin
  SaveMessageText(' ', lbName.Caption, '', 4210688, clRed);
end;

procedure TSeqdControlForm.SaveMessageScadaObjectClick(Sender: TObject);
begin
  with Sender as TVisButton do
    _SaveMessageScadaObject(Sender, CaptionDown + ' ', $000080FF);
end;


function getSeqdNameByTagroot(tagroot: string): string;
var
  i: integer;
begin
  if SeqdList.Find(tagroot, i) then
    result := TSeqdControlForm(SeqdList.Objects[i]).lbName.Caption
  else
    result := '';
end;

initialization
  SeqdList := TStringList.Create;
  SeqdList.Sorted := true;

finalization
  SeqdList.Free;

end.
